/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Util;

public abstract class BitmapTransformation
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;

    public BitmapTransformation(Context context) {
        this(Glide.get((Context)context).getBitmapPool());
    }

    public BitmapTransformation(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
    }

    protected abstract Bitmap transform(BitmapPool var1, Bitmap var2, int var3, int var4);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Resource<Bitmap> transform(Resource<Bitmap> bitmapResource, int n2, int n3) {
        Bitmap bitmap;
        if (!Util.isValidDimensions((int)n2, (int)n3)) {
            throw new IllegalArgumentException("Cannot apply transformation on width: " + n2 + " or height: " + n3 + " less than or equal to zero and not Target.SIZE_ORIGINAL");
        }
        Bitmap bitmap2 = (Bitmap)bitmapResource.get();
        int n4 = n2;
        if (n2 == Integer.MIN_VALUE) {
            n4 = bitmap2.getWidth();
        }
        n2 = n3;
        if (n3 == Integer.MIN_VALUE) {
            n2 = bitmap2.getHeight();
        }
        if (!bitmap2.equals(bitmap = this.transform(this.bitmapPool, bitmap2, n4, n2))) return BitmapResource.obtain(bitmap, this.bitmapPool);
        return bitmapResource;
    }
}

