/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.manager.ApplicationLifecycle;
import com.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.RequestManagerFragment;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.SupportRequestManagerFragment;
import com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    static final String FRAGMENT_TAG = "com.bumptech.glide.manager";
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private static final RequestManagerRetriever INSTANCE = new RequestManagerRetriever();
    private static final String TAG = "RMRetriever";
    private volatile RequestManager applicationManager;
    private final Handler handler;
    final Map<android.app.FragmentManager, RequestManagerFragment> pendingRequestManagerFragments = new HashMap<android.app.FragmentManager, RequestManagerFragment>();
    final Map<FragmentManager, SupportRequestManagerFragment> pendingSupportRequestManagerFragments = new HashMap<FragmentManager, SupportRequestManagerFragment>();

    RequestManagerRetriever() {
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    public static RequestManagerRetriever get() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RequestManager getApplicationManager(Context object) {
        if (this.applicationManager == null) {
            synchronized (this) {
                if (this.applicationManager == null) {
                    RequestManager requestManager;
                    Context context = object.getApplicationContext();
                    ApplicationLifecycle applicationLifecycle = new ApplicationLifecycle();
                    object = new EmptyRequestManagerTreeNode();
                    this.applicationManager = requestManager = new RequestManager(context, (Lifecycle)applicationLifecycle, (RequestManagerTreeNode)object);
                }
            }
        }
        return this.applicationManager;
    }

    @TargetApi(value=11)
    RequestManager fragmentGet(Context context, android.app.FragmentManager fragmentManager) {
        RequestManagerFragment requestManagerFragment = this.getRequestManagerFragment(fragmentManager);
        RequestManager requestManager = requestManagerFragment.getRequestManager();
        fragmentManager = requestManager;
        if (requestManager == null) {
            fragmentManager = new RequestManager(context, (Lifecycle)requestManagerFragment.getLifecycle(), requestManagerFragment.getRequestManagerTreeNode());
            requestManagerFragment.setRequestManager((RequestManager)fragmentManager);
        }
        return fragmentManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=11)
    public RequestManager get(Activity activity) {
        if (Util.isOnBackgroundThread()) return this.get(activity.getApplicationContext());
        if (Build.VERSION.SDK_INT < 11) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed(activity);
        return this.fragmentGet((Context)activity, activity.getFragmentManager());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=17)
    public RequestManager get(Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread()) return this.get(fragment.getActivity().getApplicationContext());
        if (Build.VERSION.SDK_INT < 17) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        android.app.FragmentManager fragmentManager = fragment.getChildFragmentManager();
        return this.fragmentGet((Context)fragment.getActivity(), fragmentManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestManager get(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (!Util.isOnMainThread()) return this.getApplicationManager(context);
        if (context instanceof Application) return this.getApplicationManager(context);
        if (context instanceof FragmentActivity) {
            return this.get((FragmentActivity)context);
        }
        if (context instanceof Activity) {
            return this.get((Activity)context);
        }
        if (!(context instanceof ContextWrapper)) return this.getApplicationManager(context);
        return this.get(((ContextWrapper)context).getBaseContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestManager get(android.support.v4.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        return this.supportFragmentGet((Context)fragment.getActivity(), fragmentManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestManager get(FragmentActivity fragmentActivity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(fragmentActivity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)fragmentActivity);
        return this.supportFragmentGet((Context)fragmentActivity, fragmentActivity.getSupportFragmentManager());
    }

    @TargetApi(value=17)
    RequestManagerFragment getRequestManagerFragment(android.app.FragmentManager fragmentManager) {
        RequestManagerFragment requestManagerFragment;
        RequestManagerFragment requestManagerFragment2 = requestManagerFragment = (RequestManagerFragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (requestManagerFragment == null) {
            requestManagerFragment2 = requestManagerFragment = this.pendingRequestManagerFragments.get(fragmentManager);
            if (requestManagerFragment == null) {
                requestManagerFragment2 = new RequestManagerFragment();
                this.pendingRequestManagerFragments.put(fragmentManager, requestManagerFragment2);
                fragmentManager.beginTransaction().add((Fragment)requestManagerFragment2, FRAGMENT_TAG).commitAllowingStateLoss();
                this.handler.obtainMessage(1, (Object)fragmentManager).sendToTarget();
            }
        }
        return requestManagerFragment2;
    }

    SupportRequestManagerFragment getSupportRequestManagerFragment(FragmentManager fragmentManager) {
        SupportRequestManagerFragment supportRequestManagerFragment;
        SupportRequestManagerFragment supportRequestManagerFragment2 = supportRequestManagerFragment = (SupportRequestManagerFragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (supportRequestManagerFragment == null) {
            supportRequestManagerFragment2 = supportRequestManagerFragment = this.pendingSupportRequestManagerFragments.get(fragmentManager);
            if (supportRequestManagerFragment == null) {
                supportRequestManagerFragment2 = new SupportRequestManagerFragment();
                this.pendingSupportRequestManagerFragments.put(fragmentManager, supportRequestManagerFragment2);
                fragmentManager.beginTransaction().add((android.support.v4.app.Fragment)supportRequestManagerFragment2, FRAGMENT_TAG).commitAllowingStateLoss();
                this.handler.obtainMessage(2, (Object)fragmentManager).sendToTarget();
            }
        }
        return supportRequestManagerFragment2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean handleMessage(Message message) {
        void var4_5;
        Object var2_2 = null;
        boolean bl = true;
        switch (message.what) {
            default: {
                bl = false;
                Object var4_4 = null;
                message = var2_2;
                break;
            }
            case 1: {
                message = (android.app.FragmentManager)message.obj;
                RequestManagerFragment requestManagerFragment = this.pendingRequestManagerFragments.remove(message);
                break;
            }
            case 2: {
                message = (FragmentManager)message.obj;
                SupportRequestManagerFragment supportRequestManagerFragment = this.pendingSupportRequestManagerFragments.remove(message);
            }
        }
        if (bl && var4_5 == null && Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to remove expected request manager fragment, manager: " + message));
        }
        return bl;
    }

    RequestManager supportFragmentGet(Context context, FragmentManager fragmentManager) {
        SupportRequestManagerFragment supportRequestManagerFragment = this.getSupportRequestManagerFragment(fragmentManager);
        RequestManager requestManager = supportRequestManagerFragment.getRequestManager();
        fragmentManager = requestManager;
        if (requestManager == null) {
            fragmentManager = new RequestManager(context, (Lifecycle)supportRequestManagerFragment.getLifecycle(), supportRequestManagerFragment.getRequestManagerTreeNode());
            supportRequestManagerFragment.setRequestManager((RequestManager)fragmentManager);
        }
        return fragmentManager;
    }
}

