/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final LinkedHashMap<T, Y> cache = new LinkedHashMap(100, 0.75f, true);
    private int currentSize = 0;
    private final int initialMaxSize;
    private int maxSize;

    public LruCache(int n2) {
        this.initialMaxSize = n2;
        this.maxSize = n2;
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    public void clearMemory() {
        this.trimToSize(0);
    }

    public boolean contains(T t2) {
        return this.cache.containsKey(t2);
    }

    public Y get(T t2) {
        return this.cache.get(t2);
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    protected int getSize(Y y2) {
        return 1;
    }

    protected void onItemEvicted(T t2, Y y2) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Y put(T object, Y y2) {
        void var1_3;
        void var2_5;
        if (this.getSize(var2_5) >= this.maxSize) {
            this.onItemEvicted(object, var2_5);
            return var1_3;
        }
        void var1_4 = this.cache.put(object, var2_5);
        if (var2_5 != null) {
            this.currentSize += this.getSize(var2_5);
        }
        if (var1_4 != null) {
            this.currentSize -= this.getSize(var1_4);
        }
        this.evict();
        return var1_3;
    }

    public Y remove(T object) {
        if ((object = this.cache.remove(object)) != null) {
            this.currentSize -= this.getSize(object);
        }
        return (Y)object;
    }

    public void setSizeMultiplier(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * f2);
        this.evict();
    }

    protected void trimToSize(int n2) {
        while (this.currentSize > n2) {
            Map.Entry<Object, Object> entry = this.cache.entrySet().iterator().next();
            Y y2 = entry.getValue();
            this.currentSize -= this.getSize(y2);
            entry = entry.getKey();
            this.cache.remove(entry);
            this.onItemEvicted(entry, y2);
        }
    }
}

