/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.os.SystemClock;
import com.common.gmacs.downloader.AuthFailureError;
import com.common.gmacs.downloader.ByteArrayPool;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.HttpStack;
import com.common.gmacs.downloader.Network;
import com.common.gmacs.downloader.NetworkError;
import com.common.gmacs.downloader.NetworkResponse;
import com.common.gmacs.downloader.NoConnectionError;
import com.common.gmacs.downloader.PoolingByteArrayOutputStream;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.RetryPolicy;
import com.common.gmacs.downloader.ServerError;
import com.common.gmacs.downloader.TimeoutError;
import com.common.gmacs.downloader.URLHttpResponse;
import com.common.gmacs.downloader.VolleyError;
import com.common.gmacs.downloader.VolleyLog;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BasicNetwork
implements Network {
    protected static final boolean DEBUG = VolleyLog.DEBUG;
    private static int DEFAULT_POOL_SIZE = 4096;
    protected final HttpStack mHttpStack;
    protected final ByteArrayPool mPool;

    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(DEFAULT_POOL_SIZE));
    }

    public BasicNetwork(HttpStack httpStack, ByteArrayPool byteArrayPool) {
        this.mHttpStack = httpStack;
        this.mPool = byteArrayPool;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addCacheHeaders(Map<String, String> map, Cache.Entry object) {
        if (object == null) {
            return;
        }
        if (((Cache.Entry)object).etag != null) {
            map.put("If-None-Match", ((Cache.Entry)object).etag);
        }
        if (((Cache.Entry)object).lastModified <= 0L) return;
        object = new Date(((Cache.Entry)object).lastModified);
        map.put("If-Modified-Since", SimpleDateFormat.getDateTimeInstance().format((Date)object));
    }

    private static void attemptRetryOnException(String string2, Request<?> request, VolleyError volleyError) {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int n2 = request.getTimeoutMs();
        try {
            retryPolicy.retry(volleyError);
        }
        catch (VolleyError volleyError2) {
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", string2, n2));
            throw volleyError2;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", string2, n2));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] entityToBytes(URLHttpResponse var1_1) {
        var2_4 = new PoolingByteArrayOutputStream(this.mPool, (int)var1_1.getContentLength());
        var4_7 = var3_5 = null;
        try {
            var5_8 = var1_1.getContentStream();
            if (var5_8 == null) {
                var4_7 = var3_5;
                var4_7 = var3_5;
                var5_8 = new ServerError();
                var4_7 = var3_5;
                throw var5_8;
            }
            var4_7 = var3_5;
            var3_5 = this.mPool.getBuf(1024);
            while (true) {
                var4_7 = var3_5;
                var6_9 = var5_8.read(var3_5);
                if (var6_9 != -1) {
                    var4_7 = var3_5;
                    var2_4.write(var3_5, 0, var6_9);
                    continue;
                }
                ** GOTO lbl25
                break;
            }
        }
        catch (Throwable var3_6) {
            var1_1.getContentStream().close();
lbl25:
            // 1 sources

            var4_7 = var3_5;
            var5_8 = var2_4.toByteArray();
            try {
                var1_1.getContentStream().close();
            }
            catch (IOException var1_2) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
            this.mPool.returnBuf(var3_5);
            var2_4.close();
            return var5_8;
            catch (IOException var1_3) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
            this.mPool.returnBuf(var4_7);
            var2_4.close();
            throw var3_6;
        }
    }

    protected void logError(String string2, String string3, long l2) {
        VolleyLog.v("HTTP ERROR(%s) %d ms to fetch %s", string2, SystemClock.elapsedRealtime() - l2, string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NetworkResponse performRequest(Request<?> var1_1) {
        block14: while (true) {
            block21: {
                var2_2 = Collections.emptyMap();
                try {
                    var3_3 = new HashMap();
                    this.addCacheHeaders((Map<String, String>)var3_3, var1_1 /* !! */ .getCacheEntry());
                    var4_6 = this.mHttpStack.performRequest(var1_1 /* !! */ , (Map<String, String>)var3_3);
                    var3_3 = var2_2;
                    var5_7 = var4_6.getResponseCode();
                    var3_3 = var2_2;
                    var6_8 = var4_6.getHeaders();
                    if (var5_7 == 304) {
                        var3_3 = var6_8;
                        var2_2 = var1_1 /* !! */ .getCacheEntry();
                        if (var2_2 == null) {
                            var3_3 = var6_8;
                            var6_8 = new NetworkResponse(304, null, (Map<String, String>)var6_8, true);
                            return var6_8;
                        }
                        var3_3 = var6_8;
                        var2_2.responseHeaders.putAll((Map<String, String>)var6_8);
                        var3_3 = var6_8;
                        var6_8 = new NetworkResponse(304, var2_2.data, var2_2.responseHeaders, true);
                        return var6_8;
                    }
                }
                catch (SocketTimeoutException var3_4) {
                    BasicNetwork.attemptRetryOnException("socket", var1_1 /* !! */ , new TimeoutError());
                }
                var3_3 = var6_8;
                try {
                    if (var4_6.getContentStream() == null) break block21;
                    var3_3 = var6_8;
                    var3_3 = var2_2 = (Object)this.entityToBytes(var4_6);
lbl36:
                    // 2 sources

                    while (var5_7 < 200 || var5_7 > 299) {
                        var2_2 = new IOException();
                        throw var2_2;
                    }
                    ** GOTO lbl48
                }
                catch (MalformedURLException var3_5) {
                    throw new RuntimeException("Bad URL " + var1_1 /* !! */ .getUrl(), var3_5);
                }
            }
            var3_3 = var6_8;
            {
                var3_3 = var2_2 = (Object)new byte[0];
                ** GOTO lbl36
lbl48:
                // 1 sources

                try {
                    var2_2 = new NetworkResponse(var5_7, (byte[])var3_3, (Map<String, String>)var6_8, false);
                    return var2_2;
                }
                catch (IOException var7_12) {
                    var2_2 = var3_3;
                    var3_3 = var6_8;
                    var6_8 = var7_12;
lbl55:
                    // 3 sources

                    while (true) {
                        if (var4_6 == null) throw new NoConnectionError((Throwable)var6_8);
                        var5_7 = var4_6.getResponseCode();
                        VolleyLog.e("Unexpected response code %d for %s", new Object[]{var5_7, var1_1 /* !! */ .getUrl()});
                        if (var2_2 == null) throw new NetworkError(null);
                        var3_3 = new NetworkResponse(var5_7, (byte[])var2_2, (Map<String, String>)var3_3, false);
                        if (var5_7 != 401) {
                            if (var5_7 != 403) throw new ServerError((NetworkResponse)var3_3);
                        }
                        BasicNetwork.attemptRetryOnException("auth", var1_1 /* !! */ , new AuthFailureError((NetworkResponse)var3_3));
                        continue block14;
                        break;
                    }
                }
                catch (IOException var6_10) {
                    var2_2 = null;
                    ** GOTO lbl55
                }
            }
            catch (IOException var6_9) {
                var7_11 = null;
                var4_6 = null;
                var3_3 = var2_2;
                var2_2 = var7_11;
                ** continue;
            }
            break;
        }
    }
}

