/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtil {
    private static final Collection<String> DEFAULT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
    }

    private DateUtil() {
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String object) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (object == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        object = new SimpleDateFormat((String)object, Locale.US);
        ((DateFormat)object).setTimeZone(GMT);
        return ((DateFormat)object).format(date);
    }

    public static Date parseDate(String string2) {
        return DateUtil.parseDate(string2, null, null);
    }

    public static Date parseDate(String string2, Collection<String> collection) {
        return DateUtil.parseDate(string2, collection, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date parseDate(String object, Collection<String> object2, Date object3) {
        if (object == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        Object object4 = object2;
        if (object2 == null) {
            object4 = DEFAULT_PATTERNS;
        }
        object2 = object3;
        if (object3 == null) {
            object2 = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        object3 = object;
        if (((String)object).length() > 1) {
            object3 = object;
            if (((String)object).startsWith("'")) {
                object3 = object;
                if (((String)object).endsWith("'")) {
                    object3 = ((String)object).substring(1, ((String)object).length() - 1);
                }
            }
        }
        object4 = object4.iterator();
        object = null;
        while (true) {
            if (!object4.hasNext()) {
                throw new RuntimeException("Unable to parse the date " + (String)object3);
            }
            String string2 = (String)object4.next();
            if (object == null) {
                object = new SimpleDateFormat(string2, Locale.US);
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                ((SimpleDateFormat)object).set2DigitYearStart((Date)object2);
            } else {
                ((SimpleDateFormat)object).applyPattern(string2);
            }
            try {
                return ((DateFormat)object).parse((String)object3);
            }
            catch (ParseException parseException) {
                continue;
            }
            break;
        }
    }
}

