/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import com.common.gmacs.downloader.RetryPolicy;
import com.common.gmacs.downloader.VolleyError;

public class DefaultRetryPolicy
implements RetryPolicy {
    public static final float DEFAULT_BACKOFF_MULT = 1.0f;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final int DEFAULT_TIMEOUT_MS = 2500;
    private final float mBackoffMultiplier;
    private int mCurrentRetryCount;
    private int mCurrentTimeoutMs;
    private final int mMaxNumRetries;

    public DefaultRetryPolicy() {
        this(2500, 1, 1.0f);
    }

    public DefaultRetryPolicy(int n2, int n3, float f2) {
        this.mCurrentTimeoutMs = n2;
        this.mMaxNumRetries = n3;
        this.mBackoffMultiplier = f2;
    }

    public float getBackoffMultiplier() {
        return this.mBackoffMultiplier;
    }

    @Override
    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }

    @Override
    public int getCurrentTimeout() {
        return this.mCurrentTimeoutMs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasAttemptRemaining() {
        if (this.mCurrentRetryCount > this.mMaxNumRetries) return false;
        return true;
    }

    @Override
    public void retry(VolleyError volleyError) {
        ++this.mCurrentRetryCount;
        this.mCurrentTimeoutMs = (int)((float)this.mCurrentTimeoutMs + (float)this.mCurrentTimeoutMs * this.mBackoffMultiplier);
        if (!this.hasAttemptRemaining()) {
            throw volleyError;
        }
    }
}

