/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VolleyLog {
    public static boolean DEBUG;
    public static String TAG;

    static {
        TAG = "GmacsDownLoad";
        DEBUG = Log.isLoggable((String)TAG, (int)2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static String buildMessage(String string2, Object ... objectArray) {
        void var1_4;
        if (objectArray != null) {
            string2 = String.format(Locale.US, string2, objectArray);
        }
        StackTraceElement[] stackTraceElementArray = new Throwable().fillInStackTrace().getStackTrace();
        for (int i2 = 2; i2 < stackTraceElementArray.length; ++i2) {
            if (stackTraceElementArray[i2].getClass().equals(VolleyLog.class)) continue;
            String string3 = stackTraceElementArray[i2].getClassName();
            string3 = string3.substring(string3.lastIndexOf(46) + 1);
            string3 = string3.substring(string3.lastIndexOf(36) + 1);
            String string4 = string3 + "." + stackTraceElementArray[i2].getMethodName();
            return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), var1_4, string2);
        }
        String string5 = "<unknown>";
        return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), var1_4, string2);
    }

    public static void d(String string2, Object ... objectArray) {
        Log.d((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray));
    }

    public static void e(String string2, Object ... objectArray) {
        Log.e((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray));
    }

    public static void e(Throwable throwable, String string2, Object ... objectArray) {
        Log.e((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray), (Throwable)throwable);
    }

    public static void setTag(String string2) {
        VolleyLog.d("Changing log tag to %s", string2);
        TAG = string2;
        DEBUG = Log.isLoggable((String)TAG, (int)2);
    }

    public static void v(String string2, Object ... objectArray) {
        if (DEBUG) {
            Log.v((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray));
        }
    }

    public static void wtf(String string2, Object ... objectArray) {
        Log.wtf((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray));
    }

    public static void wtf(Throwable throwable, String string2, Object ... objectArray) {
        Log.wtf((String)TAG, (String)VolleyLog.buildMessage(string2, objectArray), (Throwable)throwable);
    }

    static class MarkerLog {
        public static final boolean ENABLED = DEBUG;
        private static final long MIN_DURATION_FOR_LOGGING_MS = 0L;
        private boolean mFinished = false;
        private final List<Marker> mMarkers = new ArrayList<Marker>();

        MarkerLog() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long getTotalDuration() {
            if (this.mMarkers.size() == 0) {
                return 0L;
            }
            long l2 = this.mMarkers.get((int)0).time;
            return this.mMarkers.get((int)(this.mMarkers.size() - 1)).time - l2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void add(String object, long l2) {
            synchronized (this) {
                if (this.mFinished) {
                    object = new IllegalStateException("Marker added to finished log");
                    throw object;
                }
                List<Marker> list = this.mMarkers;
                Marker marker = new Marker((String)object, l2, SystemClock.elapsedRealtime());
                list.add(marker);
                return;
            }
        }

        protected void finalize() {
            if (!this.mFinished) {
                this.finish("Request on the loose");
                VolleyLog.e("Marker log finalized without finish() - uncaught exit point for request", new Object[0]);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void finish(String object2) {
            synchronized (this) {
                this.mFinished = true;
                long l2 = this.getTotalDuration();
                if (l2 > 0L) {
                    long l3 = this.mMarkers.get((int)0).time;
                    VolleyLog.d("(%-4d ms) %s", l2, object2);
                    for (Object object2 : this.mMarkers) {
                        l2 = ((Marker)object2).time;
                        VolleyLog.d("(+%-4d) [%2d] %s", l2 - l3, ((Marker)object2).thread, ((Marker)object2).name);
                        l3 = l2;
                    }
                }
                return;
            }
        }

        private static class Marker {
            public final String name;
            public final long thread;
            public final long time;

            public Marker(String string2, long l2, long l3) {
                this.name = string2;
                this.thread = l2;
                this.time = l3;
            }
        }
    }
}

