/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.webkit.WebView;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import java.util.UUID;

public class DeviceUtil {
    private static final String TAG = DeviceUtil.class.getSimpleName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAndroidId() {
        String string2;
        String string3 = null;
        try {
            string3 = string2 = Settings.Secure.getString((ContentResolver)GmacsEnvi.appContext.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            GLog.e((String)TAG, (Throwable)exception);
        }
        string2 = string3;
        if (!TextUtils.isEmpty((CharSequence)string3)) return string2;
        return "";
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getBaseStationInfo() {
        int[] nArray;
        CellLocation cellLocation;
        try {
            cellLocation = ((TelephonyManager)GmacsEnvi.appContext.getSystemService("phone")).getCellLocation();
            if (cellLocation == null) return null;
            nArray = new int[2];
        }
        catch (Exception exception) {
            void var0_2;
            nArray = null;
            GLog.e((String)TAG, (String)var0_2.getMessage());
            return nArray;
        }
        if (cellLocation instanceof GsmCellLocation) {
            cellLocation = (GsmCellLocation)cellLocation;
            nArray[0] = cellLocation.getCid();
            nArray[1] = cellLocation.getLac();
            return nArray;
        }
        if (!(cellLocation instanceof CdmaCellLocation)) return nArray;
        cellLocation = (CdmaCellLocation)cellLocation;
        nArray[0] = cellLocation.getBaseStationId();
        nArray[1] = cellLocation.getNetworkId();
        return nArray;
        {
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBlueToothAddress() {
        String string2;
        String string3 = null;
        try {
            string3 = string2 = BluetoothAdapter.getDefaultAdapter().getAddress();
        }
        catch (Exception exception) {
            GLog.e((String)TAG, (Throwable)exception);
        }
        string2 = string3;
        if (!TextUtils.isEmpty((CharSequence)string3)) return string2;
        return "";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getImei() {
        void var0_2;
        TelephonyManager telephonyManager = (TelephonyManager)GmacsEnvi.appContext.getSystemService("phone");
        if (telephonyManager == null) return var0_2;
        String string2 = telephonyManager.getDeviceId();
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMacAddress() {
        void var0_4;
        try {
            void var0_2;
            WifiManager wifiManager = (WifiManager)GmacsEnvi.appContext.getSystemService("wifi");
            if (wifiManager != null) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            } else {
                Object var0_5 = null;
            }
            if (var0_2 == null) return var0_4;
            String string2 = var0_2.getMacAddress();
            return var0_4;
        }
        catch (Exception exception) {
            GLog.e((String)TAG, (Throwable)exception);
            return var0_4;
        }
    }

    public static String getManufacturerInfo() {
        return System.getProperty("ro.product.manufacturer");
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getPhoneNumber() {
        return ((TelephonyManager)GmacsEnvi.appContext.getSystemService("phone")).getLine1Number();
    }

    private static String getPseudoUniqueID() {
        return new StringBuffer().append("35").append(Build.BOARD.length() % 10).append(Build.BRAND.length() % 10).append(Build.CPU_ABI.length() % 10).append(Build.DEVICE.length() % 10).append(Build.DISPLAY.length() % 10).append(Build.HOST.length() % 10).append(Build.ID.length() % 10).append(Build.MANUFACTURER.length() % 10).append(Build.MODEL.length() % 10).append(Build.PRODUCT.length() % 10).append(Build.TAGS.length() % 10).append(Build.TYPE.length() % 10).append(Build.USER.length() % 10).toString();
    }

    public static String getUA(Context context) {
        context = new WebView(context);
        context.layout(0, 0, 0, 0);
        return context.getSettings().getUserAgentString();
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }
}

