/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.util.IntHashMap;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class IsoTypeReader {
    private static byte[] codeBytes;
    private static IntHashMap codeCache;

    static {
        codeCache = new IntHashMap();
        codeBytes = new byte[4];
    }

    public static int byte2int(byte n2) {
        int n3 = n2;
        if (n2 < 0) {
            n3 = n2 + 256;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read4cc(ByteBuffer object) {
        ((ByteBuffer)object).get(codeBytes);
        byte by = codeBytes[0];
        int n2 = codeBytes[1];
        byte by2 = codeBytes[2];
        n2 = codeBytes[3] & 0xFF | (by << 24 & 0xFF000000 | n2 << 16 & 0xFF0000 | by2 << 8 & 0xFF00);
        object = (String)codeCache.get(n2);
        if (object != null) {
            return object;
        }
        try {
            object = new String(codeBytes, "ISO-8859-1");
            codeCache.put(n2, object);
            return object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static double readFixedPoint0230(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte by3 = byArray[2];
        return (double)(byArray[3] & 0xFF | (by << 24 & 0xFF000000 | 0 | by2 << 16 & 0xFF0000 | by3 << 8 & 0xFF00)) / 1.073741824E9;
    }

    public static double readFixedPoint1616(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte by3 = byArray[2];
        return (double)(byArray[3] & 0xFF | (by << 24 & 0xFF000000 | 0 | by2 << 16 & 0xFF0000 | by3 << 8 & 0xFF00)) / 65536.0;
    }

    public static float readFixedPoint88(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[2];
        byteBuffer.get(byArray);
        short s2 = (short)(byArray[0] << 8 & 0xFF00 | 0);
        return (float)((short)(byArray[1] & 0xFF | s2)) / 256.0f;
    }

    public static String readIso639(ByteBuffer comparable) {
        int n2 = IsoTypeReader.readUInt16((ByteBuffer)comparable);
        comparable = new StringBuilder();
        int n3 = 0;
        while (n3 < 3) {
            ((StringBuilder)comparable).append((char)((n2 >> (2 - n3) * 5 & 0x1F) + 96));
            ++n3;
        }
        return ((StringBuilder)comparable).toString();
    }

    public static String readString(ByteBuffer byteBuffer) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte by;
        while ((by = byteBuffer.get()) != 0) {
            byteArrayOutputStream.write(by);
        }
        return Utf8.convert(byteArrayOutputStream.toByteArray());
    }

    public static String readString(ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return Utf8.convert(byArray);
    }

    public static int readUInt16(ByteBuffer byteBuffer) {
        return 0 + (IsoTypeReader.byte2int(byteBuffer.get()) << 8) + IsoTypeReader.byte2int(byteBuffer.get());
    }

    public static int readUInt16BE(ByteBuffer byteBuffer) {
        return 0 + IsoTypeReader.byte2int(byteBuffer.get()) + (IsoTypeReader.byte2int(byteBuffer.get()) << 8);
    }

    public static int readUInt24(ByteBuffer byteBuffer) {
        return 0 + (IsoTypeReader.readUInt16(byteBuffer) << 8) + IsoTypeReader.byte2int(byteBuffer.get());
    }

    public static long readUInt32(ByteBuffer byteBuffer) {
        long l2;
        long l3 = l2 = (long)byteBuffer.getInt();
        if (l2 < 0L) {
            l3 = l2 + 0x100000000L;
        }
        return l3;
    }

    public static long readUInt32BE(ByteBuffer byteBuffer) {
        return ((long)IsoTypeReader.readUInt8(byteBuffer) << 0) + (((long)IsoTypeReader.readUInt8(byteBuffer) << 8) + (((long)IsoTypeReader.readUInt8(byteBuffer) << 16) + ((long)IsoTypeReader.readUInt8(byteBuffer) << 24)));
    }

    public static long readUInt64(ByteBuffer byteBuffer) {
        long l2 = (IsoTypeReader.readUInt32(byteBuffer) << 32) + 0L;
        if (l2 < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return l2 + IsoTypeReader.readUInt32(byteBuffer);
    }

    public static int readUInt8(ByteBuffer byteBuffer) {
        return IsoTypeReader.byte2int(byteBuffer.get());
    }
}

