/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FreeBox
implements Box {
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String TYPE = "free";
    ByteBuffer data;
    private long offset;
    private Container parent;
    List<Box> replacers = new LinkedList<Box>();

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !FreeBox.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    public FreeBox() {
        this.data = ByteBuffer.wrap(new byte[0]);
    }

    public FreeBox(int n2) {
        this.data = ByteBuffer.allocate(n2);
    }

    public void addAndReplace(Box box) {
        this.data.position(CastUtils.l2i(box.getSize()));
        this.data = this.data.slice();
        this.replacers.add(box);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return bl;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FreeBox)object;
        if (this.getData() != null) {
            if (this.getData().equals(((FreeBox)object).getData())) return bl;
            return false;
        }
        if (((FreeBox)object).getData() == null) return bl;
        return false;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        Object object = this.replacers.iterator();
        while (true) {
            if (!object.hasNext()) {
                object = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32((ByteBuffer)object, this.data.limit() + 8);
                ((ByteBuffer)object).put(TYPE.getBytes());
                ((ByteBuffer)object).rewind();
                writableByteChannel.write((ByteBuffer)object);
                ((ByteBuffer)object).rewind();
                this.data.rewind();
                writableByteChannel.write(this.data);
                this.data.rewind();
                return;
            }
            object.next().getBox(writableByteChannel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer getData() {
        if (this.data == null) return null;
        return (ByteBuffer)this.data.duplicate().rewind();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public long getSize() {
        Iterator<Box> iterator = this.replacers.iterator();
        long l2 = 8L;
        while (iterator.hasNext()) {
            l2 = iterator.next().getSize() + l2;
        }
        return (long)this.data.limit() + l2;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        if (this.data == null) return 0;
        return this.data.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        this.offset = dataSource.position() - (long)byteBuffer.remaining();
        if (l2 > 0x100000L) {
            this.data = dataSource.map(dataSource.position(), l2);
            dataSource.position(dataSource.position() + l2);
            return;
        }
        if (!$assertionsDisabled && l2 >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        this.data = ByteBuffer.allocate(CastUtils.l2i(l2));
        dataSource.read(this.data);
    }

    public void setData(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    @Override
    public void setParent(Container container) {
        this.parent = container;
    }
}

