/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class MetaBox
extends AbstractContainerBox {
    public static final String TYPE = "meta";
    private int flags;
    private int version;

    public MetaBox() {
        super(TYPE);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.writeVersionAndFlags(byteBuffer);
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public int getFlags() {
        return this.flags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        if (this.largeBox || l2 + 4L >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + (l2 + 4L);
        }
        n2 = 8;
        return (long)n2 + (l2 + 4L);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        byteBuffer = ByteBuffer.allocate(4);
        dataSource.read(byteBuffer);
        this.parseVersionAndFlags((ByteBuffer)byteBuffer.rewind());
        this.parseContainer(dataSource, l2 - 4L, boxParser);
    }

    protected final long parseVersionAndFlags(ByteBuffer byteBuffer) {
        this.version = IsoTypeReader.readUInt8(byteBuffer);
        this.flags = IsoTypeReader.readUInt24(byteBuffer);
        return 4L;
    }

    public void setFlags(int n2) {
        this.flags = n2;
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    protected final void writeVersionAndFlags(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.version);
        IsoTypeWriter.writeUInt24(byteBuffer, this.flags);
    }
}

