/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public final class MediaDataBox
implements Box {
    private static Logger LOG = Logger.getLogger(MediaDataBox.class.getName());
    public static final String TYPE = "mdat";
    private DataSource dataSource;
    boolean largeBox = false;
    private long offset;
    Container parent;
    private long size;

    private static void transfer(DataSource dataSource, long l2, long l3, WritableByteChannel writableByteChannel) throws IOException {
        long l4 = 0L;
        while (l4 < l3) {
            l4 = dataSource.transferTo(l2 + l4, Math.min(67076096L, l3 - l4), writableByteChannel) + l4;
        }
        return;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        MediaDataBox.transfer(this.dataSource, this.offset, this.size, writableByteChannel);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        this.offset = dataSource.position() - (long)byteBuffer.remaining();
        this.dataSource = dataSource;
        this.size = (long)byteBuffer.remaining() + l2;
        dataSource.position(dataSource.position() + l2);
    }

    @Override
    public void setParent(Container container) {
        this.parent = container;
    }

    public String toString() {
        return "MediaDataBox{size=" + this.size + '}';
    }
}

