/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public final class AudioSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE1 = "samr";
    public static final String TYPE10 = "mlpa";
    public static final String TYPE11 = "dtsl";
    public static final String TYPE12 = "dtsh";
    public static final String TYPE13 = "dtse";
    public static final String TYPE2 = "sawb";
    public static final String TYPE3 = "mp4a";
    public static final String TYPE4 = "drms";
    public static final String TYPE5 = "alac";
    public static final String TYPE7 = "owma";
    public static final String TYPE8 = "ac-3";
    public static final String TYPE9 = "ec-3";
    public static final String TYPE_ENCRYPTED = "enca";
    private long bytesPerFrame;
    private long bytesPerPacket;
    private long bytesPerSample;
    private int channelCount;
    private int compressionId;
    private int packetSize;
    private int reserved1;
    private long reserved2;
    private long sampleRate;
    private int sampleSize;
    private long samplesPerPacket;
    private int soundVersion;
    private byte[] soundVersion2Data;

    public AudioSampleEntry(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        int n2 = 0;
        writableByteChannel.write(this.getHeader());
        int n3 = this.soundVersion == 1 ? 16 : 0;
        if (this.soundVersion == 2) {
            n2 = 36;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 + 28 + n2);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeUInt16(byteBuffer, this.soundVersion);
        IsoTypeWriter.writeUInt16(byteBuffer, this.reserved1);
        IsoTypeWriter.writeUInt32(byteBuffer, this.reserved2);
        IsoTypeWriter.writeUInt16(byteBuffer, this.channelCount);
        IsoTypeWriter.writeUInt16(byteBuffer, this.sampleSize);
        IsoTypeWriter.writeUInt16(byteBuffer, this.compressionId);
        IsoTypeWriter.writeUInt16(byteBuffer, this.packetSize);
        if (this.type.equals(TYPE10)) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleRate());
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleRate() << 16);
        }
        if (this.soundVersion == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.samplesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerFrame);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerSample);
        }
        if (this.soundVersion == 2) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.samplesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerFrame);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerSample);
            byteBuffer.put(this.soundVersion2Data);
        }
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public long getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public long getBytesPerPacket() {
        return this.bytesPerPacket;
    }

    public long getBytesPerSample() {
        return this.bytesPerSample;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getCompressionId() {
        return this.compressionId;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public long getReserved2() {
        return this.reserved2;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public long getSamplesPerPacket() {
        return this.samplesPerPacket;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getSize() {
        int n2 = 16;
        int n3 = 0;
        int n4 = this.soundVersion == 1 ? 16 : 0;
        if (this.soundVersion == 2) {
            n3 = 36;
        }
        long l2 = (long)(n4 + 28 + n3) + this.getContainerSize();
        n4 = n2;
        if (this.largeBox) return (long)n4 + l2;
        if (8L + l2 >= 0x100000000L) {
            n4 = n2;
            return (long)n4 + l2;
        }
        n4 = 8;
        return (long)n4 + l2;
    }

    public int getSoundVersion() {
        return this.soundVersion;
    }

    public byte[] getSoundVersion2Data() {
        return this.soundVersion2Data;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        int n2 = 0;
        int n3 = 16;
        byteBuffer = ByteBuffer.allocate(28);
        dataSource.read(byteBuffer);
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        this.soundVersion = IsoTypeReader.readUInt16(byteBuffer);
        this.reserved1 = IsoTypeReader.readUInt16(byteBuffer);
        this.reserved2 = IsoTypeReader.readUInt32(byteBuffer);
        this.channelCount = IsoTypeReader.readUInt16(byteBuffer);
        this.sampleSize = IsoTypeReader.readUInt16(byteBuffer);
        this.compressionId = IsoTypeReader.readUInt16(byteBuffer);
        this.packetSize = IsoTypeReader.readUInt16(byteBuffer);
        this.sampleRate = IsoTypeReader.readUInt32(byteBuffer);
        if (!this.type.equals(TYPE10)) {
            this.sampleRate >>>= 16;
        }
        if (this.soundVersion == 1) {
            byteBuffer = ByteBuffer.allocate(16);
            dataSource.read(byteBuffer);
            byteBuffer.rewind();
            this.samplesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerFrame = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerSample = IsoTypeReader.readUInt32(byteBuffer);
        }
        if (this.soundVersion == 2) {
            byteBuffer = ByteBuffer.allocate(36);
            dataSource.read(byteBuffer);
            byteBuffer.rewind();
            this.samplesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerFrame = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerSample = IsoTypeReader.readUInt32(byteBuffer);
            this.soundVersion2Data = new byte[20];
            byteBuffer.get(this.soundVersion2Data);
        }
        if (this.soundVersion != 1) {
            n3 = 0;
        }
        long l3 = n3;
        n3 = n2;
        if (this.soundVersion == 2) {
            n3 = 36;
        }
        this.parseContainer(dataSource, l2 - 28L - l3 - (long)n3, boxParser);
    }

    public void setBytesPerFrame(long l2) {
        this.bytesPerFrame = l2;
    }

    public void setBytesPerPacket(long l2) {
        this.bytesPerPacket = l2;
    }

    public void setBytesPerSample(long l2) {
        this.bytesPerSample = l2;
    }

    public void setChannelCount(int n2) {
        this.channelCount = n2;
    }

    public void setCompressionId(int n2) {
        this.compressionId = n2;
    }

    public void setPacketSize(int n2) {
        this.packetSize = n2;
    }

    public void setReserved1(int n2) {
        this.reserved1 = n2;
    }

    public void setReserved2(long l2) {
        this.reserved2 = l2;
    }

    public void setSampleRate(long l2) {
        this.sampleRate = l2;
    }

    public void setSampleSize(int n2) {
        this.sampleSize = n2;
    }

    public void setSamplesPerPacket(long l2) {
        this.samplesPerPacket = l2;
    }

    public void setSoundVersion(int n2) {
        this.soundVersion = n2;
    }

    public void setSoundVersion2Data(byte[] byArray) {
        this.soundVersion2Data = byArray;
    }

    public void setType(String string2) {
        this.type = string2;
    }

    @Override
    public String toString() {
        return "AudioSampleEntry{bytesPerSample=" + this.bytesPerSample + ", bytesPerFrame=" + this.bytesPerFrame + ", bytesPerPacket=" + this.bytesPerPacket + ", samplesPerPacket=" + this.samplesPerPacket + ", packetSize=" + this.packetSize + ", compressionId=" + this.compressionId + ", soundVersion=" + this.soundVersion + ", sampleRate=" + this.sampleRate + ", sampleSize=" + this.sampleSize + ", channelCount=" + this.channelCount + ", boxes=" + this.getBoxes() + '}';
    }
}

