/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public final class VisualSampleEntry
extends AbstractSampleEntry
implements Container {
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String TYPE1 = "mp4v";
    public static final String TYPE2 = "s263";
    public static final String TYPE3 = "avc1";
    public static final String TYPE4 = "drmi";
    public static final String TYPE_ENCRYPTED = "encv";
    private String compressorname = "";
    private int depth = 24;
    private int frameCount = 1;
    private int height;
    private double horizresolution = 72.0;
    private long[] predefined = new long[3];
    private double vertresolution = 72.0;
    private int width;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !VisualSampleEntry.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    public VisualSampleEntry() {
        super(TYPE3);
    }

    public VisualSampleEntry(String string2) {
        super(string2);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(78);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[0]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[1]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[2]);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getWidth());
        IsoTypeWriter.writeUInt16(byteBuffer, this.getHeight());
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.getHorizresolution());
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.getVertresolution());
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getFrameCount());
        IsoTypeWriter.writeUInt8(byteBuffer, Utf8.utf8StringLengthInBytes(this.getCompressorname()));
        byteBuffer.put(Utf8.convert(this.getCompressorname()));
        int n2 = Utf8.utf8StringLengthInBytes(this.getCompressorname());
        while (true) {
            if (n2 >= 31) {
                IsoTypeWriter.writeUInt16(byteBuffer, this.getDepth());
                IsoTypeWriter.writeUInt16(byteBuffer, 65535);
                writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
                this.writeContainer(writableByteChannel);
                return;
            }
            ++n2;
            byteBuffer.put((byte)0);
        }
    }

    public String getCompressorname() {
        return this.compressorname;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getHeight() {
        return this.height;
    }

    public double getHorizresolution() {
        return this.horizresolution;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        if (this.largeBox || l2 + 78L + 8L >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + (l2 + 78L);
        }
        n2 = 8;
        return (long)n2 + (l2 + 78L);
    }

    public double getVertresolution() {
        return this.vertresolution;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        int n2;
        byteBuffer = ByteBuffer.allocate(78);
        dataSource.read(byteBuffer);
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        long l3 = IsoTypeReader.readUInt16(byteBuffer);
        if (!$assertionsDisabled && 0L != l3) {
            throw new AssertionError((Object)"reserved byte not 0");
        }
        l3 = IsoTypeReader.readUInt16(byteBuffer);
        if (!$assertionsDisabled && 0L != l3) {
            throw new AssertionError((Object)"reserved byte not 0");
        }
        this.predefined[0] = IsoTypeReader.readUInt32(byteBuffer);
        this.predefined[1] = IsoTypeReader.readUInt32(byteBuffer);
        this.predefined[2] = IsoTypeReader.readUInt32(byteBuffer);
        this.width = IsoTypeReader.readUInt16(byteBuffer);
        this.height = IsoTypeReader.readUInt16(byteBuffer);
        this.horizresolution = IsoTypeReader.readFixedPoint1616(byteBuffer);
        this.vertresolution = IsoTypeReader.readFixedPoint1616(byteBuffer);
        l3 = IsoTypeReader.readUInt32(byteBuffer);
        if (!$assertionsDisabled && 0L != l3) {
            throw new AssertionError((Object)"reserved byte not 0");
        }
        this.frameCount = IsoTypeReader.readUInt16(byteBuffer);
        int n3 = n2 = IsoTypeReader.readUInt8(byteBuffer);
        if (n2 > 31) {
            System.out.println("invalid compressor name displayable data: " + n2);
            n3 = 31;
        }
        byte[] byArray = new byte[n3];
        byteBuffer.get(byArray);
        this.compressorname = Utf8.convert(byArray);
        if (n3 < 31) {
            byteBuffer.get(new byte[31 - n3]);
        }
        this.depth = IsoTypeReader.readUInt16(byteBuffer);
        l3 = IsoTypeReader.readUInt16(byteBuffer);
        if (!$assertionsDisabled && 65535L != l3) {
            throw new AssertionError();
        }
        this.parseContainer(dataSource, l2 - 78L, boxParser);
    }

    public void setCompressorname(String string2) {
        this.compressorname = string2;
    }

    public void setDepth(int n2) {
        this.depth = n2;
    }

    public void setFrameCount(int n2) {
        this.frameCount = n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setHorizresolution(double d2) {
        this.horizresolution = d2;
    }

    public void setType(String string2) {
        this.type = string2;
    }

    public void setVertresolution(double d2) {
        this.vertresolution = d2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }
}

