/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IsoSampleNALUnitReader {
    private int nalLengthSize = 4;
    private final ByteBuffer src;

    public IsoSampleNALUnitReader(ByteBuffer byteBuffer, int n2) throws IOException {
        this.src = byteBuffer;
        this.nalLengthSize = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBuffer nextNALUnit() throws IOException {
        long l2;
        ByteBuffer byteBuffer = null;
        if (this.src.remaining() < 5) {
            return byteBuffer;
        }
        if (this.src.remaining() < this.nalLengthSize) throw new RuntimeException("remaining bytes less than nalLengthSize found in sample. should not be here.");
        if (this.nalLengthSize == 1) {
            l2 = IsoTypeReader.readUInt8(this.src);
        } else if (this.nalLengthSize == 2) {
            l2 = IsoTypeReader.readUInt16(this.src);
        } else if (this.nalLengthSize == 3) {
            l2 = IsoTypeReader.readUInt24(this.src);
        } else {
            if (this.nalLengthSize != 4) throw new IOException("Unknown NAL Length isze ");
            l2 = IsoTypeReader.readUInt32(this.src);
        }
        if (l2 == 0L) return byteBuffer;
        byteBuffer = this.src.slice();
        byteBuffer.limit(CastUtils.l2i(l2));
        ByteBuffer byteBuffer2 = this.src;
        int n2 = this.src.position();
        byteBuffer2.position(CastUtils.l2i(l2) + n2);
        return byteBuffer;
    }
}

