/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui.hex;

import com.coremedia.iso.gui.hex.JHexEditorASCII;
import com.coremedia.iso.gui.hex.JHexEditorHEX;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JHexEditor
extends JPanel
implements AdjustmentListener,
FocusListener,
MouseWheelListener {
    protected static Font font = new Font("Monospaced", 0, 12);
    public boolean DEBUG = false;
    protected int border = 2;
    ByteBuffer buff;
    public int cursor;
    private int inicio = 0;
    private int numberOfVisibleLines = 10;
    private JScrollBar scrollBar;

    public JHexEditor(ByteBuffer object) {
        this.buff = object;
        this.addMouseWheelListener(this);
        this.scrollBar = new JScrollBar(1);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(((Buffer)object).limit() / this.getNumberOfVisibleLines());
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add((Component)new JHexEditorHEX(this), "Center");
        jPanel.add((Component)new Columnas(), "North");
        object = new JPanel(new BorderLayout(1, 1));
        ((Container)object).add((Component)new Filas(), "Center");
        ((Container)object).add((Component)new Caja(), "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(1, 1));
        jPanel2.add((Component)this.scrollBar, "East");
        jPanel2.add((Component)new JHexEditorASCII(this), "Center");
        jPanel2.add((Component)new Caja(), "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(1, 1));
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)object, "West");
        jPanel3.add((Component)jPanel2, "East");
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)jPanel3, "Center");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void actualizaCursor() {
        int n2;
        int n3 = n2 = this.cursor / 16;
        if (this.buff.limit() % 16 > 0) {
            n3 = n2 + 1;
        }
        if (n3 < this.inicio) {
            this.inicio = n3;
        } else if (n3 >= this.inicio + this.numberOfVisibleLines) {
            this.inicio = n3 - this.numberOfVisibleLines + 2;
        }
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.inicio = adjustmentEvent.getValue();
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    protected void cuadro(Graphics graphics, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.drawRect((fontMetrics.stringWidth(" ") + 1) * n2 + this.border, fontMetrics.getHeight() * n3 + this.border, (fontMetrics.stringWidth(" ") + 1) * n4, fontMetrics.getHeight() + 1);
    }

    protected void filledCursor(Graphics graphics, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.fillRect((fontMetrics.stringWidth(" ") + 1) * n2 + this.border, fontMetrics.getHeight() * n3 + this.border, (fontMetrics.stringWidth(" ") + 1) * n4, fontMetrics.getHeight() + 1);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    protected int getInicio() {
        return this.inicio;
    }

    protected int getNumberOfVisibleLines() {
        if (this.DEBUG) {
            System.err.println("numberOfVisibleLines: " + this.numberOfVisibleLines);
        }
        return this.numberOfVisibleLines;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                if (this.cursor >= this.numberOfVisibleLines * 16) {
                    this.cursor -= this.numberOfVisibleLines * 16;
                }
                this.actualizaCursor();
                return;
            }
            case 34: {
                if (this.cursor < this.buff.limit() - this.numberOfVisibleLines * 16) {
                    this.cursor += this.numberOfVisibleLines * 16;
                }
                this.actualizaCursor();
                return;
            }
            case 35: {
                this.cursor = this.buff.limit() - 1;
                this.actualizaCursor();
                return;
            }
            case 36: {
                this.cursor = 0;
                this.actualizaCursor();
                return;
            }
            case 37: {
                if (this.cursor != 0) {
                    --this.cursor;
                }
                this.actualizaCursor();
                return;
            }
            case 38: {
                if (this.cursor > 15) {
                    this.cursor -= 16;
                }
                this.actualizaCursor();
                return;
            }
            case 39: {
                if (this.cursor != this.buff.limit() - 1) {
                    ++this.cursor;
                }
                this.actualizaCursor();
                return;
            }
            case 40: {
                if (this.cursor < this.buff.limit() - 16) {
                    this.cursor += 16;
                }
                this.actualizaCursor();
                return;
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.inicio += mouseWheelEvent.getUnitsToScroll();
        int n2 = this.buff.limit() / 16 + 4;
        if (this.inicio + this.numberOfVisibleLines >= n2) {
            this.inicio = n2 - this.numberOfVisibleLines;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n2;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.numberOfVisibleLines = this.getBounds().height / fontMetrics.getHeight() - 2;
        int n3 = n2 = this.buff.limit() / 16;
        if (this.buff.limit() % 16 > 0) {
            n3 = n2 + 1;
        }
        if (this.numberOfVisibleLines > n3) {
            this.numberOfVisibleLines = n3;
            this.inicio = 0;
        }
        this.scrollBar.setValues(this.getInicio(), this.getNumberOfVisibleLines(), 0, n3);
        this.scrollBar.setValueIsAdjusting(true);
        super.paint(graphics);
    }

    protected void printString(Graphics graphics, String string2, int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.drawString(string2, (fontMetrics.stringWidth(" ") + 1) * n2 + this.border, fontMetrics.getHeight() * (n3 + 1) - fontMetrics.getMaxDescent() + this.border);
    }

    private class Caja
    extends JPanel {
        private Caja() {
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n2 = fontMetrics.getHeight();
            dimension.setSize(fontMetrics.stringWidth(" ") + 1 + JHexEditor.this.border * 2 + 1, n2 + JHexEditor.this.border * 2 + 1);
            return dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    private class Columnas
    extends JPanel {
        public Columnas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n2 = fontMetrics.getHeight();
            dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 47 + JHexEditor.this.border * 2 + 1, n2 * 1 + JHexEditor.this.border * 2 + 1);
            return dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics graphics) {
            Object object = this.getMinimumSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            for (int i2 = 0; i2 < 16; ++i2) {
                if (i2 == JHexEditor.this.cursor % 16) {
                    JHexEditor.this.cuadro(graphics, i2 * 3, 0, 2);
                }
                object = "00" + Integer.toHexString(i2);
                object = ((String)object).substring(((String)object).length() - 2);
                JHexEditor.this.printString(graphics, (String)object, i2 * 3, 0);
            }
        }
    }

    private class Filas
    extends JPanel {
        public Filas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n2 = fontMetrics.getHeight();
            int n3 = JHexEditor.this.getNumberOfVisibleLines();
            dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 8 + JHexEditor.this.border * 2 + 1, n2 * n3 + JHexEditor.this.border * 2 + 1);
            return dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics graphics) {
            Object object = this.getMinimumSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            int n2 = JHexEditor.this.getInicio();
            int n3 = JHexEditor.this.getNumberOfVisibleLines();
            int n4 = 0;
            int n5 = n2;
            while (n5 < n2 + n3) {
                if (n5 == JHexEditor.this.cursor / 16) {
                    JHexEditor.this.cuadro(graphics, 0, n4, 8);
                }
                object = "0000000000000" + Integer.toHexString(n5);
                object = ((String)object).substring(((String)object).length() - 8);
                JHexEditor.this.printString(graphics, (String)object, 0, n4);
                ++n5;
                ++n4;
            }
        }
    }
}

