/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class DefaultDateTypeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat enUsFormat;
    private final DateFormat iso8601Format;
    private final DateFormat localFormat;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(int n2) {
        this(DateFormat.getDateInstance(n2, Locale.US), DateFormat.getDateInstance(n2));
    }

    public DefaultDateTypeAdapter(int n2, int n3) {
        this(DateFormat.getDateTimeInstance(n2, n3, Locale.US), DateFormat.getDateTimeInstance(n2, n3));
    }

    DefaultDateTypeAdapter(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    DefaultDateTypeAdapter(DateFormat dateFormat, DateFormat dateFormat2) {
        this.enUsFormat = dateFormat;
        this.localFormat = dateFormat2;
        this.iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonElement object) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                Date date = this.localFormat.parse(((JsonElement)object).getAsString());
                return date;
            }
            catch (ParseException parseException) {
                try {
                    Date date = this.enUsFormat.parse(((JsonElement)object).getAsString());
                    return date;
                }
                catch (ParseException parseException2) {
                    try {
                        Date date = this.iso8601Format.parse(((JsonElement)object).getAsString());
                        return date;
                    }
                    catch (ParseException parseException3) {
                        JsonSyntaxException jsonSyntaxException = new JsonSyntaxException(((JsonElement)object).getAsString(), parseException3);
                        throw jsonSyntaxException;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Date deserialize(JsonElement object, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!(object instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        object = this.deserializeToDate((JsonElement)object);
        if (type == Date.class) {
            return object;
        }
        if (type == Timestamp.class) {
            return new Timestamp(((Date)object).getTime());
        }
        if (type != java.sql.Date.class) throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + type);
        return new java.sql.Date(((Date)object).getTime());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonElement serialize(Date object, Type object2, JsonSerializationContext object3) {
        object2 = this.localFormat;
        synchronized (object2) {
            object = this.enUsFormat.format((Date)object);
            return new JsonPrimitive((String)object);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DefaultDateTypeAdapter.class.getSimpleName());
        stringBuilder.append('(').append(this.localFormat.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }
}

