/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonElement parse(JsonReader jsonReader) throws JsonIOException, JsonSyntaxException {
        boolean bl = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(jsonReader);
            return jsonElement;
        }
        catch (StackOverflowError stackOverflowError) {
            StringBuilder stringBuilder = new StringBuilder();
            JsonParseException jsonParseException = new JsonParseException(stringBuilder.append("Failed parsing JSON source: ").append(jsonReader).append(" to Json").toString(), stackOverflowError);
            throw jsonParseException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringBuilder stringBuilder = new StringBuilder();
            JsonParseException jsonParseException = new JsonParseException(stringBuilder.append("Failed parsing JSON source: ").append(jsonReader).append(" to Json").toString(), outOfMemoryError);
            throw jsonParseException;
        }
        finally {
            jsonReader.setLenient(bl);
        }
    }

    public JsonElement parse(Reader object) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader((Reader)object);
            object = this.parse(jsonReader);
            if (!((JsonElement)object).isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                object = new JsonSyntaxException("Did not consume the entire document.");
                throw object;
            }
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
        return object;
    }

    public JsonElement parse(String string2) throws JsonSyntaxException {
        return this.parse(new StringReader(string2));
    }
}

