/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final Excluder excluder;
    private final FieldNamingStrategy fieldNamingPolicy;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
    }

    private BoundField createBoundField(final Gson gson, final Field field, String string2, final TypeToken<?> typeToken, boolean bl, boolean bl2) {
        return new BoundField(string2, bl, bl2, Primitives.isPrimitive(typeToken.getRawType())){
            final TypeAdapter<?> typeAdapter;
            final /* synthetic */ boolean val$isPrimitive;
            {
                this.val$isPrimitive = bl3;
                super(string2, bl, bl2);
                this.typeAdapter = gson.getAdapter(typeToken);
            }

            @Override
            void read(JsonReader jsonReader, Object object) throws IOException, IllegalAccessException {
                if ((jsonReader = this.typeAdapter.read(jsonReader)) != null || !this.val$isPrimitive) {
                    field.set(object, jsonReader);
                }
            }

            @Override
            void write(JsonWriter jsonWriter, Object object) throws IOException, IllegalAccessException {
                object = field.get(object);
                ((TypeAdapter)new TypeAdapterRuntimeTypeWrapper(gson, this.typeAdapter, typeToken.getType())).write(jsonWriter, object);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private Map<String, BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.getType();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (!bl && !bl2) continue;
                field.setAccessible(true);
                Object object = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                object = this.createBoundField(gson, field, this.getFieldName(field), TypeToken.get((Type)object), bl, bl2);
                if ((object = linkedHashMap.put(((BoundField)object).name, (BoundField)object)) == null) continue;
                throw new IllegalArgumentException(type + " declares multiple JSON fields named " + ((BoundField)object).name);
            }
            typeToken = TypeToken.get((Type)$Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFieldName(Field object) {
        SerializedName serializedName = ((Field)object).getAnnotation(SerializedName.class);
        if (serializedName != null) return serializedName.value();
        return this.fieldNamingPolicy.translateName((Field)object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
        void var1_3;
        void var2_5;
        Object var3_6 = null;
        Class clazz = var2_5.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            Object var1_2 = var3_6;
            return var1_3;
        }
        Adapter adapter = new Adapter(this.constructorConstructor.get(var2_5), this.getBoundFields((Gson)object, (TypeToken<?>)var2_5, clazz));
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean excludeField(Field field, boolean bl) {
        if (this.excluder.excludeClass(field.getType(), bl)) return false;
        if (this.excluder.excludeField(field, bl)) return false;
        return true;
    }

    public final class Adapter<T>
    extends TypeAdapter<T> {
        private final Map<String, BoundField> boundFields;
        private final ObjectConstructor<T> constructor;

        private Adapter(ObjectConstructor<T> objectConstructor, Map<String, BoundField> map) {
            this.constructor = objectConstructor;
            this.boundFields = map;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                jsonReader = null;
                return (T)jsonReader;
            }
            T t2 = this.constructor.construct();
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Object object = jsonReader.nextName();
                    if ((object = this.boundFields.get(object)) == null || !((BoundField)object).deserialized) {
                        jsonReader.skipValue();
                        continue;
                    }
                    ((BoundField)object).read(jsonReader, t2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonReader.endObject();
            jsonReader = t2;
            return (T)jsonReader;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(JsonWriter jsonWriter, T t2) throws IOException {
            if (t2 == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.serialized) continue;
                    jsonWriter.name(boundField.name);
                    boundField.write(jsonWriter, t2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            jsonWriter.endObject();
        }
    }

    static abstract class BoundField {
        final boolean deserialized;
        final String name;
        final boolean serialized;

        protected BoundField(String string2, boolean bl, boolean bl2) {
            this.name = string2;
            this.serialized = bl;
            this.deserialized = bl2;
        }

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;
    }
}

