/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

public final class TypeAdapters {
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL;
    public static final TypeAdapter<BigInteger> BIG_INTEGER;
    public static final TypeAdapter<BitSet> BIT_SET;
    public static final TypeAdapterFactory BIT_SET_FACTORY;
    public static final TypeAdapter<Boolean> BOOLEAN;
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING;
    public static final TypeAdapterFactory BOOLEAN_FACTORY;
    public static final TypeAdapter<Number> BYTE;
    public static final TypeAdapterFactory BYTE_FACTORY;
    public static final TypeAdapter<Calendar> CALENDAR;
    public static final TypeAdapterFactory CALENDAR_FACTORY;
    public static final TypeAdapter<Character> CHARACTER;
    public static final TypeAdapterFactory CHARACTER_FACTORY;
    public static final TypeAdapter<Class> CLASS;
    public static final TypeAdapterFactory CLASS_FACTORY;
    public static final TypeAdapter<Number> DOUBLE;
    public static final TypeAdapterFactory ENUM_FACTORY;
    public static final TypeAdapter<Number> FLOAT;
    public static final TypeAdapter<InetAddress> INET_ADDRESS;
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY;
    public static final TypeAdapter<Number> INTEGER;
    public static final TypeAdapterFactory INTEGER_FACTORY;
    public static final TypeAdapter<JsonElement> JSON_ELEMENT;
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY;
    public static final TypeAdapter<Locale> LOCALE;
    public static final TypeAdapterFactory LOCALE_FACTORY;
    public static final TypeAdapter<Number> LONG;
    public static final TypeAdapter<Number> NUMBER;
    public static final TypeAdapterFactory NUMBER_FACTORY;
    public static final TypeAdapter<Number> SHORT;
    public static final TypeAdapterFactory SHORT_FACTORY;
    public static final TypeAdapter<String> STRING;
    public static final TypeAdapter<StringBuffer> STRING_BUFFER;
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY;
    public static final TypeAdapter<StringBuilder> STRING_BUILDER;
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY;
    public static final TypeAdapterFactory STRING_FACTORY;
    public static final TypeAdapterFactory TIMESTAMP_FACTORY;
    public static final TypeAdapter<URI> URI;
    public static final TypeAdapterFactory URI_FACTORY;
    public static final TypeAdapter<URL> URL;
    public static final TypeAdapterFactory URL_FACTORY;
    public static final TypeAdapter<UUID> UUID;
    public static final TypeAdapterFactory UUID_FACTORY;

    static {
        CLASS = new TypeAdapter<Class>(){

            @Override
            public Class read(JsonReader jsonReader) throws IOException {
                throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
            }

            @Override
            public void write(JsonWriter jsonWriter, Class clazz) throws IOException {
                throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + clazz.getName() + ". Forgot to register a type adapter?");
            }
        };
        CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
        BIT_SET = new TypeAdapter<BitSet>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public BitSet read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                BitSet bitSet = new BitSet();
                ((JsonReader)object).beginArray();
                Object object2 = ((JsonReader)object).peek();
                int n2 = 0;
                while (true) {
                    boolean bl;
                    if (object2 == JsonToken.END_ARRAY) {
                        ((JsonReader)object).endArray();
                        return bitSet;
                    }
                    switch (object2) {
                        default: {
                            throw new JsonSyntaxException("Invalid bitset value type: " + (Object)object2);
                        }
                        case NUMBER: {
                            if (((JsonReader)object).nextInt() != 0) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case BOOLEAN: {
                            bl = ((JsonReader)object).nextBoolean();
                            break;
                        }
                        case STRING: {
                            object2 = ((JsonReader)object).nextString();
                            try {
                                int n3 = Integer.parseInt((String)object2);
                                if (n3 != 0) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new JsonSyntaxException("Error: Expecting: bitset number value (1, 0), Found: " + (String)object2);
                            }
                        }
                    }
                    if (bl) {
                        bitSet.set(n2);
                    }
                    ++n2;
                    object2 = ((JsonReader)object).peek();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
                if (bitSet == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginArray();
                int n2 = 0;
                while (true) {
                    if (n2 >= bitSet.length()) {
                        jsonWriter.endArray();
                        return;
                    }
                    int n3 = bitSet.get(n2) ? 1 : 0;
                    jsonWriter.value(n3);
                    ++n2;
                }
            }
        };
        BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
        BOOLEAN = new TypeAdapter<Boolean>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Boolean read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                if (((JsonReader)object).peek() != JsonToken.STRING) return ((JsonReader)object).nextBoolean();
                return Boolean.parseBoolean(((JsonReader)object).nextString());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
                if (bl == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(bl);
            }
        };
        BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Boolean read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return Boolean.valueOf(((JsonReader)object).nextString());
                ((JsonReader)object).nextNull();
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, Boolean object) throws IOException {
                object = object == null ? "null" : ((Boolean)object).toString();
                jsonWriter.value((String)object);
            }
        };
        BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
        BYTE = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                byte by;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    by = (byte)((JsonReader)object).nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return by;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
        SHORT = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                short s2;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    s2 = (short)((JsonReader)object).nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return s2;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
        INTEGER = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                int n2;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    n2 = ((JsonReader)object).nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return n2;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
        LONG = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                long l2;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    l2 = ((JsonReader)object).nextLong();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return l2;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        FLOAT = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return Float.valueOf((float)((JsonReader)object).nextDouble());
                ((JsonReader)object).nextNull();
                return null;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        DOUBLE = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return ((JsonReader)object).nextDouble();
                ((JsonReader)object).nextNull();
                return null;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER = new TypeAdapter<Number>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Number read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                switch (jsonToken) {
                    default: {
                        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
                    }
                    case NULL: {
                        ((JsonReader)object).nextNull();
                        return null;
                    }
                    case NUMBER: 
                }
                return new LazilyParsedNumber(((JsonReader)object).nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
        CHARACTER = new TypeAdapter<Character>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Character read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                if (((String)(object = ((JsonReader)object).nextString())).length() == 1) return Character.valueOf(((String)object).charAt(0));
                throw new JsonSyntaxException("Expecting character, got: " + (String)object);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, Character object) throws IOException {
                object = object == null ? null : String.valueOf(object);
                jsonWriter.value((String)object);
            }
        };
        CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
        STRING = new TypeAdapter<String>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public String read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                if (jsonToken == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                if (jsonToken != JsonToken.BOOLEAN) return ((JsonReader)object).nextString();
                return Boolean.toString(((JsonReader)object).nextBoolean());
            }

            @Override
            public void write(JsonWriter jsonWriter, String string2) throws IOException {
                jsonWriter.value(string2);
            }
        };
        BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public BigDecimal read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    return new BigDecimal(((JsonReader)object).nextString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
                jsonWriter.value(bigDecimal);
            }
        };
        BIG_INTEGER = new TypeAdapter<BigInteger>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public BigInteger read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    return new BigInteger(((JsonReader)object).nextString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigInteger bigInteger) throws IOException {
                jsonWriter.value(bigInteger);
            }
        };
        STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
        STRING_BUILDER = new TypeAdapter<StringBuilder>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public StringBuilder read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return new StringBuilder(((JsonReader)object).nextString());
                ((JsonReader)object).nextNull();
                return null;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, StringBuilder charSequence) throws IOException {
                void var2_4;
                if (charSequence == null) {
                    Object var2_3 = null;
                } else {
                    String string2 = ((StringBuilder)charSequence).toString();
                }
                jsonWriter.value((String)var2_4);
            }
        };
        STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
        STRING_BUFFER = new TypeAdapter<StringBuffer>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public StringBuffer read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return new StringBuffer(((JsonReader)object).nextString());
                ((JsonReader)object).nextNull();
                return null;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, StringBuffer charSequence) throws IOException {
                void var2_4;
                if (charSequence == null) {
                    Object var2_3 = null;
                } else {
                    String string2 = ((StringBuffer)charSequence).toString();
                }
                jsonWriter.value((String)var2_4);
            }
        };
        STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
        URL = new TypeAdapter<URL>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public URL read(JsonReader object) throws IOException {
                Object var2_2 = null;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return var2_2;
                }
                String string2 = ((JsonReader)object).nextString();
                object = var2_2;
                if ("null".equals(string2)) return object;
                return new URL(string2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, URL object) throws IOException {
                object = object == null ? null : ((URL)object).toExternalForm();
                jsonWriter.value((String)object);
            }
        };
        URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
        URI = new TypeAdapter<URI>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public URI read(JsonReader object) throws IOException {
                String string2;
                Object var2_3 = null;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return var2_3;
                }
                try {
                    string2 = ((JsonReader)object).nextString();
                    object = var2_3;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new JsonIOException(uRISyntaxException);
                }
                if ("null".equals(string2)) return object;
                return new URI(string2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, URI object) throws IOException {
                object = object == null ? null : ((URI)object).toASCIIString();
                jsonWriter.value((String)object);
            }
        };
        URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
        INET_ADDRESS = new TypeAdapter<InetAddress>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public InetAddress read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return InetAddress.getByName(((JsonReader)object).nextString());
                ((JsonReader)object).nextNull();
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, InetAddress object) throws IOException {
                object = object == null ? null : ((InetAddress)object).getHostAddress();
                jsonWriter.value((String)object);
            }
        };
        INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
        UUID = new TypeAdapter<UUID>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public UUID read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() != JsonToken.NULL) return java.util.UUID.fromString(((JsonReader)object).nextString());
                ((JsonReader)object).nextNull();
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, UUID object) throws IOException {
                object = object == null ? null : ((UUID)object).toString();
                jsonWriter.value((String)object);
            }
        };
        UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
        TIMESTAMP_FACTORY = new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                void var1_3;
                void var2_5;
                if (var2_5.getRawType() != Timestamp.class) {
                    return var1_3;
                }
                TypeAdapter<Timestamp> typeAdapter = new TypeAdapter<Timestamp>(object.getAdapter(Date.class)){
                    final /* synthetic */ TypeAdapter val$dateTypeAdapter;
                    {
                        this.val$dateTypeAdapter = typeAdapter;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Timestamp read(JsonReader object) throws IOException {
                        if ((object = (Date)this.val$dateTypeAdapter.read((JsonReader)object)) == null) return null;
                        return new Timestamp(((Date)object).getTime());
                    }

                    @Override
                    public void write(JsonWriter jsonWriter, Timestamp timestamp) throws IOException {
                        this.val$dateTypeAdapter.write(jsonWriter, timestamp);
                    }
                };
                return var1_3;
            }
        };
        CALENDAR = new TypeAdapter<Calendar>(){
            private static final String DAY_OF_MONTH = "dayOfMonth";
            private static final String HOUR_OF_DAY = "hourOfDay";
            private static final String MINUTE = "minute";
            private static final String MONTH = "month";
            private static final String SECOND = "second";
            private static final String YEAR = "year";

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Calendar read(JsonReader object) throws IOException {
                int n2 = 0;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                ((JsonReader)object).beginObject();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (((JsonReader)object).peek() != JsonToken.END_OBJECT) {
                    String string2 = ((JsonReader)object).nextName();
                    int n8 = ((JsonReader)object).nextInt();
                    if (YEAR.equals(string2)) {
                        n7 = n8;
                        continue;
                    }
                    if (MONTH.equals(string2)) {
                        n6 = n8;
                        continue;
                    }
                    if (DAY_OF_MONTH.equals(string2)) {
                        n5 = n8;
                        continue;
                    }
                    if (HOUR_OF_DAY.equals(string2)) {
                        n4 = n8;
                        continue;
                    }
                    if (MINUTE.equals(string2)) {
                        n3 = n8;
                        continue;
                    }
                    if (!SECOND.equals(string2)) continue;
                    n2 = n8;
                }
                ((JsonReader)object).endObject();
                return new GregorianCalendar(n7, n6, n5, n4, n3, n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(JsonWriter jsonWriter, Calendar calendar) throws IOException {
                if (calendar == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginObject();
                jsonWriter.name(YEAR);
                jsonWriter.value(calendar.get(1));
                jsonWriter.name(MONTH);
                jsonWriter.value(calendar.get(2));
                jsonWriter.name(DAY_OF_MONTH);
                jsonWriter.value(calendar.get(5));
                jsonWriter.name(HOUR_OF_DAY);
                jsonWriter.value(calendar.get(11));
                jsonWriter.name(MINUTE);
                jsonWriter.value(calendar.get(12));
                jsonWriter.name(SECOND);
                jsonWriter.value(calendar.get(13));
                jsonWriter.endObject();
            }
        };
        CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
        LOCALE = new TypeAdapter<Locale>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Locale read(JsonReader object) throws IOException {
                String string2 = null;
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return string2;
                }
                Object object2 = new StringTokenizer(((JsonReader)object).nextString(), "_");
                object = ((StringTokenizer)object2).hasMoreElements() ? ((StringTokenizer)object2).nextToken() : null;
                string2 = ((StringTokenizer)object2).hasMoreElements() ? ((StringTokenizer)object2).nextToken() : null;
                object2 = ((StringTokenizer)object2).hasMoreElements() ? ((StringTokenizer)object2).nextToken() : null;
                if (string2 == null && object2 == null) {
                    return new Locale((String)object);
                }
                if (object2 != null) return new Locale((String)object, string2, (String)object2);
                return new Locale((String)object, string2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter jsonWriter, Locale object) throws IOException {
                object = object == null ? null : ((Locale)object).toString();
                jsonWriter.value((String)object);
            }
        };
        LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
        JSON_ELEMENT = new TypeAdapter<JsonElement>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public JsonElement read(JsonReader object) throws IOException {
                switch (((JsonReader)object).peek()) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case STRING: {
                        return new JsonPrimitive(((JsonReader)object).nextString());
                    }
                    case NUMBER: {
                        return new JsonPrimitive(new LazilyParsedNumber(((JsonReader)object).nextString()));
                    }
                    case BOOLEAN: {
                        return new JsonPrimitive(((JsonReader)object).nextBoolean());
                    }
                    case NULL: {
                        ((JsonReader)object).nextNull();
                        return JsonNull.INSTANCE;
                    }
                    case BEGIN_ARRAY: {
                        JsonArray jsonArray = new JsonArray();
                        ((JsonReader)object).beginArray();
                        while (((JsonReader)object).hasNext()) {
                            jsonArray.add(this.read((JsonReader)object));
                        }
                        ((JsonReader)object).endArray();
                        return jsonArray;
                    }
                    case BEGIN_OBJECT: 
                }
                JsonObject jsonObject = new JsonObject();
                ((JsonReader)object).beginObject();
                while (((JsonReader)object).hasNext()) {
                    jsonObject.add(((JsonReader)object).nextName(), this.read((JsonReader)object));
                }
                ((JsonReader)object).endObject();
                return jsonObject;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(JsonWriter jsonWriter, JsonElement iterator) throws IOException {
                if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
                    jsonWriter.nullValue();
                    return;
                }
                if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
                    if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                        jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsNumber());
                        return;
                    }
                    if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                        jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsBoolean());
                        return;
                    }
                    jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsString());
                    return;
                }
                if (((JsonElement)((Object)iterator)).isJsonArray()) {
                    jsonWriter.beginArray();
                    iterator = ((JsonElement)((Object)iterator)).getAsJsonArray().iterator();
                    while (iterator.hasNext()) {
                        this.write(jsonWriter, (JsonElement)iterator.next());
                    }
                    jsonWriter.endArray();
                    return;
                }
                if (!((JsonElement)((Object)iterator)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
                jsonWriter.beginObject();
                for (Map.Entry entry : ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet()) {
                    jsonWriter.name((String)entry.getKey());
                    this.write(jsonWriter, (JsonElement)entry.getValue());
                }
                jsonWriter.endObject();
            }
        };
        JSON_ELEMENT_FACTORY = TypeAdapters.newFactory(JsonElement.class, JSON_ELEMENT);
        ENUM_FACTORY = TypeAdapters.newEnumTypeHierarchyFactory();
    }

    private TypeAdapters() {
    }

    public static TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> object2) {
                if (!Enum.class.isAssignableFrom((Class<?>)(object2 = object2.getRawType()))) return null;
                if (object2 == Enum.class) {
                    return null;
                }
                object = object2;
                if (((Class)object2).isEnum()) return new EnumTypeAdapter(object);
                object = ((Class)object2).getSuperclass();
                return new EnumTypeAdapter(object);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> typeToken, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken2) {
                void var1_3;
                void var2_5;
                if (!var2_5.equals((Object)typeToken)) return var1_3;
                TypeAdapter typeAdapter2 = typeAdapter;
                return var1_3;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                void var1_3;
                void var2_5;
                if (var2_5.getRawType() != clazz) return var1_3;
                TypeAdapter typeAdapter2 = typeAdapter;
                return var1_3;
            }

            public String toString() {
                return "Factory[type=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                void var1_4;
                void var2_6;
                Class clazz3 = var2_6.getRawType();
                if (clazz3 != clazz && clazz3 != clazz2) return var1_4;
                TypeAdapter typeAdapter2 = typeAdapter;
                return var1_4;
            }

            public String toString() {
                return "Factory[type=" + clazz2.getName() + "+" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> clazz, final Class<? extends TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                void var1_4;
                void var2_6;
                Class clazz3 = var2_6.getRawType();
                if (clazz3 != clazz && clazz3 != clazz2) return var1_4;
                TypeAdapter typeAdapter2 = typeAdapter;
                return var1_4;
            }

            public String toString() {
                return "Factory[type=" + clazz.getName() + "+" + clazz2.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newTypeHierarchyFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                void var1_3;
                void var2_5;
                if (!clazz.isAssignableFrom(var2_5.getRawType())) return var1_3;
                TypeAdapter typeAdapter2 = typeAdapter;
                return var1_3;
            }

            public String toString() {
                return "Factory[typeHierarchy=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<T, String> constantToName;
        private final Map<String, T> nameToConstant = new HashMap<String, T>();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public EnumTypeAdapter(Class<T> clazz) {
            int n2;
            int n3;
            Enum[] enumArray;
            this.constantToName = new HashMap<T, String>();
            try {
                enumArray = (Enum[])clazz.getEnumConstants();
                n3 = enumArray.length;
                n2 = 0;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError();
            }
            while (true) {
                if (n2 >= n3) {
                    return;
                }
                Enum enum_ = enumArray[n2];
                String string2 = enum_.name();
                SerializedName serializedName = clazz.getField(string2).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string2 = serializedName.value();
                }
                this.nameToConstant.put(string2, enum_);
                this.constantToName.put(enum_, string2);
                ++n2;
                continue;
                break;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public T read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                object = null;
                return (T)object;
            }
            object = (Enum)this.nameToConstant.get(((JsonReader)object).nextString());
            return (T)object;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void write(JsonWriter jsonWriter, T object) throws IOException {
            void var2_4;
            if (object == null) {
                Object var2_3 = null;
            } else {
                String string2 = this.constantToName.get(object);
            }
            jsonWriter.value((String)var2_4);
        }
    }
}

