/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonScope;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.google.gson.stream.StringPool;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final String FALSE = "false";
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final String TRUE = "true";
    private final char[] buffer;
    private int bufferStartColumn = 1;
    private int bufferStartLine = 1;
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private String name;
    private int pos = 0;
    private boolean skipping;
    private JsonScope[] stack;
    private int stackSize = 0;
    private final StringPool stringPool = new StringPool();
    private JsonToken token;
    private String value;
    private int valueLength;
    private int valuePos;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                jsonReader.peek();
                if (jsonReader.token != JsonToken.NAME) {
                    throw new IllegalStateException("Expected a name but was " + (Object)((Object)jsonReader.peek()) + " " + " at line " + jsonReader.getLineNumber() + " column " + jsonReader.getColumnNumber());
                }
                JsonReader.access$302(jsonReader, jsonReader.name);
                JsonReader.access$402(jsonReader, null);
                JsonReader.access$002(jsonReader, JsonToken.STRING);
            }
        };
    }

    public JsonReader(Reader reader) {
        this.buffer = new char[1024];
        this.stack = new JsonScope[32];
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.in = reader;
    }

    static /* synthetic */ JsonToken access$002(JsonReader jsonReader, JsonToken jsonToken) {
        jsonReader.token = jsonToken;
        return jsonToken;
    }

    static /* synthetic */ String access$302(JsonReader jsonReader, String string2) {
        jsonReader.value = string2;
        return string2;
    }

    static /* synthetic */ String access$402(JsonReader jsonReader, String string2) {
        jsonReader.name = string2;
        return string2;
    }

    private JsonToken advance() throws IOException {
        this.peek();
        JsonToken jsonToken = this.token;
        this.token = null;
        this.value = null;
        this.name = null;
        return jsonToken;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        int n2 = 0;
        while (true) {
            if (n2 >= NON_EXECUTE_PREFIX.length) {
                this.pos += NON_EXECUTE_PREFIX.length;
                return;
            }
            if (this.buffer[this.pos + n2] != NON_EXECUTE_PREFIX[n2]) return;
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonToken decodeLiteral() throws IOException {
        if (this.valuePos == -1) {
            return JsonToken.STRING;
        }
        if (!(this.valueLength != 4 || 'n' != this.buffer[this.valuePos] && 'N' != this.buffer[this.valuePos] || 'u' != this.buffer[this.valuePos + 1] && 'U' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 'l' != this.buffer[this.valuePos + 3] && 'L' != this.buffer[this.valuePos + 3])) {
            this.value = "null";
            return JsonToken.NULL;
        }
        if (!(this.valueLength != 4 || 't' != this.buffer[this.valuePos] && 'T' != this.buffer[this.valuePos] || 'r' != this.buffer[this.valuePos + 1] && 'R' != this.buffer[this.valuePos + 1] || 'u' != this.buffer[this.valuePos + 2] && 'U' != this.buffer[this.valuePos + 2] || 'e' != this.buffer[this.valuePos + 3] && 'E' != this.buffer[this.valuePos + 3])) {
            this.value = TRUE;
            return JsonToken.BOOLEAN;
        }
        if (!(this.valueLength != 5 || 'f' != this.buffer[this.valuePos] && 'F' != this.buffer[this.valuePos] || 'a' != this.buffer[this.valuePos + 1] && 'A' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 's' != this.buffer[this.valuePos + 3] && 'S' != this.buffer[this.valuePos + 3] || 'e' != this.buffer[this.valuePos + 4] && 'E' != this.buffer[this.valuePos + 4])) {
            this.value = FALSE;
            return JsonToken.BOOLEAN;
        }
        this.value = this.stringPool.get(this.buffer, this.valuePos, this.valueLength);
        return this.decodeNumber(this.buffer, this.valuePos, this.valueLength);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private JsonToken decodeNumber(char[] var1_1, int var2_2, int var3_3) {
        block20: {
            var4_4 = var1_1 /* !! */ [var2_2];
            if (var4_4 != 45) break block20;
            var5_5 = var2_2 + 1;
            var4_4 = var1_1 /* !! */ [var5_5];
lbl5:
            // 2 sources

            while (true) {
                block25: {
                    block19: {
                        block24: {
                            block23: {
                                block22: {
                                    block18: {
                                        block21: {
                                            if (var4_4 == 48) {
                                                var4_4 = var5_5 + 1;
                                                var5_5 = var1_1 /* !! */ [var4_4];
lbl9:
                                                // 3 sources

                                                while (true) {
                                                    var6_6 = var5_5;
                                                    var7_7 = var4_4;
                                                    if (var5_5 != 46) break block18;
                                                    var5_5 = var4_4 + 1;
                                                    var4_4 = var1_1 /* !! */ [var5_5];
                                                    while (true) {
                                                        var6_6 = var4_4;
                                                        var7_7 = var5_5;
                                                        if (var4_4 >= 48) {
                                                            var6_6 = var4_4;
                                                            var7_7 = var5_5++;
                                                            if (var4_4 <= 57) {
                                                                var4_4 = var1_1 /* !! */ [var5_5];
                                                                continue;
                                                            }
                                                        }
                                                        break block18;
                                                        break;
                                                    }
                                                    break;
                                                }
                                            }
                                            if (var4_4 < 49 || var4_4 > 57) break block21;
                                            var7_7 = var5_5 + 1;
                                            var6_6 = var1_1 /* !! */ [var7_7];
                                            while (true) {
                                                var5_5 = var6_6;
                                                var4_4 = var7_7;
                                                if (var6_6 < 48) ** GOTO lbl9
                                                var5_5 = var6_6;
                                                var4_4 = var7_7++;
                                                if (var6_6 <= 57) ** break;
                                                ** continue;
                                                var6_6 = var1_1 /* !! */ [var7_7];
                                            }
                                        }
                                        var1_1 /* !! */  = (char[])JsonToken.STRING;
lbl40:
                                        // 4 sources

                                        return var1_1 /* !! */ ;
                                    }
                                    if (var6_6 == 101) break block22;
                                    var5_5 = var7_7;
                                    if (var6_6 != 69) break block19;
                                }
                                if ((var7_7 = var1_1 /* !! */ [var6_6 = var7_7 + 1]) == 43) break block23;
                                var5_5 = var7_7;
                                var4_4 = var6_6;
                                if (var7_7 != 45) break block24;
                            }
                            var4_4 = var6_6 + 1;
                            var5_5 = var1_1 /* !! */ [var4_4];
                        }
                        if (var5_5 >= 48 && var5_5 <= 57) {
                            var7_7 = var1_1 /* !! */ [++var4_4];
                            while (true) {
                                var5_5 = var4_4;
                                if (var7_7 >= 48) {
                                    var5_5 = var4_4++;
                                    if (var7_7 <= 57) {
                                        var7_7 = var1_1 /* !! */ [var4_4];
                                        continue;
                                    }
                                }
                                break block19;
                                break;
                            }
                        }
                        var1_1 /* !! */  = (char[])JsonToken.STRING;
                        ** GOTO lbl40
                    }
                    if (var5_5 != var2_2 + var3_3) break block25;
                    var1_1 /* !! */  = (char[])JsonToken.NUMBER;
                    ** GOTO lbl40
                }
                var1_1 /* !! */  = (char[])JsonToken.STRING;
                ** continue;
                break;
            }
        }
        var5_5 = var2_2;
        ** while (true)
    }

    private void expect(JsonToken jsonToken) throws IOException {
        this.peek();
        if (this.token != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean fillBuffer(int n2) throws IOException {
        boolean bl = true;
        char[] cArray = this.buffer;
        int n3 = this.bufferStartLine;
        int n4 = this.bufferStartColumn;
        int n5 = this.pos;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (cArray[i2] == '\n') {
                ++n3;
                n4 = 1;
                continue;
            }
            ++n4;
        }
        this.bufferStartLine = n3;
        this.bufferStartColumn = n4;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        do {
            if ((n4 = this.in.read(cArray, this.limit, cArray.length - this.limit)) == -1) {
                return false;
            }
            this.limit = n4 + this.limit;
            if (this.bufferStartLine != 1 || this.bufferStartColumn != 1 || this.limit <= 0 || cArray[0] != '\ufeff') continue;
            ++this.pos;
            --this.bufferStartColumn;
        } while (this.limit < n2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColumnNumber() {
        int n2 = this.bufferStartColumn;
        int n3 = 0;
        while (n3 < this.pos) {
            n2 = this.buffer[n3] == '\n' ? 1 : ++n2;
            ++n3;
        }
        return n2;
    }

    private int getLineNumber() {
        int n2 = this.bufferStartLine;
        for (int i2 = 0; i2 < this.pos; ++i2) {
            int n3 = n2;
            if (this.buffer[i2] == '\n') {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken nextInArray(boolean bl) throws IOException {
        JsonToken jsonToken;
        if (bl) {
            this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_ARRAY;
        } else {
            switch (this.nextNonWhitespace(true)) {
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    --this.stackSize;
                    this.token = jsonToken = JsonToken.END_ARRAY;
                    return jsonToken;
                }
                case 59: {
                    this.checkLenient();
                }
            }
        }
        switch (this.nextNonWhitespace(true)) {
            default: {
                --this.pos;
                return this.nextValue();
            }
            case 93: {
                if (!bl) break;
                --this.stackSize;
                this.token = jsonToken = JsonToken.END_ARRAY;
                return jsonToken;
            }
            case 44: 
            case 59: 
        }
        this.checkLenient();
        --this.pos;
        this.value = "null";
        this.token = jsonToken = JsonToken.NULL;
        return jsonToken;
    }

    /*
     * Exception decompiling
     */
    private JsonToken nextInObject(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String nextLiteral(boolean bl) throws IOException {
        Object var2_2 = null;
        this.valuePos = -1;
        this.valueLength = 0;
        int n2 = 0;
        Object var4_4 = null;
        block4: while (true) {
            StringBuilder stringBuilder;
            block18: {
                void var4_7;
                int n3;
                block16: {
                    void var4_5;
                    block17: {
                        block15: {
                            if (this.pos + n2 >= this.limit) break block15;
                            stringBuilder = var4_5;
                            n3 = n2;
                            switch (this.buffer[this.pos + n2]) {
                                default: {
                                    ++n2;
                                    continue block4;
                                }
                                case '#': 
                                case '/': 
                                case ';': 
                                case '=': 
                                case '\\': {
                                    this.checkLenient();
                                    n3 = n2;
                                    stringBuilder = var4_5;
                                    break;
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': 
                                case ',': 
                                case ':': 
                                case '[': 
                                case ']': 
                                case '{': 
                                case '}': {
                                    break;
                                }
                            }
                            break block16;
                        }
                        if (n2 >= this.buffer.length) break block17;
                        if (this.fillBuffer(n2 + 1)) continue;
                        this.buffer[this.limit] = (char)0;
                        stringBuilder = var4_5;
                        n3 = n2;
                        break block16;
                    }
                    stringBuilder = var4_5;
                    if (var4_5 == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(this.buffer, this.pos, n2);
                    this.valueLength += n2;
                    this.pos = n2 + this.pos;
                    if (this.fillBuffer(1)) break block18;
                    n3 = 0;
                }
                if (bl && stringBuilder == null) {
                    this.valuePos = this.pos;
                    Object var4_6 = var2_2;
                } else if (this.skipping) {
                    String string2 = "skipped!";
                } else if (stringBuilder == null) {
                    String string3 = this.stringPool.get(this.buffer, this.pos, n3);
                } else {
                    stringBuilder.append(this.buffer, this.pos, n3);
                    String string4 = stringBuilder.toString();
                }
                this.valueLength += n3;
                this.pos += n3;
                return var4_7;
            }
            n2 = 0;
            StringBuilder stringBuilder2 = stringBuilder;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextNonWhitespace(boolean bl) throws IOException {
        char[] cArray = this.buffer;
        int n2 = this.pos;
        int n3 = this.limit;
        block9: while (true) {
            int n4 = n3;
            int n5 = n2;
            if (n2 == n3) {
                this.pos = n2;
                if (!this.fillBuffer(1)) {
                    if (!bl) return -1;
                    throw new EOFException("End of input at line " + this.getLineNumber() + " column " + this.getColumnNumber());
                }
                n5 = this.pos;
                n4 = this.limit;
            }
            n3 = n5 + 1;
            n2 = cArray[n5];
            switch (n2) {
                default: {
                    this.pos = n3;
                    return n2;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n2 = n3;
                    n3 = n4;
                    continue block9;
                }
                case 47: {
                    this.pos = n3;
                    if (n3 == n4) {
                        --this.pos;
                        boolean bl2 = this.fillBuffer(2);
                        ++this.pos;
                        if (!bl2) {
                            return n2;
                        }
                    }
                    this.checkLenient();
                    switch (cArray[this.pos]) {
                        default: {
                            return n2;
                        }
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            n2 = this.pos + 2;
                            n3 = this.limit;
                            continue block9;
                        }
                        case '/': 
                    }
                    ++this.pos;
                    this.skipToEndOfLine();
                    n2 = this.pos;
                    n3 = this.limit;
                    continue block9;
                }
                case 35: 
            }
            this.pos = n3;
            this.checkLenient();
            this.skipToEndOfLine();
            n2 = this.pos;
            n3 = this.limit;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String nextString(char c2) throws IOException {
        char[] cArray = this.buffer;
        CharSequence charSequence = null;
        block0: while (true) {
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (true) {
                StringBuilder stringBuilder;
                int n5;
                if (n4 < n3) {
                    n5 = n4 + 1;
                    if ((n4 = cArray[n4]) == c2) {
                        this.pos = n5;
                        if (this.skipping) {
                            return "skipped!";
                        }
                        if (charSequence == null) {
                            return this.stringPool.get(cArray, n2, n5 - n2 - 1);
                        }
                        ((StringBuilder)charSequence).append(cArray, n2, n5 - n2 - 1);
                        return ((StringBuilder)charSequence).toString();
                    }
                    if (n4 == 92) {
                        this.pos = n5;
                        stringBuilder = charSequence;
                        if (charSequence == null) {
                            stringBuilder = new StringBuilder();
                        }
                        stringBuilder.append(cArray, n2, n5 - n2 - 1);
                        stringBuilder.append(this.readEscapeCharacter());
                        n4 = this.pos;
                        n3 = this.limit;
                        charSequence = stringBuilder;
                        n2 = n4;
                        continue;
                    }
                } else {
                    stringBuilder = charSequence;
                    if (charSequence == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(cArray, n2, n4 - n2);
                    this.pos = n4;
                    charSequence = stringBuilder;
                    if (this.fillBuffer(1)) continue block0;
                    throw this.syntaxError("Unterminated string");
                }
                n4 = n5;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonToken nextValue() throws IOException {
        JsonToken jsonToken;
        int n2 = this.nextNonWhitespace(true);
        switch (n2) {
            default: {
                --this.pos;
                return this.readLiteral();
            }
            case 123: {
                this.push(JsonScope.EMPTY_OBJECT);
                this.token = jsonToken = JsonToken.BEGIN_OBJECT;
                return jsonToken;
            }
            case 91: {
                this.push(JsonScope.EMPTY_ARRAY);
                this.token = jsonToken = JsonToken.BEGIN_ARRAY;
                return jsonToken;
            }
            case 39: {
                this.checkLenient();
            }
            case 34: 
        }
        this.value = this.nextString((char)n2);
        this.token = jsonToken = JsonToken.STRING;
        return jsonToken;
    }

    private JsonToken objectValue() throws IOException {
        switch (this.nextNonWhitespace(true)) {
            default: {
                throw this.syntaxError("Expected ':'");
            }
            case 61: {
                this.checkLenient();
                if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                ++this.pos;
            }
            case 58: 
        }
        this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_OBJECT;
        return this.nextValue();
    }

    private void push(JsonScope jsonScope) {
        JsonScope[] jsonScopeArray;
        if (this.stackSize == this.stack.length) {
            jsonScopeArray = new JsonScope[this.stackSize * 2];
            System.arraycopy(this.stack, 0, jsonScopeArray, 0, this.stackSize);
            this.stack = jsonScopeArray;
        }
        jsonScopeArray = this.stack;
        int n2 = this.stackSize;
        this.stackSize = n2 + 1;
        jsonScopeArray[n2] = jsonScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char[] cArray = this.buffer;
        int n2 = this.pos;
        this.pos = n2 + 1;
        int n3 = cArray[n2];
        switch (n3) {
            default: {
                return (char)n3;
            }
            case 117: {
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                int n4 = this.pos;
                boolean bl = false;
                int n5 = n4;
                while (true) {
                    char c2;
                    if (n5 >= n4 + 4) {
                        this.pos += 4;
                        return c2;
                    }
                    char c3 = this.buffer[n5];
                    c2 = (char)(c2 << 4);
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)(c2 + (c3 - 48));
                    } else if (c3 >= 'a' && c3 <= 'f') {
                        c2 = (char)(c2 + (c3 - 97 + 10));
                    } else {
                        if (c3 < 'A') throw new NumberFormatException("\\u" + this.stringPool.get(this.buffer, this.pos, 4));
                        if (c3 > 'F') throw new NumberFormatException("\\u" + this.stringPool.get(this.buffer, this.pos, 4));
                        c2 = (char)(c2 + (c3 - 65 + 10));
                    }
                    ++n5;
                }
            }
            case 116: {
                int n6 = 9;
                return (char)n6;
            }
            case 98: {
                int n7 = 8;
                return (char)n7;
            }
            case 110: {
                int n8 = 10;
                return (char)n8;
            }
            case 114: {
                int n9 = 13;
                return (char)n9;
            }
            case 102: 
        }
        int n10 = 12;
        return (char)n10;
    }

    private JsonToken readLiteral() throws IOException {
        this.value = this.nextLiteral(true);
        if (this.valueLength == 0) {
            throw this.syntaxError("Expected literal value");
        }
        this.token = this.decodeLiteral();
        if (this.token == JsonToken.STRING) {
            this.checkLenient();
        }
        return this.token;
    }

    private boolean skipTo(String string2) throws IOException {
        boolean bl;
        block3: {
            boolean bl2 = false;
            block0: while (true) {
                if (this.pos + string2.length() > this.limit) {
                    bl = bl2;
                    if (!this.fillBuffer(string2.length())) break block3;
                }
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    if (this.buffer[this.pos + i2] == string2.charAt(i2)) continue;
                    ++this.pos;
                    continue block0;
                }
                break;
            }
            bl = true;
        }
        return bl;
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char[] cArray = this.buffer;
            int n2 = this.pos;
            this.pos = n2 + 1;
            if ((n2 = cArray[n2]) != 13 && n2 != 10) continue;
        }
    }

    private IOException syntaxError(String string2) throws IOException {
        throw new MalformedJsonException(string2 + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    @Override
    public void close() throws IOException {
        this.value = null;
        this.token = null;
        this.stack[0] = JsonScope.CLOSED;
        this.stackSize = 1;
        this.in.close();
    }

    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
    }

    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNext() throws IOException {
        this.peek();
        if (this.token == JsonToken.END_OBJECT) return false;
        if (this.token == JsonToken.END_ARRAY) return false;
        return true;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.token != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        boolean bl = this.value == TRUE;
        this.advance();
        return bl;
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        double d2 = Double.parseDouble(this.value);
        if (d2 >= 1.0 && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return d2;
    }

    public int nextInt() throws IOException {
        int n2;
        block4: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            try {
                n2 = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                int n3;
                double d2 = Double.parseDouble(this.value);
                n2 = n3 = (int)d2;
                if ((double)n3 == d2) break block4;
                throw new NumberFormatException("Expected an int but was " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
        }
        while ((long)n2 >= 1L && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return n2;
    }

    public long nextLong() throws IOException {
        long l2;
        block4: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            try {
                l2 = Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                long l3;
                double d2 = Double.parseDouble(this.value);
                l2 = l3 = (long)d2;
                if ((double)l3 == d2) break block4;
                throw new NumberFormatException("Expected a long but was " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
        }
        while (l2 >= 1L && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return l2;
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.token != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        String string2 = this.name;
        this.advance();
        return string2;
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.token != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        String string2 = this.value;
        this.advance();
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonToken peek() throws IOException {
        if (this.token != null) {
            return this.token;
        }
        switch (2.$SwitchMap$com$google$gson$stream$JsonScope[this.stack[this.stackSize - 1].ordinal()]) {
            default: {
                throw new AssertionError();
            }
            case 1: {
                JsonToken jsonToken;
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_DOCUMENT;
                JsonToken jsonToken2 = jsonToken = this.nextValue();
                if (this.lenient) return jsonToken2;
                jsonToken2 = jsonToken;
                if (this.token == JsonToken.BEGIN_ARRAY) return jsonToken2;
                jsonToken2 = jsonToken;
                if (this.token == JsonToken.BEGIN_OBJECT) return jsonToken2;
                throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            case 2: {
                return this.nextInArray(true);
            }
            case 3: {
                return this.nextInArray(false);
            }
            case 4: {
                return this.nextInObject(true);
            }
            case 5: {
                return this.objectValue();
            }
            case 6: {
                return this.nextInObject(false);
            }
            case 7: {
                if (this.nextNonWhitespace(false) == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.pos;
                if (this.lenient) return this.nextValue();
                throw this.syntaxError("Expected EOF");
            }
            case 8: 
        }
        throw new IllegalStateException("JsonReader is closed");
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void skipValue() throws IOException {
        this.skipping = true;
        int n2 = 0;
        try {
            int n3;
            do {
                block7: {
                    block8: {
                        JsonToken jsonToken;
                        JsonToken jsonToken2;
                        block6: {
                            if ((jsonToken2 = this.advance()) != JsonToken.BEGIN_ARRAY && jsonToken2 != (jsonToken = JsonToken.BEGIN_OBJECT)) break block6;
                            n3 = n2 + 1;
                            break block7;
                        }
                        if (jsonToken2 == JsonToken.END_ARRAY) break block8;
                        jsonToken = JsonToken.END_OBJECT;
                        n3 = n2;
                        if (jsonToken2 != jsonToken) break block7;
                    }
                    n3 = n2 - 1;
                }
                n2 = n3;
            } while (n3 != 0);
            this.skipping = false;
            return;
        }
        catch (Throwable throwable) {
            this.skipping = false;
            throw throwable;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
    }
}

