/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.LazyList;
import com.googlecode.mp4parser.util.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BasicContainer
implements Container,
Iterator<Box> {
    private static final Box EOF;
    private static Logger LOG;
    protected BoxParser boxParser;
    private List<Box> boxes = new ArrayList<Box>();
    protected DataSource dataSource;
    long endPosition = 0L;
    Box lookahead = null;
    long parsePosition = 0L;
    long startPosition = 0L;

    static {
        LOG = Logger.getLogger(AbstractContainerBox.class);
        EOF = new AbstractBox("eof "){

            protected void _parseDetails(ByteBuffer byteBuffer) {
            }

            protected void getContent(ByteBuffer byteBuffer) {
            }

            protected long getContentSize() {
                return 0L;
            }
        };
    }

    public void addBox(Box box) {
        this.boxes = new ArrayList<Box>(this.getBoxes());
        box.setParent(this);
        this.boxes.add(box);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Box> getBoxes() {
        if (this.dataSource == null) return this.boxes;
        if (this.lookahead == EOF) return this.boxes;
        return new LazyList<Box>(this.boxes, this);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        ArrayList<Box> arrayList = new ArrayList<Box>(2);
        Iterator<Box> iterator = this.getBoxes().iterator();
        while (iterator.hasNext()) {
            Box box = iterator.next();
            if (clazz.isInstance(box)) {
                arrayList.add(box);
            }
            if (!bl || !(box instanceof Container)) continue;
            arrayList.addAll(((Container)((Object)box)).getBoxes(clazz, bl));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer getByteBuffer(long l2, long l3) throws IOException {
        DataSource dataSource = this.dataSource;
        synchronized (dataSource) {
            return this.dataSource.map(this.startPosition + l2, l3);
        }
    }

    protected long getContainerSize() {
        long l2 = 0L;
        int n2 = 0;
        while (n2 < this.getBoxes().size()) {
            l2 += this.boxes.get(n2).getSize();
            ++n2;
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() {
        boolean bl = false;
        if (this.lookahead == EOF) {
            return bl;
        }
        if (this.lookahead != null) {
            return true;
        }
        try {
            this.lookahead = this.next();
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.lookahead = EOF;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Box next() {
        Box box;
        if (this.lookahead != null && this.lookahead != EOF) {
            box = this.lookahead;
            this.lookahead = null;
            return box;
        }
        LOG.logDebug("Parsing next() box");
        if (this.dataSource == null || this.parsePosition >= this.endPosition) {
            this.lookahead = EOF;
            throw new NoSuchElementException();
        }
        try {
            DataSource dataSource = this.dataSource;
            synchronized (dataSource) {
            }
        }
        catch (EOFException eOFException) {
            throw new NoSuchElementException();
        }
        catch (IOException iOException) {
            throw new NoSuchElementException();
        }
        {
            this.dataSource.position(this.parsePosition);
            box = this.boxParser.parseBox(this.dataSource, this);
            this.parsePosition = this.dataSource.position();
            return box;
        }
    }

    public void parseContainer(DataSource dataSource, long l2, BoxParser boxParser) throws IOException {
        long l3;
        this.dataSource = dataSource;
        this.startPosition = l3 = dataSource.position();
        this.parsePosition = l3;
        dataSource.position(dataSource.position() + l2);
        this.endPosition = dataSource.position();
        this.boxParser = boxParser;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoxes(List<Box> list) {
        this.boxes = new ArrayList<Box>(list);
        this.lookahead = EOF;
        this.dataSource = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[");
        int n2 = 0;
        while (true) {
            if (n2 >= this.boxes.size()) {
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            if (n2 > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(this.boxes.get(n2).toString());
            ++n2;
        }
    }

    @Override
    public final void writeContainer(WritableByteChannel writableByteChannel) throws IOException {
        Iterator<Box> iterator = this.getBoxes().iterator();
        while (iterator.hasNext()) {
            iterator.next().getBox(writableByteChannel);
        }
        return;
    }
}

