/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class AbstractManifestWriter
implements ManifestWriter {
    private static final Logger LOG = Logger.getLogger(AbstractManifestWriter.class.getName());
    protected long[] audioFragmentsDurations;
    private FragmentIntersectionFinder intersectionFinder;
    protected long[] videoFragmentsDurations;

    protected AbstractManifestWriter(FragmentIntersectionFinder fragmentIntersectionFinder) {
        this.intersectionFinder = fragmentIntersectionFinder;
    }

    protected static long getDuration(Track object) {
        Iterator<TimeToSampleBox.Entry> iterator = object.getDecodingTimeEntries().iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            object = iterator.next();
            long l3 = ((TimeToSampleBox.Entry)object).getCount();
            l2 = ((TimeToSampleBox.Entry)object).getDelta() * l3 + l2;
        }
        return l2;
    }

    @Override
    public long[] calculateFragmentDurations(Track object, Movie object2) {
        object2 = this.intersectionFinder.sampleNumbers((Track)object, (Movie)object2);
        long[] lArray = new long[((Object)object2).length];
        Iterator<TimeToSampleBox.Entry> iterator = object.getDecodingTimeEntries().iterator();
        int n2 = 0;
        int n3 = 1;
        block0: while (true) {
            int n4 = n3;
            if (!iterator.hasNext()) {
                return lArray;
            }
            object = iterator.next();
            int n5 = CastUtils.l2i(((TimeToSampleBox.Entry)object).getCount());
            int n6 = n2;
            n3 = n4;
            while (true) {
                int n7;
                n3 = n7 = n3;
                n2 = n6;
                if (n7 >= n5 + n4) continue block0;
                n2 = n6;
                if (n6 != ((Object)object2).length - 1) {
                    n2 = n6;
                    if ((long)n7 == object2[n6 + 1]) {
                        n2 = n6 + 1;
                    }
                }
                lArray[n2] = lArray[n2] + ((TimeToSampleBox.Entry)object).getDelta();
                n3 = n7 + 1;
                n6 = n2;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected long[] checkFragmentsAlign(long[] object, long[] lArray) throws IOException {
        void var4_11;
        long l2;
        void var2_7;
        block7: {
            block6: {
                if (object == null || ((long[])object).length == 0) break block6;
                long[] lArray2 = new long[((long[])object).length - 1];
                System.arraycopy(object, 0, lArray2, 0, ((long[])object).length - 1);
                long[] lArray3 = new long[((void)var2_7).length - 1];
                System.arraycopy(var2_7, 0, lArray3, 0, ((void)var2_7).length - 1);
                if (!Arrays.equals(lArray3, lArray2)) break block7;
            }
            return var2_7;
        }
        String string2 = String.valueOf(String.valueOf("") + ((long[])object).length) + "Reference     :  [";
        int n2 = ((long[])object).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) break;
            l2 = object[n3];
            String string3 = String.valueOf(var4_11) + String.format("%10d,", l2);
            ++n3;
        }
        String string4 = String.valueOf(var4_11) + "]";
        LOG.warning(string4);
        String string5 = String.valueOf(String.valueOf("") + ((void)var2_7).length) + "Current       :  [";
        n2 = ((void)var2_7).length;
        n3 = 0;
        while (true) {
            void var1_4;
            if (n3 >= n2) {
                String string6 = String.valueOf(var1_4) + "]";
                LOG.warning(string6);
                throw new IOException("Track does not have the same fragment borders as its predecessor.");
            }
            l2 = var2_7[n3];
            String string7 = String.valueOf(var1_4) + String.format("%10d,", l2);
            ++n3;
        }
    }

    @Override
    public long getBitrate(Track track) {
        Iterator<Sample> iterator = track.getSamples().iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            l2 = iterator.next().remaining() + l2;
        }
        return (long)((double)(8L * l2) / ((double)AbstractManifestWriter.getDuration(track) / (double)track.getTrackMetaData().getTimescale()));
    }

    protected String getFormat(AbstractSampleEntry abstractSampleEntry) {
        String string2;
        block3: {
            block2: {
                String string3 = abstractSampleEntry.getType();
                if (string3.equals("encv") || string3.equals("enca")) break block2;
                string2 = string3;
                if (!string3.equals("encv")) break block3;
            }
            string2 = abstractSampleEntry.getBoxes(OriginalFormatBox.class, true).get(0).getDataFormat();
        }
        return string2;
    }
}

