/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.NullMediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.adobe.ActionMessageFormat0SampleEntryBox;
import java.nio.ByteBuffer;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Amf0Track
extends AbstractTrack {
    SortedMap<Long, byte[]> rawSamples = new TreeMap<Long, byte[]>(){};
    private TrackMetaData trackMetaData = new TrackMetaData();

    public Amf0Track(Map<Long, byte[]> map) {
        this.rawSamples = new TreeMap<Long, byte[]>(map);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setTimescale(1000L);
        this.trackMetaData.setLanguage("eng");
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
        Object object = new LinkedList<Long>(this.rawSamples.keySet());
        Collections.sort(object);
        object = ((AbstractSequentialList)object).iterator();
        long l2 = 0L;
        while (object.hasNext()) {
            Long l3 = (Long)object.next();
            l2 = l3 - l2;
            if (linkedList.size() > 0 && linkedList.peek().getDelta() == l2) {
                linkedList.peek().setCount(linkedList.peek().getCount() + 1L);
            } else {
                linkedList.add(new TimeToSampleBox.Entry(1L, l2));
            }
            l2 = l3;
        }
        return linkedList;
    }

    @Override
    public String getHandler() {
        return "data";
    }

    @Override
    public Box getMediaHeaderBox() {
        return new NullMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox sampleDescriptionBox = new SampleDescriptionBox();
        ActionMessageFormat0SampleEntryBox actionMessageFormat0SampleEntryBox = new ActionMessageFormat0SampleEntryBox();
        actionMessageFormat0SampleEntryBox.setDataReferenceIndex(1);
        sampleDescriptionBox.addBox(actionMessageFormat0SampleEntryBox);
        return sampleDescriptionBox;
    }

    @Override
    public List<Sample> getSamples() {
        LinkedList<Sample> linkedList = new LinkedList<Sample>();
        Iterator<byte[]> iterator = this.rawSamples.values().iterator();
        while (iterator.hasNext()) {
            linkedList.add(new SampleImpl(ByteBuffer.wrap(iterator.next())));
        }
        return linkedList;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }
}

