/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ChangeTimeScaleTrack
implements Track {
    private static final Logger LOG = Logger.getLogger(ChangeTimeScaleTrack.class.getName());
    List<CompositionTimeToSample.Entry> ctts;
    Track source;
    long timeScale;
    List<TimeToSampleBox.Entry> tts;

    public ChangeTimeScaleTrack(Track track, long l2, long[] lArray) {
        this.source = track;
        this.timeScale = l2;
        double d2 = (double)l2 / (double)track.getTrackMetaData().getTimescale();
        this.ctts = ChangeTimeScaleTrack.adjustCtts(track.getCompositionTimeEntries(), d2);
        this.tts = ChangeTimeScaleTrack.adjustTts(track.getDecodingTimeEntries(), d2, lArray, ChangeTimeScaleTrack.getTimes(track, lArray, l2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<CompositionTimeToSample.Entry> adjustCtts(List<CompositionTimeToSample.Entry> arrayList, double d2) {
        if (arrayList == null) return null;
        ArrayList<CompositionTimeToSample.Entry> arrayList2 = new ArrayList<CompositionTimeToSample.Entry>(arrayList.size());
        arrayList = arrayList.iterator();
        while (arrayList.hasNext()) {
            CompositionTimeToSample.Entry entry = (CompositionTimeToSample.Entry)arrayList.next();
            arrayList2.add(new CompositionTimeToSample.Entry(entry.getCount(), (int)Math.round((double)entry.getOffset() * d2)));
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static List<TimeToSampleBox.Entry> adjustTts(List<TimeToSampleBox.Entry> list, double d2, long[] lArray, long[] lArray2) {
        long[] lArray3 = TimeToSampleBox.blowupTimeToSamples(list);
        long l2 = 0L;
        list = new LinkedList<TimeToSampleBox.Entry>();
        int n2 = 1;
        while (n2 <= lArray3.length) {
            long l3 = Math.round((double)lArray3[n2 - 1] * d2);
            TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)((LinkedList)list).peekLast();
            int n3 = Arrays.binarySearch(lArray, (long)(n2 + 1));
            long l4 = l3;
            if (n3 >= 0) {
                l4 = l3;
                if (lArray2[n3] != l2) {
                    l4 = lArray2[n3] - (l2 + l3);
                    LOG.finest(String.format("Sample %d %d / %d - correct by %d", n2, l2, lArray2[n3], l4));
                    l4 = l3 + l4;
                }
            }
            l2 += l4;
            if (entry == null) {
                ((LinkedList)list).add(new TimeToSampleBox.Entry(1L, l4));
            } else if (entry.getDelta() != l4) {
                ((LinkedList)list).add(new TimeToSampleBox.Entry(1L, l4));
            } else {
                entry.setCount(entry.getCount() + 1L);
            }
            ++n2;
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long[] getTimes(Track track, long[] lArray, long l2) {
        long[] lArray2 = new long[lArray.length];
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        int n2 = 1;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = 0;
        long l5 = 0L;
        while ((long)n2 <= lArray[lArray.length - 1]) {
            int n4 = n3;
            if ((long)n2 == lArray[n3]) {
                lArray2[n3] = l3 * l2 / track.getTrackMetaData().getTimescale();
                n4 = n3 + 1;
            }
            if (l5 == 0L) {
                TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)linkedList.poll();
                l5 = entry.getCount();
                l4 = entry.getDelta();
                --l5;
            } else {
                --l5;
            }
            l3 += l4;
            ++n2;
            n3 = n4;
        }
        return lArray2;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.tts;
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<Sample> getSamples() {
        return this.source.getSamples();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.timeScale);
        return trackMetaData;
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    public String toString() {
        return "ChangeTimeScaleTrack{source=" + this.source + '}';
    }
}

