/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DivideTimeScaleTrack
implements Track {
    Track source;
    private int timeScaleDivisor;

    public DivideTimeScaleTrack(Track track, int n2) {
        this.source = track;
        this.timeScaleDivisor = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<CompositionTimeToSample.Entry> adjustCtts() {
        List<CompositionTimeToSample.Entry> list = this.source.getCompositionTimeEntries();
        if (list == null) return null;
        ArrayList<CompositionTimeToSample.Entry> arrayList = new ArrayList<CompositionTimeToSample.Entry>(list.size());
        Iterator<CompositionTimeToSample.Entry> iterator = list.iterator();
        while (iterator.hasNext()) {
            list = iterator.next();
            arrayList.add(new CompositionTimeToSample.Entry(((CompositionTimeToSample.Entry)((Object)list)).getCount(), ((CompositionTimeToSample.Entry)((Object)list)).getOffset() / this.timeScaleDivisor));
        }
        return arrayList;
    }

    List<TimeToSampleBox.Entry> adjustTts() {
        Object object = this.source.getDecodingTimeEntries();
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
        Iterator<TimeToSampleBox.Entry> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            linkedList.add(new TimeToSampleBox.Entry(((TimeToSampleBox.Entry)object).getCount(), ((TimeToSampleBox.Entry)object).getDelta() / (long)this.timeScaleDivisor));
        }
        return linkedList;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.adjustCtts();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.adjustTts();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<Sample> getSamples() {
        return this.source.getSamples();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.source.getTrackMetaData().getTimescale() / (long)this.timeScaleDivisor);
        return trackMetaData;
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    public String toString() {
        return "MultiplyTimeScaleTrack{source=" + this.source + '}';
    }
}

