/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.apple.BaseMediaInfoAtom;
import com.googlecode.mp4parser.boxes.apple.GenericMediaHeaderAtom;
import com.googlecode.mp4parser.boxes.apple.GenericMediaHeaderTextAtom;
import com.googlecode.mp4parser.boxes.apple.QuicktimeTextSampleEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class QuicktimeTextTrackImpl
extends AbstractTrack {
    SampleDescriptionBox sampleDescriptionBox;
    List<Line> subs;
    TrackMetaData trackMetaData = new TrackMetaData();

    public QuicktimeTextTrackImpl() {
        this.subs = new LinkedList<Line>();
        this.sampleDescriptionBox = new SampleDescriptionBox();
        QuicktimeTextSampleEntry quicktimeTextSampleEntry = new QuicktimeTextSampleEntry();
        quicktimeTextSampleEntry.setDataReferenceIndex(1);
        this.sampleDescriptionBox.addBox(quicktimeTextSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setTimescale(1000L);
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
        Iterator<Line> iterator = this.subs.iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            Line line = iterator.next();
            if ((l2 = line.from - l2) > 0L) {
                linkedList.add(new TimeToSampleBox.Entry(1L, l2));
            } else if (l2 < 0L) {
                throw new Error("Subtitle display times may not intersect");
            }
            linkedList.add(new TimeToSampleBox.Entry(1L, line.to - line.from));
            l2 = line.to;
        }
        return linkedList;
    }

    @Override
    public String getHandler() {
        return "text";
    }

    @Override
    public Box getMediaHeaderBox() {
        GenericMediaHeaderAtom genericMediaHeaderAtom = new GenericMediaHeaderAtom();
        genericMediaHeaderAtom.addBox((Box)((Object)new BaseMediaInfoAtom()));
        genericMediaHeaderAtom.addBox((Box)((Object)new GenericMediaHeaderTextAtom()));
        return genericMediaHeaderAtom;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Sample> getSamples() {
        LinkedList<Sample> linkedList = new LinkedList<Sample>();
        Iterator<Line> iterator = this.subs.iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            Line line = iterator.next();
            if ((l2 = line.from - l2) > 0L) {
                linkedList.add(new SampleImpl(ByteBuffer.wrap(new byte[2])));
            } else if (l2 < 0L) {
                throw new Error("Subtitle display times may not intersect");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeShort(line.text.getBytes("UTF-8").length);
                dataOutputStream.write(line.text.getBytes("UTF-8"));
                dataOutputStream.close();
                linkedList.add(new SampleImpl(ByteBuffer.wrap(byteArrayOutputStream.toByteArray())));
            }
            catch (IOException iOException) {
                throw new Error("VM is broken. Does not support UTF-8");
            }
            l2 = line.to;
        }
        return linkedList;
    }

    public List<Line> getSubs() {
        return this.subs;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    public static class Line {
        long from;
        String text;
        long to;

        public Line(long l2, long l3, String string2) {
            this.from = l2;
            this.to = l3;
            this.text = string2;
        }

        public long getFrom() {
            return this.from;
        }

        public String getText() {
            return this.text;
        }

        public long getTo() {
            return this.to;
        }
    }
}

