/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import java.nio.ByteBuffer;

public class BitReaderBuffer {
    private ByteBuffer buffer;
    int initialPos;
    int position;

    public BitReaderBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.initialPos = byteBuffer.position();
    }

    public int byteSync() {
        int n2;
        int n3 = n2 = 8 - this.position % 8;
        if (n2 == 8) {
            n3 = 0;
        }
        this.readBits(n3);
        return n3;
    }

    public int getPosition() {
        return this.position;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int readBits(int n2) {
        int n3;
        int n4 = n3 = this.buffer.get(this.initialPos + this.position / 8);
        if (n3 < 0) {
            n4 = n3 + 256;
        }
        if (n2 <= (n3 = 8 - this.position % 8)) {
            n4 = (n4 << this.position % 8 & 0xFF) >> n3 - n2 + this.position % 8;
            this.position += n2;
            n2 = n4;
        } else {
            n2 -= n3;
            n4 = this.readBits(n3);
            n2 = this.readBits(n2) + (n4 << n2);
        }
        this.buffer.position(this.initialPos + (int)Math.ceil((double)this.position / 8.0));
        return n2;
    }

    public int remainingBits() {
        return this.buffer.limit() * 8 - this.position;
    }
}

