/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class InitialObjectDescriptor
extends ObjectDescriptorBase {
    int audioProfileLevelIndication;
    List<ESDescriptor> esDescriptors = new ArrayList<ESDescriptor>();
    List<ExtensionDescriptor> extensionDescriptors = new ArrayList<ExtensionDescriptor>();
    int graphicsProfileLevelIndication;
    int includeInlineProfileLevelFlag;
    int oDProfileLevelIndication;
    private int objectDescriptorId;
    int sceneProfileLevelIndication;
    List<BaseDescriptor> unknownDescriptors = new ArrayList<BaseDescriptor>();
    int urlFlag;
    int urlLength;
    String urlString;
    int visualProfileLevelIndication;

    /*
     * Enabled aggressive block sorting
     */
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        int n2 = IsoTypeReader.readUInt16(byteBuffer);
        this.objectDescriptorId = (0xFFC0 & n2) >> 6;
        this.urlFlag = (n2 & 0x3F) >> 5;
        this.includeInlineProfileLevelFlag = (n2 & 0x1F) >> 4;
        n2 = this.getSize() - 2;
        if (this.urlFlag == 1) {
            this.urlLength = IsoTypeReader.readUInt8(byteBuffer);
            this.urlString = IsoTypeReader.readString(byteBuffer, this.urlLength);
            n2 -= this.urlLength + 1;
        } else {
            int n3;
            this.oDProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.sceneProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.audioProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.visualProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.graphicsProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            n2 = n3 = n2 - 5;
            if (n3 > 2) {
                BaseDescriptor baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
                n2 = n3 - baseDescriptor.getSize();
                if (baseDescriptor instanceof ESDescriptor) {
                    this.esDescriptors.add((ESDescriptor)baseDescriptor);
                } else {
                    this.unknownDescriptors.add(baseDescriptor);
                }
            }
        }
        if (n2 <= 2) return;
        if ((byteBuffer = ObjectDescriptorFactory.createFrom(-1, byteBuffer)) instanceof ExtensionDescriptor) {
            this.extensionDescriptors.add((ExtensionDescriptor)byteBuffer);
            return;
        }
        this.unknownDescriptors.add((BaseDescriptor)byteBuffer);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InitialObjectDescriptor");
        stringBuilder.append("{objectDescriptorId=").append(this.objectDescriptorId);
        stringBuilder.append(", urlFlag=").append(this.urlFlag);
        stringBuilder.append(", includeInlineProfileLevelFlag=").append(this.includeInlineProfileLevelFlag);
        stringBuilder.append(", urlLength=").append(this.urlLength);
        stringBuilder.append(", urlString='").append(this.urlString).append('\'');
        stringBuilder.append(", oDProfileLevelIndication=").append(this.oDProfileLevelIndication);
        stringBuilder.append(", sceneProfileLevelIndication=").append(this.sceneProfileLevelIndication);
        stringBuilder.append(", audioProfileLevelIndication=").append(this.audioProfileLevelIndication);
        stringBuilder.append(", visualProfileLevelIndication=").append(this.visualProfileLevelIndication);
        stringBuilder.append(", graphicsProfileLevelIndication=").append(this.graphicsProfileLevelIndication);
        stringBuilder.append(", esDescriptors=").append(this.esDescriptors);
        stringBuilder.append(", extensionDescriptors=").append(this.extensionDescriptors);
        stringBuilder.append(", unknownDescriptors=").append(this.unknownDescriptors);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

