/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.piff.ProtectionSpecificHeader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PlayReadyHeader
extends ProtectionSpecificHeader {
    private long length;
    private List<PlayReadyRecord> records;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ByteBuffer getData() {
        Object object = this.records.iterator();
        int n2 = 6;
        while (true) {
            if (!object.hasNext()) break;
            n2 = object.next().getValue().rewind().limit() + (n2 + 4);
        }
        object = ByteBuffer.allocate(n2);
        IsoTypeWriter.writeUInt32BE((ByteBuffer)object, n2);
        IsoTypeWriter.writeUInt16BE((ByteBuffer)object, this.records.size());
        Iterator<PlayReadyRecord> iterator = this.records.iterator();
        while (iterator.hasNext()) {
            PlayReadyRecord playReadyRecord = iterator.next();
            IsoTypeWriter.writeUInt16BE((ByteBuffer)object, playReadyRecord.type);
            IsoTypeWriter.writeUInt16BE((ByteBuffer)object, playReadyRecord.getValue().limit());
            ((ByteBuffer)object).put(playReadyRecord.getValue());
        }
        return object;
    }

    public List<PlayReadyRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.length = IsoTypeReader.readUInt32BE(byteBuffer);
        this.records = PlayReadyRecord.createFor(byteBuffer, IsoTypeReader.readUInt16BE(byteBuffer));
    }

    public void setRecords(List<PlayReadyRecord> list) {
        this.records = list;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlayReadyHeader");
        stringBuilder.append("{length=").append(this.length);
        stringBuilder.append(", recordCount=").append(this.records.size());
        stringBuilder.append(", records=").append(this.records);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static abstract class PlayReadyRecord {
        int type;

        public PlayReadyRecord(int n2) {
            this.type = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static List<PlayReadyRecord> createFor(ByteBuffer byteBuffer, int n2) {
            ArrayList<PlayReadyRecord> arrayList = new ArrayList<PlayReadyRecord>(n2);
            int n3 = 0;
            while (n3 < n2) {
                PlayReadyRecord playReadyRecord;
                int n4 = IsoTypeReader.readUInt16BE(byteBuffer);
                int n5 = IsoTypeReader.readUInt16BE(byteBuffer);
                switch (n4) {
                    default: {
                        playReadyRecord = new DefaulPlayReadyRecord(n4);
                        break;
                    }
                    case 1: {
                        playReadyRecord = new RMHeader();
                        break;
                    }
                    case 2: {
                        playReadyRecord = new DefaulPlayReadyRecord(2);
                        break;
                    }
                    case 3: {
                        playReadyRecord = new EmeddedLicenseStore();
                    }
                }
                playReadyRecord.parse((ByteBuffer)byteBuffer.slice().limit(n5));
                byteBuffer.position(byteBuffer.position() + n5);
                arrayList.add(playReadyRecord);
                ++n3;
            }
            return arrayList;
        }

        public abstract ByteBuffer getValue();

        public abstract void parse(ByteBuffer var1);

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PlayReadyRecord");
            stringBuilder.append("{type=").append(this.type);
            stringBuilder.append(", length=").append(this.getValue().limit());
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public static class DefaulPlayReadyRecord
        extends PlayReadyRecord {
            ByteBuffer value;

            public DefaulPlayReadyRecord(int n2) {
                super(n2);
            }

            @Override
            public ByteBuffer getValue() {
                return this.value;
            }

            @Override
            public void parse(ByteBuffer byteBuffer) {
                this.value = byteBuffer.duplicate();
            }
        }

        public static class EmeddedLicenseStore
        extends PlayReadyRecord {
            ByteBuffer value;

            public EmeddedLicenseStore() {
                super(3);
            }

            @Override
            public ByteBuffer getValue() {
                return this.value;
            }

            @Override
            public void parse(ByteBuffer byteBuffer) {
                this.value = byteBuffer.duplicate();
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("EmeddedLicenseStore");
                stringBuilder.append("{length=").append(this.getValue().limit());
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        }

        public static class RMHeader
        extends PlayReadyRecord {
            String header;

            public RMHeader() {
                super(1);
            }

            public String getHeader() {
                return this.header;
            }

            @Override
            public ByteBuffer getValue() {
                byte[] byArray;
                try {
                    byArray = this.header.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                return ByteBuffer.wrap(byArray);
            }

            @Override
            public void parse(ByteBuffer object) {
                try {
                    byte[] byArray = new byte[((ByteBuffer)object).slice().limit()];
                    ((ByteBuffer)object).get(byArray);
                    this.header = object = new String(byArray, "UTF-16LE");
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
            }

            public void setHeader(String string2) {
                this.header = string2;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("RMHeader");
                stringBuilder.append("{length=").append(this.getValue().limit());
                stringBuilder.append(", header='").append(this.header).append('\'');
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        }
    }
}

