/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.Hex;
import com.googlecode.mp4parser.boxes.piff.PlayReadyHeader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ProtectionSpecificHeader {
    protected static Map<UUID, Class<? extends ProtectionSpecificHeader>> uuidRegistry = new HashMap<UUID, Class<? extends ProtectionSpecificHeader>>();
    ByteBuffer data;

    static {
        uuidRegistry.put(UUID.fromString("9A04F079-9840-4286-AB92-E65BE0885F95"), PlayReadyHeader.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProtectionSpecificHeader createFor(UUID object, ByteBuffer byteBuffer) {
        Class<? extends ProtectionSpecificHeader> clazz = uuidRegistry.get(object);
        object = new ProtectionSpecificHeader();
        if (clazz != null) {
            try {
                object = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        ((ProtectionSpecificHeader)object).parse(byteBuffer);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof ProtectionSpecificHeader)) return false;
        if (!this.getClass().equals(object.getClass())) return false;
        return this.data.equals(((ProtectionSpecificHeader)object).data);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void parse(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProtectionSpecificHeader");
        stringBuilder.append("{data=");
        ByteBuffer byteBuffer = this.getData().duplicate();
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        stringBuilder.append(Hex.encodeHex(byArray));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

