/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

public class IntHashMap {
    private transient int count;
    private float loadFactor;
    private transient Entry[] table;
    private int threshold;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n2) {
        this(n2, 0.75f);
    }

    public IntHashMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        int n3 = n2;
        if (n2 == 0) {
            n3 = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n3];
        this.threshold = (int)((float)n3 * f2);
    }

    public void clear() {
        synchronized (this) {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            while (true) {
                if (--n2 < 0) {
                    this.count = 0;
                    return;
                }
                entryArray[n2] = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        block0: while (true) {
            int n3 = n2 - 1;
            if (n2 <= 0) {
                return false;
            }
            Entry entry = entryArray[n3];
            while (true) {
                if (entry == null) {
                    n2 = n3;
                    continue block0;
                }
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsKey(int n2) {
        Entry[] entryArray = this.table;
        Entry entry = entryArray[(Integer.MAX_VALUE & n2) % entryArray.length];
        void var2_4;
        while (var2_4 != null) {
            if (var2_4.hash == n2) {
                return true;
            }
            Entry entry2 = var2_4.next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(int n2) {
        Entry[] entryArray = this.table;
        Entry entry = entryArray[(Integer.MAX_VALUE & n2) % entryArray.length];
        void var2_6;
        void var2_4;
        while (var2_4 != null) {
            if (var2_4.hash == n2) {
                Object object = var2_4.value;
                return var2_6;
            }
            Entry entry2 = var2_4.next;
        }
        return var2_6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        if (this.count != 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(int n2, Object object) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (true) {
            void var2_4;
            void var5_10;
            if (var5_10 == null) {
                void var5_13;
                Entry[] entryArray2 = entryArray;
                if (this.count >= this.threshold) {
                    this.rehash();
                    Entry[] entryArray3 = this.table;
                    n3 = (n2 & Integer.MAX_VALUE) % entryArray3.length;
                }
                var5_13[n3] = new Entry(n2, n2, object, (Entry)var5_13[n3]);
                ++this.count;
                return var2_4;
            }
            if (var5_10.hash == n2) {
                Object object2 = var5_10.value;
                var5_10.value = object;
                Object object3 = object2;
                return var2_4;
            }
            Entry entry2 = var5_10.next;
        }
    }

    protected void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = entryArray2;
        block0: while (true) {
            int n4 = n2 - 1;
            if (n2 <= 0) {
                return;
            }
            Entry entry = entryArray[n4];
            while (true) {
                if (entry == null) {
                    n2 = n4;
                    continue block0;
                }
                Entry entry2 = entry.next;
                n2 = (entry.hash & Integer.MAX_VALUE) % n3;
                entry.next = entryArray2[n2];
                entryArray2[n2] = entry;
                entry = entry2;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (Integer.MAX_VALUE & n2) % entryArray.length;
        Object object = entryArray[n3];
        Object object2 = null;
        while (object != null) {
            if (((Entry)object).hash == n2) {
                if (object2 != null) {
                    ((Entry)object2).next = ((Entry)object).next;
                } else {
                    entryArray[n3] = ((Entry)object).next;
                }
                --this.count;
                object2 = ((Entry)object).value;
                ((Entry)object).value = null;
                return object2;
            }
            Entry entry = ((Entry)object).next;
            object2 = object;
            object = entry;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private static class Entry {
        int hash;
        int key;
        Entry next;
        Object value;

        protected Entry(int n2, int n3, Object object, Entry entry) {
            this.hash = n2;
            this.key = n3;
            this.value = object;
            this.next = entry;
        }
    }
}

