/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import java.nio.ByteBuffer;

public class Matrix {
    public static final Matrix ROTATE_0 = new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    public static final Matrix ROTATE_180;
    public static final Matrix ROTATE_270;
    public static final Matrix ROTATE_90;
    double a;
    double b;
    double c;
    double d;
    double tx;
    double ty;
    double u;
    double v;
    double w;

    static {
        ROTATE_90 = new Matrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ROTATE_180 = new Matrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ROTATE_270 = new Matrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Matrix(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.u = d6;
        this.v = d7;
        this.w = d8;
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = d5;
        this.tx = d9;
        this.ty = d10;
    }

    public static Matrix fromByteBuffer(ByteBuffer byteBuffer) {
        return Matrix.fromFileOrder(IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint0230(byteBuffer), IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint0230(byteBuffer), IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint1616(byteBuffer), IsoTypeReader.readFixedPoint0230(byteBuffer));
    }

    public static Matrix fromFileOrder(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return new Matrix(d2, d3, d5, d6, d4, d7, d10, d8, d9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return bl;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Matrix)object;
        if (Double.compare(((Matrix)object).a, this.a) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).b, this.b) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).c, this.c) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).d, this.d) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).tx, this.tx) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).ty, this.ty) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).u, this.u) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).v, this.v) != 0) {
            return false;
        }
        if (Double.compare(((Matrix)object).w, this.w) == 0) return bl;
        return false;
    }

    public void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.a);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.b);
        IsoTypeWriter.writeFixedPoint0230(byteBuffer, this.u);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.c);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.d);
        IsoTypeWriter.writeFixedPoint0230(byteBuffer, this.v);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.tx);
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.ty);
        IsoTypeWriter.writeFixedPoint0230(byteBuffer, this.w);
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.u);
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.v);
        int n3 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.w);
        int n4 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.a);
        int n5 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.b);
        int n6 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.c);
        int n7 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.d);
        int n8 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.tx);
        int n9 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.ty);
        return (((((((n2 * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.equals(ROTATE_0)) {
            return "Rotate 0\u00b0";
        }
        if (this.equals(ROTATE_90)) {
            return "Rotate 90\u00b0";
        }
        if (this.equals(ROTATE_180)) {
            return "Rotate 180\u00b0";
        }
        if (!this.equals(ROTATE_270)) return "Matrix{u=" + this.u + ", v=" + this.v + ", w=" + this.w + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", tx=" + this.tx + ", ty=" + this.ty + '}';
        return "Rotate 270\u00b0";
    }
}

