/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.TlsVersion;
import com.squareup.okhttp.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
    public static final ConnectionSpec CLEARTEXT;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec MODERN_TLS;
    private final String[] cipherSuites;
    private final boolean supportsTlsExtensions;
    private final boolean tls;
    private final String[] tlsVersions;

    static {
        MODERN_TLS = new Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    private ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean nonEmptyIntersection(String[] stringArray, String[] stringArray2) {
        boolean bl;
        boolean bl2 = bl = false;
        if (stringArray == null) return bl2;
        bl2 = bl;
        if (stringArray2 == null) return bl2;
        bl2 = bl;
        if (stringArray.length == 0) return bl2;
        if (stringArray2.length == 0) {
            return bl;
        }
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            bl2 = bl;
            if (n3 >= n2) return bl2;
            if (Util.contains(stringArray2, stringArray[n3])) {
                return true;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ConnectionSpec supportedSpec(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray = this.cipherSuites != null ? Util.intersect(String.class, this.cipherSuites, sSLSocket.getEnabledCipherSuites()) : sSLSocket.getEnabledCipherSuites();
        String[] stringArray2 = this.tlsVersions != null ? Util.intersect(String.class, this.tlsVersions, sSLSocket.getEnabledProtocols()) : sSLSocket.getEnabledProtocols();
        String[] stringArray3 = stringArray;
        if (bl) {
            stringArray3 = stringArray;
            if (Util.contains(sSLSocket.getSupportedCipherSuites(), "TLS_FALLBACK_SCSV")) {
                stringArray3 = Util.concat(stringArray, "TLS_FALLBACK_SCSV");
            }
        }
        return new Builder(this).cipherSuites(stringArray3).tlsVersions(stringArray2).build();
    }

    void apply(SSLSocket sSLSocket, boolean bl) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CipherSuite> cipherSuites() {
        void var1_2;
        if (this.cipherSuites == null) {
            return var1_2;
        }
        CipherSuite[] cipherSuiteArray = new CipherSuite[this.cipherSuites.length];
        for (int i2 = 0; i2 < this.cipherSuites.length; ++i2) {
            cipherSuiteArray[i2] = CipherSuite.forJavaName(this.cipherSuites[i2]);
        }
        List<CipherSuite> list = Util.immutableList(cipherSuiteArray);
        return var1_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof ConnectionSpec)) {
            return bl;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        boolean bl2 = bl;
        if (this.tls != ((ConnectionSpec)object).tls) return bl2;
        if (!this.tls) return true;
        bl2 = bl;
        if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) return bl2;
        bl2 = bl;
        if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) return bl2;
        bl2 = bl;
        if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) return bl2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 17;
        if (this.tls) {
            int n3 = Arrays.hashCode(this.cipherSuites);
            int n4 = Arrays.hashCode(this.tlsVersions);
            n2 = this.supportsTlsExtensions ? 0 : 1;
            n2 += ((n3 + 527) * 31 + n4) * 31;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCompatible(SSLSocket sSLSocket) {
        boolean bl;
        boolean bl2 = false;
        if (!this.tls) {
            return bl2;
        }
        if (this.tlsVersions != null) {
            bl = bl2;
            if (!ConnectionSpec.nonEmptyIntersection(this.tlsVersions, sSLSocket.getEnabledProtocols())) return bl;
        }
        if (this.cipherSuites == null) return true;
        bl = bl2;
        if (!ConnectionSpec.nonEmptyIntersection(this.cipherSuites, sSLSocket.getEnabledCipherSuites())) return bl;
        return true;
    }

    public boolean isTls() {
        return this.tls;
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<TlsVersion> tlsVersions() {
        void var1_2;
        if (this.tlsVersions == null) {
            return var1_2;
        }
        TlsVersion[] tlsVersionArray = new TlsVersion[this.tlsVersions.length];
        for (int i2 = 0; i2 < this.tlsVersions.length; ++i2) {
            tlsVersionArray[i2] = TlsVersion.forJavaName(this.tlsVersions[i2]);
        }
        List<TlsVersion> list = Util.immutableList(tlsVersionArray);
        return var1_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string2 = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string3 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string2 + ", tlsVersions=" + string3 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    public static final class Builder {
        private String[] cipherSuites;
        private boolean supportsTlsExtensions;
        private boolean tls;
        private String[] tlsVersions;

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder allEnabledCipherSuites() {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            this.cipherSuites = null;
            return this;
        }

        public Builder allEnabledTlsVersions() {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            this.tlsVersions = null;
            return this;
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            String[] stringArray = new String[cipherSuiteArray.length];
            for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
                stringArray[i2] = cipherSuiteArray[i2].javaName;
            }
            return this.cipherSuites(stringArray);
        }

        public Builder cipherSuites(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            this.cipherSuites = (String[])stringArray.clone();
            return this;
        }

        public Builder supportsTlsExtensions(boolean bl) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS extensions for cleartext connections");
            }
            this.supportsTlsExtensions = bl;
            return this;
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            String[] stringArray = new String[tlsVersionArray.length];
            for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
                stringArray[i2] = tlsVersionArray[i2].javaName;
            }
            return this.tlsVersions(stringArray);
        }

        public Builder tlsVersions(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            this.tlsVersions = (String[])stringArray.clone();
            return this;
        }
    }
}

