/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.Util;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class Handshake {
    private final String cipherSuite;
    private final List<Certificate> localCertificates;
    private final List<Certificate> peerCertificates;

    private Handshake(String string2, List<Certificate> list, List<Certificate> list2) {
        this.cipherSuite = string2;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(String string2, List<Certificate> list, List<Certificate> list2) {
        if (string2 == null) {
            throw new IllegalArgumentException("cipherSuite == null");
        }
        return new Handshake(string2, Util.immutableList(list), Util.immutableList(list2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Handshake get(SSLSession object) {
        void var0_3;
        void var2_9;
        Certificate[] certificateArray;
        void var2_7;
        String string2 = object.getCipherSuite();
        if (string2 == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        try {
            Certificate[] certificateArray2 = object.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            Object var2_11 = null;
        }
        if (var2_7 != null) {
            List list = Util.immutableList(var2_7);
        } else {
            List list = Collections.emptyList();
        }
        if ((certificateArray = object.getLocalCertificates()) != null) {
            List<Certificate> list = Util.immutableList(certificateArray);
            return new Handshake(string2, (List<Certificate>)var2_9, (List<Certificate>)var0_3);
        }
        List list = Collections.emptyList();
        return new Handshake(string2, (List<Certificate>)var2_9, (List<Certificate>)var0_3);
    }

    public String cipherSuite() {
        return this.cipherSuite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof Handshake)) {
            return bl;
        }
        object = (Handshake)object;
        boolean bl2 = bl;
        if (!this.cipherSuite.equals(((Handshake)object).cipherSuite)) return bl2;
        bl2 = bl;
        if (!this.peerCertificates.equals(((Handshake)object).peerCertificates)) return bl2;
        bl2 = bl;
        if (!this.localCertificates.equals(((Handshake)object).localCertificates)) return bl2;
        return true;
    }

    public int hashCode() {
        return ((this.cipherSuite.hashCode() + 527) * 31 + this.peerCertificates.hashCode()) * 31 + this.localCertificates.hashCode();
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Principal localPrincipal() {
        if (this.localCertificates.isEmpty()) return null;
        return ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal();
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Principal peerPrincipal() {
        if (this.peerCertificates.isEmpty()) return null;
        return ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal();
    }
}

