/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import java.net.IDN;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import s.c;

public final class HttpUrl {
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_COMPONENT_ENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    private final String fragment;
    private final String host;
    private final String password;
    private final List<String> pathSegments;
    private final int port;
    private final List<String> queryNamesAndValues;
    private final String scheme;
    private final String url;
    private final String username;

    /*
     * Enabled aggressive block sorting
     */
    private HttpUrl(Builder builder) {
        Object var2_2 = null;
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        List<String> list = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.queryNamesAndValues = list;
        list = var2_2;
        if (builder.encodedFragment != null) {
            list = HttpUrl.percentDecode(builder.encodedFragment, false);
        }
        this.fragment = list;
        this.url = builder.toString();
    }

    static /* synthetic */ String access$100(HttpUrl httpUrl) {
        return httpUrl.scheme;
    }

    static /* synthetic */ String access$300(HttpUrl httpUrl) {
        return httpUrl.host;
    }

    static /* synthetic */ int access$400(HttpUrl httpUrl) {
        return httpUrl.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String canonicalize(String string2, int n2, int n3, String string3, boolean bl, boolean bl2, boolean bl3) {
        int n4 = n2;
        while (n4 < n3) {
            int n5 = string2.codePointAt(n4);
            if (n5 < 32 || n5 == 127 || n5 >= 128 && bl3 || string3.indexOf(n5) != -1 || n5 == 37 && !bl || n5 == 43 && bl2) {
                c c2 = new c();
                c2.a(string2, n2, n4);
                HttpUrl.canonicalize(c2, string2, n4, n3, string3, bl, bl2, bl3);
                return c2.p();
            }
            n4 += Character.charCount(n5);
        }
        return string2.substring(n2, n3);
    }

    static String canonicalize(String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return HttpUrl.canonicalize(string2, 0, string2.length(), string3, bl, bl2, bl3);
    }

    /*
     * Unable to fully structure code
     */
    static void canonicalize(c var0, String var1_1, int var2_2, int var3_3, String var4_4, boolean var5_5, boolean var6_6, boolean var7_7) {
        var8_8 = null;
        block0: while (var2_2 < var3_3) {
            block12: {
                block10: {
                    block11: {
                        block8: {
                            block9: {
                                var9_9 = var1_1.codePointAt(var2_2);
                                if (!var5_5) break block8;
                                var10_10 = var8_8;
                                if (var9_9 == 9) break block9;
                                var10_10 = var8_8;
                                if (var9_9 == 10) break block9;
                                var10_10 = var8_8;
                                if (var9_9 == 12) break block9;
                                if (var9_9 != 13) break block8;
                                var10_10 = var8_8;
                            }
lbl14:
                            // 4 sources

                            while (true) {
                                var2_2 += Character.charCount(var9_9);
                                var8_8 = var10_10;
                                continue block0;
                                break;
                            }
                        }
                        if (var9_9 != 43 || !var6_6) break block10;
                        if (!var5_5) break block11;
                        var11_11 = "+";
lbl22:
                        // 2 sources

                        while (true) {
                            var0.a(var11_11);
                            var10_10 = var8_8;
                            ** GOTO lbl14
                            break;
                        }
                    }
                    var11_11 = "%2B";
                    ** continue;
                }
                if (var9_9 >= 32 && var9_9 != 127 && (var9_9 < 128 || !var7_7) && var4_4.indexOf(var9_9) == -1 && (var9_9 != 37 || var5_5)) break block12;
                var11_11 = var8_8;
                if (var8_8 == null) {
                    var11_11 = new c();
                }
                var11_11.a(var9_9);
                while (true) {
                    var10_10 = var11_11;
                    if (var11_11.e()) ** GOTO lbl14
                    var12_12 = var11_11.h() & 255;
                    var0.b(37);
                    var0.b((int)HttpUrl.HEX_DIGITS[var12_12 >> 4 & 15]);
                    var0.b((int)HttpUrl.HEX_DIGITS[var12_12 & 15]);
                }
            }
            var0.a(var9_9);
            var10_10 = var8_8;
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return (char)(c2 - 48);
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return (char)(c2 - 97 + 10);
        }
        if (c2 < 'A') return (char)-1;
        if (c2 > 'F') return (char)-1;
        return (char)(c2 - 65 + 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int defaultPort(String string2) {
        if (string2.equals("http")) {
            return 80;
        }
        if (!string2.equals("https")) return -1;
        return 443;
    }

    private static int delimiterOffset(String string2, int n2, int n3, String string3) {
        while (true) {
            block4: {
                int n4;
                block3: {
                    n4 = n3;
                    if (n2 >= n3) break block3;
                    if (string3.indexOf(string2.charAt(n2)) == -1) break block4;
                    n4 = n2;
                }
                return n4;
            }
            ++n2;
        }
    }

    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    static HttpUrl getChecked(String string2) throws MalformedURLException, UnknownHostException {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(null, string2);
        switch (parseResult) {
            default: {
                throw new MalformedURLException("Invalid URL: " + (Object)((Object)parseResult) + " for " + string2);
            }
            case SUCCESS: {
                return builder.build();
            }
            case INVALID_HOST: 
        }
        throw new UnknownHostException("Invalid host: " + string2);
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string2 = list.get(i2);
            String string3 = list.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string2);
            if (string3 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string3);
        }
    }

    public static HttpUrl parse(String string2) {
        HttpUrl httpUrl = null;
        Builder builder = new Builder();
        if (builder.parse(null, string2) == Builder.ParseResult.SUCCESS) {
            httpUrl = builder.build();
        }
        return httpUrl;
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i2));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String percentDecode(String string2, int n2, int n3, boolean bl) {
        int n4 = n2;
        while (n4 < n3) {
            char c2 = string2.charAt(n4);
            if (c2 == '%' || c2 == '+' && bl) {
                c c3 = new c();
                c3.a(string2, n2, n4);
                HttpUrl.percentDecode(c3, string2, n4, n3, bl);
                return c3.p();
            }
            ++n4;
        }
        return string2.substring(n2, n3);
    }

    static String percentDecode(String string2, boolean bl) {
        return HttpUrl.percentDecode(string2, 0, string2.length(), bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> percentDecode(List<String> object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            object = object != null ? HttpUrl.percentDecode((String)object, bl) : null;
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static void percentDecode(c var0, String var1_1, int var2_2, int var3_3, boolean var4_4) {
        block0: while (var2_2 < var3_3) {
            block4: {
                block3: {
                    var5_5 = var1_1.codePointAt(var2_2);
                    if (var5_5 != 37 || var2_2 + 2 >= var3_3) break block3;
                    var6_6 = HttpUrl.decodeHexDigit(var1_1.charAt(var2_2 + 1));
                    var7_7 = HttpUrl.decodeHexDigit(var1_1.charAt(var2_2 + 2));
                    if (var6_6 != -1 && var7_7 != -1) {
                        var0.b((var6_6 << 4) + var7_7);
                        var2_2 += 2;
lbl10:
                        // 3 sources

                        while (true) {
                            var2_2 += Character.charCount(var5_5);
                            continue block0;
                            break;
                        }
                    }
                    break block4;
                }
                if (var5_5 != 43 || !var4_4) break block4;
                var0.b(32);
                ** GOTO lbl10
            }
            var0.a(var5_5);
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static List<String> queryStringToNamesAndValues(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string2.length()) {
            int n3;
            int n4 = n3 = string2.indexOf(38, n2);
            if (n3 == -1) {
                n4 = string2.length();
            }
            if ((n3 = string2.indexOf(61, n2)) == -1 || n3 > n4) {
                arrayList.add(string2.substring(n2, n4));
                arrayList.add(null);
            } else {
                arrayList.add(string2.substring(n2, n3));
                arrayList.add(string2.substring(n3 + 1, n4));
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n2 = this.url.indexOf(35);
        return this.url.substring(n2 + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.url.indexOf(58, this.scheme.length() + 3);
        int n3 = this.url.indexOf(64);
        return this.url.substring(n2 + 1, n3);
    }

    public String encodedPath() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = HttpUrl.delimiterOffset(this.url, n2, this.url.length(), "?#");
        return this.url.substring(n2, n3);
    }

    public List<String> encodedPathSegments() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = HttpUrl.delimiterOffset(this.url, n2, this.url.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            int n4 = n2 + 1;
            n2 = HttpUrl.delimiterOffset(this.url, n4, n3, "/");
            arrayList.add(this.url.substring(n4, n2));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.url.indexOf(63) + 1;
        int n3 = HttpUrl.delimiterOffset(this.url, n2 + 1, this.url.length(), "#");
        return this.url.substring(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.scheme.length() + 3;
        int n3 = HttpUrl.delimiterOffset(this.url, n2, this.url.length(), ":@");
        return this.url.substring(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof HttpUrl)) return false;
        if (!((HttpUrl)object).url.equals(this.url)) return false;
        return true;
    }

    public String fragment() {
        return this.fragment;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String host() {
        return this.host;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        int n2 = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.port = n2;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    public String password() {
        return this.password;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public int port() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String query() {
        void var1_2;
        if (this.queryNamesAndValues == null) {
            return var1_2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        String string2 = stringBuilder.toString();
        return var1_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String queryParameter(String string2) {
        String string3 = null;
        if (this.queryNamesAndValues == null) {
            return string3;
        }
        int n2 = 0;
        int n3 = this.queryNamesAndValues.size();
        while (true) {
            String string4 = string3;
            if (n2 >= n3) return string4;
            if (string2.equals(this.queryNamesAndValues.get(n2))) {
                return this.queryNamesAndValues.get(n2 + 1);
            }
            n2 += 2;
        }
    }

    public String queryParameterName(int n2) {
        return this.queryNamesAndValues.get(n2 * 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        Set<String> set = new LinkedHashSet<String>();
        int n2 = 0;
        int n3 = this.queryNamesAndValues.size();
        while (n2 < n3) {
            set.add(this.queryNamesAndValues.get(n2));
            n2 += 2;
        }
        return Collections.unmodifiableSet(set);
    }

    public String queryParameterValue(int n2) {
        return this.queryNamesAndValues.get(n2 * 2 + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> queryParameterValues(String list) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = this.queryNamesAndValues.size();
        while (n2 < n3) {
            if (((String)((Object)list)).equals(this.queryNamesAndValues.get(n2))) {
                arrayList.add(this.queryNamesAndValues.get(n2 + 1));
            }
            n2 += 2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int querySize() {
        if (this.queryNamesAndValues == null) return 0;
        return this.queryNamesAndValues.size() / 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpUrl resolve(String object) {
        Builder builder = new Builder();
        if (builder.parse(this, (String)object) != Builder.ParseResult.SUCCESS) return null;
        return builder.build();
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        return this.url;
    }

    public URI uri() {
        try {
            URI uRI = new URI(this.newBuilder().reencodeForUri().toString());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("not valid as a java.net.URI: " + this.url);
        }
    }

    public URL url() {
        try {
            URL uRL = new URL(this.url);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String username() {
        return this.username;
    }

    public static final class Builder {
        String encodedFragment;
        String encodedPassword = "";
        final List<String> encodedPathSegments = new ArrayList<String>();
        List<String> encodedQueryNamesAndValues;
        String encodedUsername = "";
        String host;
        int port = -1;
        String scheme;

        public Builder() {
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static String canonicalizeHost(String object, int n2, int n3) {
            if (!((String)(object = HttpUrl.percentDecode((String)object, n2, n3, false))).startsWith("[")) return Builder.domainToAscii((String)object);
            if (!((String)object).endsWith("]")) return Builder.domainToAscii((String)object);
            if ((object = Builder.decodeIpv6((String)object, 1, ((String)object).length() - 1)) == null) {
                return null;
            }
            if (((Object)(object = (Object)((InetAddress)object).getAddress())).length != 16) throw new AssertionError();
            return Builder.inet6AddressToAscii((byte[])object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean containsInvalidHostnameAsciiCodes(String string2) {
            boolean bl = false;
            int n2 = 0;
            while (true) {
                boolean bl2 = bl;
                if (n2 >= string2.length()) return bl2;
                char c2 = string2.charAt(n2);
                if (c2 <= '\u001f') return true;
                if (c2 >= '\u007f') {
                    return true;
                }
                if (" #%/:?@[\\]".indexOf(c2) != -1) {
                    return true;
                }
                ++n2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean decodeIpv4Suffix(String string2, int n2, int n3, byte[] byArray, int n4) {
            int n5 = n4;
            int n6 = n2;
            while (n6 < n3) {
                if (n5 == byArray.length) {
                    return false;
                }
                n2 = n6;
                if (n5 != n4) {
                    if (string2.charAt(n6) != '.') {
                        return false;
                    }
                    n2 = n6 + 1;
                }
                int n7 = 0;
                n6 = n2;
                while (true) {
                    char c2;
                    if (n6 >= n3 || (c2 = string2.charAt(n6)) < '0' || c2 > '9') {
                        if (n6 - n2 != 0) break;
                        return false;
                    }
                    if (n7 == 0 && n2 != n6) {
                        return false;
                    }
                    if ((n7 = n7 * 10 + c2 - 48) > 255) {
                        return false;
                    }
                    ++n6;
                }
                byArray[n5] = (byte)n7;
                ++n5;
            }
            if (n5 == n4 + 4) return true;
            return false;
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static InetAddress decodeIpv6(String var0, int var1_2, int var2_3) {
            block12: {
                block13: {
                    var3_4 = new byte[16];
                    var4_5 = -1;
                    var5_6 = -1;
                    var6_7 = 0;
                    var7_8 = var1_2;
                    block2: while (true) {
                        block15: {
                            block14: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                var8_9 = var5_6;
                                                var1_2 = var6_7;
                                                if (var7_8 >= var2_3) break block16;
                                                if (var6_7 == var3_4.length) {
                                                    return null;
                                                }
                                                if (var7_8 + 2 > var2_3 || !var0.regionMatches(var7_8, "::", 0, 2)) break block17;
                                                if (var5_6 != -1) {
                                                    return null;
                                                }
                                                var1_2 = var7_8 + 2;
                                                var6_7 += 2;
                                                if (var1_2 != var2_3) break block12;
                                                var1_2 = var6_7;
                                                var8_9 = var6_7;
                                            }
lbl21:
                                            // 2 sources

                                            while (var1_2 != var3_4.length) {
                                                if (var8_9 != -1) break block2;
                                                return null;
                                            }
                                            break block13;
                                        }
                                        var1_2 = var7_8;
                                        var8_9 = var5_6;
                                        var9_10 = var6_7;
                                        if (var6_7 == 0) break block18;
                                        if (!var0.regionMatches(var7_8, ":", 0, 1)) break block19;
                                        var1_2 = var7_8 + 1;
                                        var9_10 = var6_7;
                                        var8_9 = var5_6;
                                    }
lbl35:
                                    // 2 sources

                                    while (true) {
                                        var5_6 = 0;
                                        var6_7 = var1_2;
lbl38:
                                        // 2 sources

                                        while (true) {
                                            if (var6_7 < var2_3 && (var7_8 = HttpUrl.decodeHexDigit(var0.charAt(var6_7))) != -1) break block14;
                                            var7_8 = var6_7 - var1_2;
                                            if (var7_8 == 0) return null;
                                            if (var7_8 > 4) {
                                                return null;
                                            }
                                            break block15;
                                            break;
                                        }
                                        break;
                                    }
                                }
                                if (var0.regionMatches(var7_8, ".", 0, 1) == false) return null;
                                if (!Builder.decodeIpv4Suffix((String)var0, var4_5, var2_3, var3_4, var6_7 - 2)) {
                                    return null;
                                }
                                var1_2 = var6_7 + 2;
                                var8_9 = var5_6;
                                ** GOTO lbl21
                            }
                            var5_6 = (var5_6 << 4) + var7_8;
                            ++var6_7;
                            ** continue;
                        }
                        var7_8 = var9_10 + 1;
                        var3_4[var9_10] = (byte)(var5_6 >>> 8 & 255);
                        var9_10 = var7_8 + 1;
                        var3_4[var7_8] = (byte)(var5_6 & 255);
                        var7_8 = var6_7;
                        var5_6 = var8_9;
                        var6_7 = var9_10;
                        var4_5 = var1_2;
                    }
                    System.arraycopy(var3_4, var8_9, var3_4, var3_4.length - (var1_2 - var8_9), var1_2 - var8_9);
                    Arrays.fill(var3_4, var8_9, var3_4.length - var1_2 + var8_9, (byte)0);
                }
                try {
                    return InetAddress.getByAddress(var3_4);
                }
                catch (UnknownHostException var0_1) {
                    throw new AssertionError();
                }
            }
            var9_10 = var6_7;
            var8_9 = var6_7;
            ** while (true)
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static String domainToAscii(String string2) {
            String string3;
            Object var1_2;
            block3: {
                var1_2 = null;
                try {
                    string3 = IDN.toASCII(string2).toLowerCase(Locale.US);
                    if (!string3.isEmpty()) break block3;
                    return var1_2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return var1_2;
                }
            }
            boolean bl = Builder.containsInvalidHostnameAsciiCodes(string3);
            string2 = var1_2;
            if (bl) return string2;
            return string3;
        }

        private static String inet6AddressToAscii(byte[] byArray) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < byArray.length) {
                for (n2 = n6; n2 < 16 && byArray[n2] == 0 && byArray[n2 + 1] == 0; n2 += 2) {
                }
                int n7 = n2 - n6;
                int n8 = n4;
                if (n7 > n4) {
                    n8 = n7;
                    n5 = n6;
                }
                n6 = n2 + 2;
                n4 = n8;
            }
            c c2 = new c();
            n6 = n3;
            while (n6 < byArray.length) {
                if (n6 == n5) {
                    c2.b(58);
                    n6 = n2 = n6 + n4;
                    if (n2 != 16) continue;
                    c2.b(58);
                    n6 = n2;
                    continue;
                }
                if (n6 > 0) {
                    c2.b(58);
                }
                c2.i((long)((byArray[n6] & 0xFF) << 8 | byArray[n6 + 1] & 0xFF));
                n6 += 2;
            }
            return c2.p();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isDot(String string2) {
            if (string2.equals(".")) return true;
            if (!string2.equalsIgnoreCase("%2e")) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isDotDot(String string2) {
            if (string2.equals("..")) return true;
            if (string2.equalsIgnoreCase("%2e.")) return true;
            if (string2.equalsIgnoreCase(".%2e")) return true;
            if (!string2.equalsIgnoreCase("%2e%2e")) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int parsePort(String string2, int n2, int n3) {
            try {
                n2 = Integer.parseInt(HttpUrl.canonicalize(string2, n2, n3, HttpUrl.FRAGMENT_ENCODE_SET, false, false, true));
                if (n2 <= 0) return -1;
                if (n2 > 65535) return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void pop() {
            if (this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1).isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
                return;
            }
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        /*
         * Unable to fully structure code
         */
        private static int portColonOffset(String var0, int var1_1, int var2_2) {
            block4: while (var1_1 < var2_2) {
                var3_3 = var1_1;
                var4_4 = var1_1;
                switch (var0.charAt(var1_1)) {
                    default: {
                        var3_3 = var1_1;
lbl7:
                        // 3 sources

                        while (true) {
                            var1_1 = var3_3 + 1;
                            continue block4;
                            break;
                        }
                    }
                    case '[': {
                        do {
                            var3_3 = var1_1 = var3_3 + 1;
                            if (var1_1 >= var2_2) ** GOTO lbl7
                            var3_3 = var1_1;
                        } while (var0.charAt(var1_1) != ']');
                        var3_3 = var1_1;
                        ** continue;
                    }
                    case ':': {
                        return var4_4;
                    }
                }
            }
            var4_4 = var2_2;
            return var4_4;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void push(String string2, int n2, int n3, boolean bl, boolean bl2) {
            if (this.isDot(string2 = HttpUrl.canonicalize(string2, n2, n3, HttpUrl.PATH_SEGMENT_ENCODE_SET, bl2, false, true))) {
                return;
            }
            if (this.isDotDot(string2)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string2);
            } else {
                this.encodedPathSegments.add(string2);
            }
            if (!bl) return;
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        private void removeAllCanonicalQueryParameters(String string2) {
            int n2 = this.encodedQueryNamesAndValues.size() - 2;
            while (true) {
                block4: {
                    block3: {
                        if (n2 < 0) break block3;
                        if (!string2.equals(this.encodedQueryNamesAndValues.get(n2))) break block4;
                        this.encodedQueryNamesAndValues.remove(n2 + 1);
                        this.encodedQueryNamesAndValues.remove(n2);
                        if (!this.encodedQueryNamesAndValues.isEmpty()) break block4;
                        this.encodedQueryNamesAndValues = null;
                    }
                    return;
                }
                n2 -= 2;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void resolvePath(String string2, int n2, int n3) {
            if (n2 != n3) {
                int n4 = string2.charAt(n2);
                if (n4 == 47 || n4 == 92) {
                    this.encodedPathSegments.clear();
                    this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                    ++n2;
                } else {
                    this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
                }
                while (n2 < n3) {
                    n4 = HttpUrl.delimiterOffset(string2, n2, n3, "/\\");
                    boolean bl = n4 < n3;
                    this.push(string2, n2, n4, bl, true);
                    n2 = n4;
                    if (!bl) continue;
                    n2 = n4 + 1;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int schemeDelimiterOffset(String string2, int n2, int n3) {
            int n4;
            int n5 = -1;
            if (n3 - n2 < 2) {
                return n5;
            }
            char c2 = string2.charAt(n2);
            if (c2 < 'a' || c2 > 'z') {
                n4 = n5;
                if (c2 < 'A') return n4;
                n4 = n5;
                if (c2 > 'Z') return n4;
            }
            ++n2;
            while (true) {
                n4 = n5;
                if (n2 >= n3) return n4;
                c2 = string2.charAt(n2);
                if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-') && c2 != '.') break;
                ++n2;
            }
            n4 = n5;
            if (c2 != ':') return n4;
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int skipLeadingAsciiWhitespace(String string2, int n2, int n3) {
            while (true) {
                int n4 = n3;
                if (n2 >= n3) return n4;
                switch (string2.charAt(n2)) {
                    default: {
                        return n2;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                }
                ++n2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int skipTrailingAsciiWhitespace(String string2, int n2, int n3) {
            --n3;
            while (true) {
                int n4 = n2;
                if (n3 < n2) return n4;
                switch (string2.charAt(n3)) {
                    default: {
                        return n3 + 1;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                }
                --n3;
            }
        }

        private static int slashCount(String string2, int n2, int n3) {
            char c2;
            int n4 = 0;
            while (n2 < n3 && ((c2 = string2.charAt(n2)) == '\\' || c2 == '/')) {
                ++n4;
                ++n2;
            }
            return n4;
        }

        public Builder addEncodedPathSegment(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedPathSegment == null");
            }
            this.push(string2, 0, string2.length(), false, true);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder addEncodedQueryParameter(String string2, String string3) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, true, true));
            List<String> list = this.encodedQueryNamesAndValues;
            string2 = string3 != null ? HttpUrl.canonicalize(string3, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, true, true) : null;
            list.add(string2);
            return this;
        }

        public Builder addPathSegment(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("pathSegment == null");
            }
            this.push(string2, 0, string2.length(), false, false);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder addQueryParameter(String string2, String string3) {
            if (string2 == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, true, true));
            List<String> list = this.encodedQueryNamesAndValues;
            string2 = string3 != null ? HttpUrl.canonicalize(string3, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, true, true) : null;
            list.add(string2);
            return this;
        }

        public HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int effectivePort() {
            if (this.port == -1) return HttpUrl.defaultPort(this.scheme);
            return this.port;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder encodedFragment(String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        public Builder encodedPassword(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedPassword == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, true);
            return this;
        }

        public Builder encodedPath(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedPath == null");
            }
            if (!string2.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + string2);
            }
            this.resolvePath(string2, 0, string2.length());
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder encodedQuery(String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(list, HttpUrl.QUERY_ENCODE_SET, true, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder encodedUsername(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedUsername == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, true);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder fragment(String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        public Builder host(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("host == null");
            }
            String string3 = Builder.canonicalizeHost(string2, 0, string2.length());
            if (string3 == null) {
                throw new IllegalArgumentException("unexpected host: " + string2);
            }
            this.host = string3;
            return this;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        ParseResult parse(HttpUrl var1_1, String var2_2) {
            block25: {
                block23: {
                    block24: {
                        var3_3 = this.skipLeadingAsciiWhitespace(var2_2, 0, var2_2.length());
                        if (Builder.schemeDelimiterOffset(var2_2, var3_3, var4_4 = this.skipTrailingAsciiWhitespace(var2_2, var3_3, var2_2.length())) != -1) {
                            if (var2_2.regionMatches(true, var3_3, "https:", 0, 6)) {
                                this.scheme = "https";
                                var3_3 += "https:".length();
                            } else {
                                if (!var2_2.regionMatches(true, var3_3, "http:", 0, 5)) {
                                    return ParseResult.UNSUPPORTED_SCHEME;
                                }
                                this.scheme = "http";
                                var3_3 += "http:".length();
                            }
                        } else {
                            if (var1_1 /* !! */  == null) {
                                return ParseResult.MISSING_SCHEME;
                            }
                            this.scheme = HttpUrl.access$100(var1_1 /* !! */ );
                        }
                        if ((var5_5 = Builder.slashCount(var2_2, var3_3, var4_4)) >= 2 || var1_1 /* !! */  == null || !HttpUrl.access$100(var1_1 /* !! */ ).equals(this.scheme)) break block23;
                        this.encodedUsername = var1_1 /* !! */ .encodedUsername();
                        this.encodedPassword = var1_1 /* !! */ .encodedPassword();
                        this.host = HttpUrl.access$300(var1_1 /* !! */ );
                        this.port = HttpUrl.access$400(var1_1 /* !! */ );
                        this.encodedPathSegments.clear();
                        this.encodedPathSegments.addAll(var1_1 /* !! */ .encodedPathSegments());
                        if (var3_3 == var4_4) break block24;
                        var7_7 = var3_3;
                        if (var2_2.charAt(var3_3) != '#') break block25;
                    }
                    this.encodedQuery(var1_1 /* !! */ .encodedQuery());
                    var7_7 = var3_3;
                    break block25;
                }
                var6_6 = 0;
                var7_7 = 0;
                var5_5 = var3_3 + var5_5;
                var3_3 = var6_6;
                var6_6 = var5_5;
                block4: while (true) {
                    var5_5 = (var8_8 = HttpUrl.access$200(var2_2, var6_6, var4_4, "@/\\?#")) != var4_4 ? (int)var2_2.charAt(var8_8) : -1;
                    switch (var5_5) {
                        default: {
                            var5_5 = var3_3;
                            var3_3 = var6_6;
                            var6_6 = var5_5;
                            ** GOTO lbl64
                        }
                        case 64: {
                            if (var3_3 == 0) {
                                var5_5 = HttpUrl.access$200(var2_2, var6_6, var8_8, ":");
                                var9_9 = HttpUrl.canonicalize(var2_2, var6_6, var5_5, " \"':;<=>@[]^`{}|/\\?#", true, false, true);
                                var1_1 /* !! */  = var9_9;
                                if (var7_7 != 0) {
                                    var1_1 /* !! */  = this.encodedUsername + "%40" + var9_9;
                                }
                                this.encodedUsername = var1_1 /* !! */ ;
                                if (var5_5 != var8_8) {
                                    var3_3 = 1;
                                    this.encodedPassword = HttpUrl.canonicalize(var2_2, var5_5 + 1, var8_8, " \"':;<=>@[]^`{}|/\\?#", true, false, true);
                                }
                                var7_7 = 1;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(var2_2, var6_6, var8_8, " \"':;<=>@[]^`{}|/\\?#", true, false, true);
                            }
                            var5_5 = var8_8 + 1;
                            var6_6 = var3_3;
                            var3_3 = var5_5;
lbl64:
                            // 2 sources

                            var5_5 = var6_6;
                            var6_6 = var3_3;
                            var3_3 = var5_5;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: 
                    }
                    break;
                }
                var3_3 = Builder.portColonOffset(var2_2, var6_6, var8_8);
                if (var3_3 + 1 < var8_8) {
                    this.host = Builder.canonicalizeHost(var2_2, var6_6, var3_3);
                    this.port = Builder.parsePort(var2_2, var3_3 + 1, var8_8);
                    if (this.port == -1) {
                        return ParseResult.INVALID_PORT;
                    }
                } else {
                    this.host = Builder.canonicalizeHost(var2_2, var6_6, var3_3);
                    this.port = HttpUrl.defaultPort(this.scheme);
                }
                if (this.host == null) {
                    return ParseResult.INVALID_HOST;
                }
                var7_7 = var8_8;
            }
            var3_3 = HttpUrl.access$200(var2_2, var7_7, var4_4, "?#");
            this.resolvePath(var2_2, var7_7, var3_3);
            if (var3_3 < var4_4 && var2_2.charAt(var3_3) == '?') {
                var7_7 = HttpUrl.access$200(var2_2, var3_3, var4_4, "#");
                this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(var2_2, var3_3 + 1, var7_7, " \"'<>#", true, true, true));
                var3_3 = var7_7;
            }
            if (var3_3 >= var4_4) return ParseResult.SUCCESS;
            if (var2_2.charAt(var3_3) != '#') return ParseResult.SUCCESS;
            this.encodedFragment = HttpUrl.canonicalize(var2_2, var3_3 + 1, var4_4, "", true, false, false);
            return ParseResult.SUCCESS;
        }

        public Builder password(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("password == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, true);
            return this;
        }

        public Builder port(int n2) {
            if (n2 <= 0 || n2 > 65535) {
                throw new IllegalArgumentException("unexpected port: " + n2);
            }
            this.port = n2;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder query(String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(list, HttpUrl.QUERY_ENCODE_SET, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        Builder reencodeForUri() {
            String string2;
            int n2;
            int n3 = this.encodedPathSegments.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = this.encodedPathSegments.get(n2);
                this.encodedPathSegments.set(n2, HttpUrl.canonicalize(string2, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, false, true));
            }
            if (this.encodedQueryNamesAndValues != null) {
                n3 = this.encodedQueryNamesAndValues.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    string2 = this.encodedQueryNamesAndValues.get(n2);
                    if (string2 == null) continue;
                    this.encodedQueryNamesAndValues.set(n2, HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true));
                }
            }
            if (this.encodedFragment != null) {
                this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, false, false);
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder removeAllEncodedQueryParameters(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, true, true));
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder removeAllQueryParameters(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, true, true));
            return this;
        }

        public Builder removePathSegment(int n2) {
            this.encodedPathSegments.remove(n2);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder scheme(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("scheme == null");
            }
            if (string2.equalsIgnoreCase("http")) {
                this.scheme = "http";
                return this;
            }
            if (!string2.equalsIgnoreCase("https")) throw new IllegalArgumentException("unexpected scheme: " + string2);
            this.scheme = "https";
            return this;
        }

        public Builder setEncodedPathSegment(int n2, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("encodedPathSegment == null");
            }
            String string3 = HttpUrl.canonicalize(string2, 0, string2.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, true);
            this.encodedPathSegments.set(n2, string3);
            if (this.isDot(string3) || this.isDotDot(string3)) {
                throw new IllegalArgumentException("unexpected path segment: " + string2);
            }
            return this;
        }

        public Builder setEncodedQueryParameter(String string2, String string3) {
            this.removeAllEncodedQueryParameters(string2);
            this.addEncodedQueryParameter(string2, string3);
            return this;
        }

        public Builder setPathSegment(int n2, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("pathSegment == null");
            }
            String string3 = HttpUrl.canonicalize(string2, 0, string2.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, true);
            if (this.isDot(string3) || this.isDotDot(string3)) {
                throw new IllegalArgumentException("unexpected path segment: " + string2);
            }
            this.encodedPathSegments.set(n2, string3);
            return this;
        }

        public Builder setQueryParameter(String string2, String string3) {
            this.removeAllQueryParameters(string2);
            this.addQueryParameter(string2, string3);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme);
            stringBuilder.append("://");
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                stringBuilder.append('[');
                stringBuilder.append(this.host);
                stringBuilder.append(']');
            } else {
                stringBuilder.append(this.host);
            }
            if ((n2 = this.effectivePort()) != HttpUrl.defaultPort(this.scheme)) {
                stringBuilder.append(':');
                stringBuilder.append(n2);
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        public Builder username(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("username == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, true);
            return this;
        }

        static enum ParseResult {
            SUCCESS,
            MISSING_SCHEME,
            UNSUPPORTED_SCHEME,
            INVALID_PORT,
            INVALID_HOST;

        }
    }
}

