/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final Pattern PARAMETER;
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final Pattern TYPE_SUBTYPE;
    private final String charset;
    private final String mediaType;
    private final String subtype;
    private final String type;

    static {
        TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
        PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    }

    private MediaType(String string2, String string3, String string4, String string5) {
        this.mediaType = string2;
        this.type = string3;
        this.subtype = string4;
        this.charset = string5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MediaType parse(String string2) {
        Object var1_1 = null;
        Object object = TYPE_SUBTYPE.matcher(string2);
        if (!((Matcher)object).lookingAt()) {
            return var1_1;
        }
        String string3 = ((Matcher)object).group(1).toLowerCase(Locale.US);
        String string4 = ((Matcher)object).group(2).toLowerCase(Locale.US);
        Matcher matcher = PARAMETER.matcher(string2);
        int n2 = ((Matcher)object).end();
        Object object2 = null;
        while (n2 < string2.length()) {
            matcher.region(n2, string2.length());
            object = var1_1;
            if (!matcher.lookingAt()) return object;
            String string5 = matcher.group(1);
            object = object2;
            if (string5 != null) {
                if (!string5.equalsIgnoreCase("charset")) {
                    object = object2;
                } else {
                    object = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
                    if (object2 != null && !((String)object).equalsIgnoreCase((String)object2)) {
                        throw new IllegalArgumentException("Multiple different charsets: " + string2);
                    }
                }
            }
            n2 = matcher.end();
            object2 = object;
        }
        return new MediaType(string2, string3, string4, (String)object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Charset charset() {
        if (this.charset == null) return null;
        return Charset.forName(this.charset);
    }

    public Charset charset(Charset charset) {
        if (this.charset != null) {
            charset = Charset.forName(this.charset);
        }
        return charset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof MediaType)) return false;
        if (!((MediaType)object).mediaType.equals(this.mediaType)) return false;
        return true;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String subtype() {
        return this.subtype;
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }
}

