/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.http.HttpMethod;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;

public final class Request {
    private final RequestBody body;
    private volatile CacheControl cacheControl;
    private final Headers headers;
    private volatile URI javaNetUri;
    private volatile URL javaNetUrl;
    private final String method;
    private final Object tag;
    private final HttpUrl url;

    /*
     * Enabled aggressive block sorting
     */
    private Request(Builder object) {
        this.url = ((Builder)object).url;
        this.method = ((Builder)object).method;
        this.headers = ((Builder)object).headers.build();
        this.body = ((Builder)object).body;
        object = ((Builder)object).tag != null ? ((Builder)object).tag : this;
        this.tag = object;
    }

    public RequestBody body() {
        return this.body;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = cacheControl = CacheControl.parse(this.headers);
        return cacheControl;
    }

    public String header(String string2) {
        return this.headers.get(string2);
    }

    public Headers headers() {
        return this.headers;
    }

    public List<String> headers(String string2) {
        return this.headers.values(string2);
    }

    public HttpUrl httpUrl() {
        return this.url;
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String method() {
        return this.method;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Object tag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append("Request{method=").append(this.method).append(", url=").append(this.url).append(", tag=");
        if (this.tag != this) {
            object = this.tag;
            return stringBuilder.append(object).append('}').toString();
        }
        object = null;
        return stringBuilder.append(object).append('}').toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URI uri() throws IOException {
        URI uRI;
        block4: {
            try {
                uRI = this.javaNetUri;
                if (uRI == null) break block4;
            }
            catch (IllegalStateException illegalStateException) {
                throw new IOException(illegalStateException.getMessage());
            }
            return uRI;
        }
        this.javaNetUri = uRI = this.url.uri();
        return uRI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL url() {
        URL uRL = this.javaNetUrl;
        if (uRL != null) {
            return uRL;
        }
        this.javaNetUrl = uRL = this.url.url();
        return uRL;
    }

    public String urlString() {
        return this.url.toString();
    }

    public static class Builder {
        private RequestBody body;
        private Headers.Builder headers;
        private String method;
        private Object tag;
        private HttpUrl url;

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        private Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tag = request.tag;
            this.headers = request.headers.newBuilder();
        }

        public Builder addHeader(String string2, String string3) {
            this.headers.add(string2, string3);
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder cacheControl(CacheControl object) {
            if (!((String)(object = ((CacheControl)object).toString())).isEmpty()) return this.header("Cache-Control", (String)object);
            return this.removeHeader("Cache-Control");
        }

        public Builder delete() {
            return this.delete(RequestBody.create(null, new byte[0]));
        }

        public Builder delete(RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder header(String string2, String string3) {
            this.headers.set(string2, string3);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder method(String string2, RequestBody requestBody) {
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("method == null || method.length() == 0");
            }
            if (requestBody != null && !HttpMethod.permitsRequestBody(string2)) {
                throw new IllegalArgumentException("method " + string2 + " must not have a request body.");
            }
            if (requestBody == null && HttpMethod.requiresRequestBody(string2)) {
                throw new IllegalArgumentException("method " + string2 + " must have a request body.");
            }
            this.method = string2;
            this.body = requestBody;
            return this;
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder removeHeader(String string2) {
            this.headers.removeAll(string2);
            return this;
        }

        public Builder tag(Object object) {
            this.tag = object;
            return this;
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl == null) {
                throw new IllegalArgumentException("url == null");
            }
            this.url = httpUrl;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder url(String object) {
            Object object2;
            if (object == null) {
                throw new IllegalArgumentException("url == null");
            }
            if (((String)object).regionMatches(true, 0, "ws:", 0, 3)) {
                object2 = "http:" + ((String)object).substring(3);
            } else {
                object2 = object;
                if (((String)object).regionMatches(true, 0, "wss:", 0, 4)) {
                    object2 = "https:" + ((String)object).substring(4);
                }
            }
            if ((object = HttpUrl.parse((String)object2)) == null) {
                throw new IllegalArgumentException("unexpected url: " + (String)object2);
            }
            return this.url((HttpUrl)object);
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new IllegalArgumentException("url == null");
            }
            HttpUrl httpUrl = HttpUrl.get(uRL);
            if (httpUrl == null) {
                throw new IllegalArgumentException("unexpected url: " + uRL);
            }
            return this.url(httpUrl);
        }
    }
}

