/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import s.c;
import s.e;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Charset charset() {
        MediaType mediaType = this.contentType();
        if (mediaType == null) return Util.UTF_8;
        return mediaType.charset(Util.UTF_8);
    }

    public static ResponseBody create(final MediaType mediaType, final long l2, final e e2) {
        if (e2 == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public long contentLength() {
                return l2;
            }

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public e source() {
                return e2;
            }
        };
    }

    public static ResponseBody create(MediaType mediaType, String string2) {
        Charset charset = Util.UTF_8;
        MediaType mediaType2 = mediaType;
        if (mediaType != null) {
            Charset charset2;
            charset = charset2 = mediaType.charset();
            mediaType2 = mediaType;
            if (charset2 == null) {
                charset = Util.UTF_8;
                mediaType2 = MediaType.parse(mediaType + "; charset=utf-8");
            }
        }
        mediaType = new c().a(string2, charset);
        return ResponseBody.create(mediaType2, mediaType.a(), (e)mediaType);
    }

    public static ResponseBody create(MediaType mediaType, byte[] byArray) {
        c c2 = new c().b(byArray);
        return ResponseBody.create(mediaType, byArray.length, (e)c2);
    }

    public final InputStream byteStream() throws IOException {
        return this.source().f();
    }

    public final byte[] bytes() throws IOException {
        byte[] byArray;
        block5: {
            long l2 = this.contentLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException("Cannot buffer entire body for content length: " + l2);
            }
            e e2 = this.source();
            byArray = e2.r();
            if (l2 != -1L && l2 != (long)byArray.length) {
                throw new IOException("Content-Length and stream length disagree");
            }
            break block5;
            finally {
                Util.closeQuietly((Closeable)e2);
            }
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Reader charStream() throws IOException {
        Reader reader = this.reader;
        if (reader != null) {
            return reader;
        }
        this.reader = reader = new InputStreamReader(this.byteStream(), this.charset());
        return reader;
    }

    @Override
    public void close() throws IOException {
        this.source().close();
    }

    public abstract long contentLength() throws IOException;

    public abstract MediaType contentType();

    public abstract e source() throws IOException;

    public final String string() throws IOException {
        return new String(this.bytes(), this.charset().name());
    }
}

