/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.internal.FaultHidingSink;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.io.FileSystem;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import s.c;
import s.d;
import s.e;
import s.m;
import s.s;
import s.t;
import s.u;

public final class DiskLruCache
implements Closeable {
    static final /* synthetic */ boolean $assertionsDisabled;
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final Pattern LEGAL_KEY_PATTERN;
    static final String MAGIC = "libcore.io.DiskLruCache";
    private static final s NULL_SINK;
    private static final String READ = "READ";
    private static final String REMOVE = "REMOVE";
    static final String VERSION_1 = "1";
    private final int appVersion;
    private final Runnable cleanupRunnable;
    private boolean closed;
    private final File directory;
    private final Executor executor;
    private final FileSystem fileSystem;
    private boolean hasJournalErrors;
    private boolean initialized;
    private final File journalFile;
    private final File journalFileBackup;
    private final File journalFileTmp;
    private d journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private long maxSize;
    private long nextSequenceNumber = 0L;
    private int redundantOpCount;
    private long size = 0L;
    private final int valueCount;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !DiskLruCache.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
        NULL_SINK = new s(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public u timeout() {
                return u.NONE;
            }

            public void write(c c2, long l2) throws IOException {
                c2.g(l2);
            }
        };
    }

    DiskLruCache(FileSystem fileSystem, File file, int n2, int n3, long l2, Executor executor) {
        this.cleanupRunnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl = false;
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (!DiskLruCache.this.initialized) {
                        bl = true;
                    }
                    if (bl | DiskLruCache.this.closed) {
                        return;
                    }
                    try {
                        DiskLruCache.this.trimToSize();
                        if (!DiskLruCache.this.journalRebuildRequired()) return;
                        DiskLruCache.this.rebuildJournal();
                        DiskLruCache.access$502(DiskLruCache.this, 0);
                        return;
                    }
                    catch (IOException iOException) {
                        RuntimeException runtimeException = new RuntimeException(iOException);
                        throw runtimeException;
                    }
                }
            }
        };
        this.fileSystem = fileSystem;
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
        this.executor = executor;
    }

    static /* synthetic */ int access$502(DiskLruCache diskLruCache, int n2) {
        diskLruCache.redundantOpCount = n2;
        return n2;
    }

    static /* synthetic */ boolean access$602(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.hasJournalErrors = bl;
        return bl;
    }

    private void checkNotClosed() {
        synchronized (this) {
            if (this.isClosed()) {
                IllegalStateException illegalStateException = new IllegalStateException("cache is closed");
                throw illegalStateException;
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEdit(Editor var1_1, boolean var2_2) throws IOException {
        var3_3 = 0;
        synchronized (this) {
            block19: {
                var4_4 = Editor.access$1700((Editor)var1_1);
                if (Entry.access$900((Entry)var4_4) != var1_1) {
                    var1_1 = new IllegalStateException();
                    throw var1_1;
                }
                var5_5 = var3_3;
                if (var2_2) {
                    var5_5 = var3_3;
                    if (!Entry.access$800((Entry)var4_4)) {
                        var6_6 = 0;
                        while (true) {
                            var5_5 = var3_3;
                            if (var6_6 >= this.valueCount) break block19;
                            if (!Editor.access$1800((Editor)var1_1)[var6_6]) {
                                var1_1.abort();
                                var1_1 = new StringBuilder();
                                var4_4 = new IllegalStateException(var1_1.append("Newly created entry didn't create value for index ").append(var6_6).toString());
                                throw var4_4;
                            }
                            if (!this.fileSystem.exists(Entry.access$1400((Entry)var4_4)[var6_6])) {
                                var1_1.abort();
                                break;
                            }
                            ++var6_6;
                        }
lbl25:
                        // 3 sources

                        return;
                    }
                }
            }
            while (var5_5 < this.valueCount) {
                var1_1 = Entry.access$1400((Entry)var4_4)[var5_5];
                if (var2_2) {
                    if (this.fileSystem.exists((File)var1_1)) {
                        var7_7 = Entry.access$1300((Entry)var4_4)[var5_5];
                        this.fileSystem.rename((File)var1_1, var7_7);
                        var8_8 = Entry.access$1200((Entry)var4_4)[var5_5];
                        Entry.access$1200((Entry)var4_4)[var5_5] = var10_9 = this.fileSystem.size(var7_7);
                        this.size = this.size - var8_8 + var10_9;
                    }
                } else {
                    this.fileSystem.delete((File)var1_1);
                }
                ++var5_5;
            }
            ++this.redundantOpCount;
            Entry.access$902((Entry)var4_4, null);
            if (Entry.access$800((Entry)var4_4) | var2_2) {
                Entry.access$802((Entry)var4_4, true);
                this.journalWriter.b("CLEAN").i(32);
                this.journalWriter.b(Entry.access$1500((Entry)var4_4));
                var4_4.writeLengths(this.journalWriter);
                this.journalWriter.i(10);
                if (var2_2) {
                    var10_9 = this.nextSequenceNumber;
                    this.nextSequenceNumber = 1L + var10_9;
                    Entry.access$1602((Entry)var4_4, var10_9);
                }
            } else {
                this.lruEntries.remove(Entry.access$1500((Entry)var4_4));
                this.journalWriter.b("REMOVE").i(32);
                this.journalWriter.b(Entry.access$1500((Entry)var4_4));
                this.journalWriter.i(10);
            }
            this.journalWriter.flush();
            if (this.size <= this.maxSize && !this.journalRebuildRequired()) ** GOTO lbl25
            this.executor.execute(this.cleanupRunnable);
            ** continue;
        }
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n2, int n3, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        return new DiskLruCache(fileSystem, file, n2, n3, l2, new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp DiskLruCache", true)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Editor edit(String object, long l2) throws IOException {
        synchronized (this) {
            void var2_2;
            this.initialize();
            this.checkNotClosed();
            this.validateKey((String)object);
            Object object2 = this.lruEntries.get(object);
            if (var2_2 != -1L) {
                if (object2 == null) return null;
                long l3 = ((Entry)object2).sequenceNumber;
                if (l3 != var2_2) {
                    return null;
                }
            }
            if (object2 != null && ((Entry)object2).currentEditor != null) {
                return null;
            }
            this.journalWriter.b(DIRTY).i(32).b((String)object).i(10);
            this.journalWriter.flush();
            if (this.hasJournalErrors) {
                return null;
            }
            if (object2 == null) {
                object2 = new Entry((String)object);
                this.lruEntries.put((String)object, (Entry)object2);
                object = object2;
            } else {
                object = object2;
            }
            object2 = new Editor(this, (Entry)object);
            Entry.access$902((Entry)object, (Editor)object2);
            return object2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean journalRebuildRequired() {
        if (this.redundantOpCount < 2000) return false;
        if (this.redundantOpCount < this.lruEntries.size()) return false;
        return true;
    }

    private d newJournalWriter() throws FileNotFoundException {
        return m.a((s)new FaultHidingSink(this.fileSystem.appendingSink(this.journalFile)){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * Enabled aggressive block sorting
             */
            static {
                boolean bl = !DiskLruCache.class.desiredAssertionStatus();
                $assertionsDisabled = bl;
            }

            @Override
            protected void onException(IOException iOException) {
                if (!$assertionsDisabled && !Thread.holdsLock(DiskLruCache.this)) {
                    throw new AssertionError();
                }
                DiskLruCache.access$602(DiskLruCache.this, true);
            }
        });
    }

    private void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                }
                continue;
            }
            Entry.access$902(entry, null);
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                this.fileSystem.delete(entry.cleanFiles[n2]);
                this.fileSystem.delete(entry.dirtyFiles[n2]);
            }
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readJournal() throws IOException {
        e e2;
        block9: {
            e2 = m.a((t)this.fileSystem.source(this.journalFile));
            String string2 = e2.q();
            String string3 = e2.q();
            Object object = e2.q();
            String string4 = e2.q();
            String string5 = e2.q();
            if (!(MAGIC.equals(string2) && VERSION_1.equals(string3) && Integer.toString(this.appVersion).equals(object) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                StringBuilder stringBuilder = new StringBuilder();
                object = new IOException(stringBuilder.append("unexpected journal header: [").append(string2).append(", ").append(string3).append(", ").append(string4).append(", ").append(string5).append("]").toString());
                throw object;
            }
            break block9;
            finally {
                Util.closeQuietly((Closeable)e2);
            }
        }
        int n2 = 0;
        while (true) {
            this.readJournalLine(e2.q());
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readJournalLine(String stringArray) throws IOException {
        Entry entry;
        String string2;
        int n2 = stringArray.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
        int n3 = n2 + 1;
        int n4 = stringArray.indexOf(32, n3);
        if (n4 == -1) {
            string2 = stringArray.substring(n3);
            if (n2 == REMOVE.length() && stringArray.startsWith(REMOVE)) {
                this.lruEntries.remove(string2);
                return;
            }
        } else {
            string2 = stringArray.substring(n3, n4);
        }
        Entry entry2 = entry = this.lruEntries.get(string2);
        if (entry == null) {
            entry2 = new Entry(string2);
            this.lruEntries.put(string2, entry2);
        }
        if (n4 != -1 && n2 == CLEAN.length() && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            Entry.access$802(entry2, true);
            Entry.access$902(entry2, null);
            entry2.setLengths(stringArray);
            return;
        }
        if (n4 == -1 && n2 == DIRTY.length() && stringArray.startsWith(DIRTY)) {
            Entry.access$902(entry2, new Editor(this, entry2));
            return;
        }
        if (n4 != -1 || n2 != READ.length() || !stringArray.startsWith(READ)) throw new IOException("unexpected journal line: " + (String)stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildJournal() throws IOException {
        synchronized (this) {
            if (this.journalWriter != null) {
                this.journalWriter.close();
            }
            d d2 = m.a((s)this.fileSystem.sink(this.journalFileTmp));
            try {
                d2.b(MAGIC).i(10);
                d2.b(VERSION_1).i(10);
                d2.k((long)this.appVersion).i(10);
                d2.k((long)this.valueCount).i(10);
                d2.i(10);
                for (Entry entry : this.lruEntries.values()) {
                    if (entry.currentEditor != null) {
                        d2.b(DIRTY).i(32);
                        d2.b(entry.key);
                        d2.i(10);
                        continue;
                    }
                    d2.b(CLEAN).i(32);
                    d2.b(entry.key);
                    entry.writeLengths(d2);
                    d2.i(10);
                }
            }
            finally {
                d2.close();
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.rename(this.journalFile, this.journalFileBackup);
            }
            this.fileSystem.rename(this.journalFileTmp, this.journalFile);
            this.fileSystem.delete(this.journalFileBackup);
            this.journalWriter = this.newJournalWriter();
            this.hasJournalErrors = false;
            return;
        }
    }

    private boolean removeEntry(Entry entry) throws IOException {
        if (entry.currentEditor != null) {
            Editor.access$1902(entry.currentEditor, true);
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            this.fileSystem.delete(entry.cleanFiles[i2]);
            this.size -= entry.lengths[i2];
            ((Entry)entry).lengths[i2] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.b(REMOVE).i(32).b(entry.key).i(10);
        this.lruEntries.remove(entry.key);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            this.removeEntry(this.lruEntries.values().iterator().next());
        }
    }

    private void validateKey(String string2) {
        if (!LEGAL_KEY_PATTERN.matcher(string2).matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,120}: \"" + string2 + "\"");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        synchronized (this) {
            if (!this.initialized || this.closed) {
                this.closed = true;
                return;
            }
            for (Entry entry : this.lruEntries.values().toArray(new Entry[this.lruEntries.size()])) {
                if (entry.currentEditor == null) continue;
                entry.currentEditor.abort();
            }
            try {
                this.trimToSize();
                this.journalWriter.close();
                this.journalWriter = null;
                this.closed = true;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    public void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    public void evictAll() throws IOException {
        synchronized (this) {
            this.initialize();
            Entry[] entryArray = this.lruEntries.values().toArray(new Entry[this.lruEntries.size()]);
            int n2 = entryArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.removeEntry(entryArray[i2]);
                continue;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush() throws IOException {
        synchronized (this) {
            block6: {
                boolean bl = this.initialized;
                if (bl) break block6;
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            this.journalWriter.flush();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Snapshot get(String object) throws IOException {
        synchronized (this) {
            Object object2;
            block8: {
                block7: {
                    this.initialize();
                    this.checkNotClosed();
                    this.validateKey((String)object);
                    object2 = this.lruEntries.get(object);
                    if (object2 == null) return null;
                    boolean bl = ((Entry)object2).readable;
                    if (bl) break block7;
                    return null;
                }
                object2 = ((Entry)object2).snapshot();
                if (object2 != null) break block8;
                return null;
            }
            ++this.redundantOpCount;
            this.journalWriter.b(READ).i(32).b((String)object).i(10);
            object = object2;
            if (!this.journalRebuildRequired()) return object;
            this.executor.execute(this.cleanupRunnable);
            return object2;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getMaxSize() {
        synchronized (this) {
            long l2 = this.maxSize;
            return l2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws IOException {
        synchronized (this) {
            block12: {
                if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                    AssertionError assertionError = new AssertionError();
                    throw assertionError;
                }
                boolean bl = this.initialized;
                if (!bl) {
                    if (this.fileSystem.exists(this.journalFileBackup)) {
                        if (this.fileSystem.exists(this.journalFile)) {
                            this.fileSystem.delete(this.journalFileBackup);
                        } else {
                            this.fileSystem.rename(this.journalFileBackup, this.journalFile);
                        }
                    }
                    if (bl = this.fileSystem.exists(this.journalFile)) {
                        try {
                            this.readJournal();
                            this.processJournal();
                            this.initialized = true;
                            break block12;
                        }
                        catch (IOException iOException) {
                            Platform platform = Platform.get();
                            StringBuilder stringBuilder = new StringBuilder();
                            platform.logW(stringBuilder.append("DiskLruCache ").append(this.directory).append(" is corrupt: ").append(iOException.getMessage()).append(", removing").toString());
                            this.delete();
                            this.closed = false;
                        }
                    }
                    this.rebuildJournal();
                    this.initialized = true;
                }
            }
            return;
        }
    }

    public boolean isClosed() {
        synchronized (this) {
            boolean bl = this.closed;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(String object) throws IOException {
        synchronized (this) {
            block6: {
                this.initialize();
                this.checkNotClosed();
                this.validateKey((String)object);
                object = this.lruEntries.get(object);
                if (object != null) break block6;
                return false;
            }
            boolean bl = this.removeEntry((Entry)object);
            return bl;
        }
    }

    public void setMaxSize(long l2) {
        synchronized (this) {
            this.maxSize = l2;
            if (this.initialized) {
                this.executor.execute(this.cleanupRunnable);
            }
            return;
        }
    }

    public long size() throws IOException {
        synchronized (this) {
            this.initialize();
            long l2 = this.size;
            return l2;
        }
    }

    public Iterator<Snapshot> snapshots() throws IOException {
        synchronized (this) {
            this.initialize();
            Iterator<Snapshot> iterator = new Iterator<Snapshot>(){
                final Iterator<Entry> delegate;
                Snapshot nextSnapshot;
                Snapshot removeSnapshot;
                {
                    this.delegate = new ArrayList(DiskLruCache.this.lruEntries.values()).iterator();
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean hasNext() {
                    if (this.nextSnapshot != null) {
                        return true;
                    }
                    DiskLruCache diskLruCache = DiskLruCache.this;
                    synchronized (diskLruCache) {
                        Snapshot snapshot;
                        if (DiskLruCache.this.closed) {
                            return false;
                        }
                        do {
                            if (this.delegate.hasNext()) continue;
                            return false;
                        } while ((snapshot = this.delegate.next().snapshot()) == null);
                        this.nextSnapshot = snapshot;
                        return true;
                    }
                }

                @Override
                public Snapshot next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.removeSnapshot = this.nextSnapshot;
                    this.nextSnapshot = null;
                    return this.removeSnapshot;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void remove() {
                    if (this.removeSnapshot == null) {
                        throw new IllegalStateException("remove() before next()");
                    }
                    try {
                        DiskLruCache.this.remove(this.removeSnapshot.key);
                    }
                    catch (IOException iOException) {}
                    return;
                    finally {
                        this.removeSnapshot = null;
                        return;
                    }
                }
            };
            return iterator;
        }
    }

    public static final class Editor {
        private boolean committed;
        private final Entry entry;
        private boolean hasErrors;
        final /* synthetic */ DiskLruCache this$0;
        private final boolean[] written;

        /*
         * Enabled aggressive block sorting
         */
        private Editor(DiskLruCache object, Entry entry) {
            this.this$0 = object;
            this.entry = entry;
            object = entry.readable ? null : (Object)new boolean[((DiskLruCache)object).valueCount];
            this.written = (boolean[])object;
        }

        static /* synthetic */ Entry access$1700(Editor editor) {
            return editor.entry;
        }

        static /* synthetic */ boolean[] access$1800(Editor editor) {
            return editor.written;
        }

        static /* synthetic */ boolean access$1902(Editor editor, boolean bl) {
            editor.hasErrors = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                this.this$0.completeEdit(this, false);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abortUnlessCommitted() {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                boolean bl = this.committed;
                if (!bl) {
                    try {
                        this.this$0.completeEdit(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.hasErrors) {
                    this.this$0.completeEdit(this, false);
                    this.this$0.removeEntry(this.entry);
                } else {
                    this.this$0.completeEdit(this, true);
                }
                this.committed = true;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public s newSink(int n2) throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                Object object = this.entry.dirtyFiles[n2];
                try {
                    s s2 = this.this$0.fileSystem.sink((File)object);
                    return new FaultHidingSink(s2){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        protected void onException(IOException iOException) {
                            DiskLruCache diskLruCache = Editor.this.this$0;
                            synchronized (diskLruCache) {
                                Editor.access$1902(Editor.this, true);
                                return;
                            }
                        }
                    };
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return NULL_SINK;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public t newSource(int n2) throws IOException {
            IllegalStateException illegalStateException = null;
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) {
                    return illegalStateException;
                }
                try {
                    t t2 = this.this$0.fileSystem.source(this.entry.cleanFiles[n2]);
                    return t2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return illegalStateException;
                }
            }
        }
    }

    private final class Entry {
        private final File[] cleanFiles;
        private Editor currentEditor;
        private final File[] dirtyFiles;
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private long sequenceNumber;

        private Entry(String charSequence) {
            this.key = charSequence;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            charSequence = new StringBuilder((String)charSequence).append('.');
            int n2 = ((StringBuilder)charSequence).length();
            for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                ((StringBuilder)charSequence).append(i2);
                this.cleanFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(".tmp");
                this.dirtyFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n2);
            }
        }

        static /* synthetic */ long access$1602(Entry entry, long l2) {
            entry.sequenceNumber = l2;
            return l2;
        }

        static /* synthetic */ boolean access$802(Entry entry, boolean bl) {
            entry.readable = bl;
            return bl;
        }

        static /* synthetic */ Editor access$902(Entry entry, Editor editor) {
            entry.currentEditor = editor;
            return editor;
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        private void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n2 = 0;
            while (true) {
                try {
                    if (n2 >= stringArray.length) break;
                    this.lengths[n2] = Long.parseLong(stringArray[n2]);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.invalidLengths(stringArray);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Snapshot snapshot() {
            void var3_5;
            int n2;
            t[] tArray;
            block6: {
                int n3 = 0;
                if (!Thread.holdsLock(DiskLruCache.this)) {
                    throw new AssertionError();
                }
                tArray = new t[DiskLruCache.this.valueCount];
                long[] lArray = (long[])this.lengths.clone();
                try {
                    for (n2 = 0; n2 < DiskLruCache.this.valueCount; ++n2) {
                        tArray[n2] = DiskLruCache.this.fileSystem.source(this.cleanFiles[n2]);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break block6;
                }
                {
                    Snapshot snapshot = new Snapshot(this.key, this.sequenceNumber, tArray, lArray);
                }
                return var3_5;
            }
            for (n2 = n3; n2 < DiskLruCache.this.valueCount && tArray[n2] != null; ++n2) {
                Util.closeQuietly((Closeable)tArray[n2]);
            }
            Object var3_7 = null;
            return var3_5;
        }

        void writeLengths(d d2) throws IOException {
            for (long l2 : this.lengths) {
                d2.i(32).k(l2);
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long[] lengths;
        private final long sequenceNumber;
        private final t[] sources;

        private Snapshot(String string2, long l2, t[] tArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l2;
            this.sources = tArray;
            this.lengths = lArray;
        }

        @Override
        public void close() {
            t[] tArray = this.sources;
            int n2 = tArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Util.closeQuietly((Closeable)tArray[i2]);
            }
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }

        public t getSource(int n2) {
            return this.sources[n2];
        }

        public String key() {
            return this.key;
        }
    }
}

