/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import android.util.Log;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.OptionalMethod;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import s.c;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    /*
     * Enabled aggressive block sorting
     */
    static byte[] concatLengthPrefixed(List<Protocol> list) {
        c c2 = new c();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Protocol protocol = list.get(n3);
            if (protocol != Protocol.HTTP_1_0) {
                c2.b(protocol.toString().length());
                c2.a(protocol.toString());
            }
            ++n3;
        }
        return c2.r();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Platform findPlatform() {
        Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
        {
            catch (ClassNotFoundException var3) {
                Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            var0_7 = new OptionalMethod<Socket>(null, "setUseSessionTickets", new Class[]{Boolean.TYPE});
            var1_8 = new OptionalMethod(null, "setHostname", new Class[]{String.class});
        }
lbl11:
        // 2 sources

        catch (ClassNotFoundException var3_2) {
            try {
                var3_1 = Class.forName("org.eclipse.jetty.alpn.ALPN");
                var2_9 = new StringBuilder();
                var6_16 = Class.forName(var2_9.append("org.eclipse.jetty.alpn.ALPN").append("$Provider").toString());
                var2_9 = new StringBuilder();
                var2_9 = Class.forName(var2_9.append("org.eclipse.jetty.alpn.ALPN").append("$ClientProvider").toString());
                var4_12 = new OptionalMethod<T>();
                var4_12 = Class.forName(var4_12.append("org.eclipse.jetty.alpn.ALPN").append("$ServerProvider").toString());
                var6_16 = var3_1.getMethod("put", new Class[]{SSLSocket.class, var6_16});
                var5_15 = var3_1.getMethod("get", new Class[]{SSLSocket.class});
                var1_8 = var3_1.getMethod("remove", new Class[]{SSLSocket.class});
                return new JdkWithJettyBootPlatform((Method)var6_16, (Method)var5_15, (Method)var1_8, (Class<?>)var2_9, (Class<?>)var4_12);
            }
            catch (ClassNotFoundException var3_3) {}
            return new Platform();
            catch (NoSuchMethodException var3_5) {}
            return new Platform();
        }
        {
            block22: {
                block20: {
                    var2_9 = Class.forName("android.net.TrafficStats");
                    var3_1 = var2_9.getMethod("tagSocket", new Class[]{Socket.class});
                    var2_9 = var2_9.getMethod("untagSocket", new Class[]{Socket.class});
                    Class.forName("android.net.Network");
                    var4_12 = new OptionalMethod<T>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                    var5_15 = new OptionalMethod<T>(null, "setAlpnProtocols", new Class[]{byte[].class});
                    var6_16 = var4_12;
                    var4_12 = var5_15;
                    break block20;
                    catch (ClassNotFoundException var4_13) {
                        block23: {
                            var4_12 = null;
                            break block23;
                            catch (ClassNotFoundException var3_4) {
                                block21: {
                                    block24: {
                                        var3_1 = null;
                                        break block24;
                                        catch (ClassNotFoundException var2_10) {}
                                    }
                                    var2_9 = null;
                                    var6_16 = null;
                                    var4_12 = var3_1;
                                    var3_1 = var6_16;
                                    break block21;
                                    catch (NoSuchMethodException var3_6) {
                                        var3_1 = null;
                                        var2_9 = null;
                                        var4_12 = null;
                                        break block21;
                                    }
                                    catch (NoSuchMethodException var2_11) {
                                        var6_16 = null;
                                        var2_9 = null;
                                        var4_12 = var3_1;
                                        var3_1 = var6_16;
                                        break block21;
                                    }
                                    catch (NoSuchMethodException var4_14) {
                                        var6_16 = null;
                                        var4_12 = var3_1;
                                        var3_1 = var6_16;
                                        break block21;
                                    }
                                    catch (NoSuchMethodException var6_18) {
                                        var6_16 = var4_12;
                                        var4_12 = var3_1;
                                        var3_1 = var6_16;
                                    }
                                }
                                var6_16 = null;
                                var5_15 = var3_1;
                                var3_1 = var6_16;
                                break block22;
                            }
                            catch (ClassNotFoundException var6_17) {}
                        }
                        var6_16 = var4_12;
                        var4_12 = null;
                    }
                }
                var5_15 = var6_16;
                var6_16 = var3_1;
                var3_1 = var4_12;
                var4_12 = var6_16;
            }
            ** try [egrp 6[TRYBLOCK] [10 : 153->186)] { 
lbl91:
            // 1 sources

            var6_16 = new OptionalMethod<T>(var0_7, var1_8, var4_12, (Method)var2_9, var5_15, (OptionalMethod<Socket>)var3_1);
            return var6_16;
        }
    }

    public static Platform get() {
        return PLATFORM;
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string2, List<Protocol> list) {
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        socket.connect(inetSocketAddress, n2);
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void log(String string2) {
        System.out.println(string2);
    }

    public void logW(String string2) {
        System.out.println(string2);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    private static class Android
    extends Platform {
        private static final int MAX_LOG_LENGTH = 4000;
        private final OptionalMethod<Socket> getAlpnSelectedProtocol;
        private final OptionalMethod<Socket> setAlpnProtocols;
        private final OptionalMethod<Socket> setHostname;
        private final OptionalMethod<Socket> setUseSessionTickets;
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;

        public Android(OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, Method method, Method method2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
            this.setUseSessionTickets = optionalMethod;
            this.setHostname = optionalMethod2;
            this.trafficStatsTagSocket = method;
            this.trafficStatsUntagSocket = method2;
            this.getAlpnSelectedProtocol = optionalMethod3;
            this.setAlpnProtocols = optionalMethod4;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) {
            if (object != null) {
                this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, true);
                this.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, object);
            }
            if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sSLSocket)) {
                object = Android.concatLengthPrefixed(list);
                this.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, object);
            }
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress serializable, int n2) throws IOException {
            try {
                socket.connect((SocketAddress)serializable, n2);
                return;
            }
            catch (AssertionError assertionError) {
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            catch (SecurityException securityException) {
                serializable = new IOException("Exception in connect");
                ((Throwable)serializable).initCause(securityException);
                throw serializable;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getSelectedProtocol(SSLSocket object) {
            Object object2 = null;
            if (this.getAlpnSelectedProtocol == null) {
                return object2;
            }
            if (!this.getAlpnSelectedProtocol.isSupported((Socket)object)) return object2;
            if ((object = (Object)((byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException((Socket)object, new Object[0]))) == null) return null;
            object = new String((byte[])object, Util.UTF_8);
            return object;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void log(String string2) {
            int n2 = 0;
            int n3 = string2.length();
            block0: while (n2 < n3) {
                int n4 = string2.indexOf(10, n2);
                if (n4 == -1) {
                    n4 = n3;
                }
                while (true) {
                    int n5 = Math.min(n4, n2 + 4000);
                    Log.d((String)"OkHttp", (String)string2.substring(n2, n5));
                    if (n5 >= n4) {
                        n2 = n5 + 1;
                        continue block0;
                    }
                    n2 = n5;
                }
                break;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
    }

    private static class JdkWithJettyBootPlatform
    extends Platform {
        private final Class<?> clientProviderClass;
        private final Method getMethod;
        private final Method putMethod;
        private final Method removeMethod;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
            this.putMethod = method;
            this.getMethod = method2;
            this.removeMethod = method3;
            this.clientProviderClass = clazz;
            this.serverProviderClass = clazz2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void afterHandshake(SSLSocket sSLSocket) {
            try {
                this.removeMethod.invoke(null, sSLSocket);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> clazz) {
            void var1_3;
            object = new ArrayList<String>(clazz.size());
            int n2 = clazz.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Protocol protocol = (Protocol)((Object)clazz.get(i2));
                if (protocol == Protocol.HTTP_1_0) continue;
                object.add(protocol.toString());
            }
            try {
                ClassLoader classLoader = Platform.class.getClassLoader();
                clazz = this.clientProviderClass;
                Class<?> clazz2 = this.serverProviderClass;
                JettyNegoProvider jettyNegoProvider = new JettyNegoProvider((List<String>)object);
                object = Proxy.newProxyInstance(classLoader, new Class[]{clazz, clazz2}, (InvocationHandler)jettyNegoProvider);
                this.putMethod.invoke(null, sSLSocket, object);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError(var1_3);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError(var1_3);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getSelectedProtocol(SSLSocket object) {
            block7: {
                block6: {
                    Object var2_4 = null;
                    object = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, object));
                    if (((JettyNegoProvider)object).unsupported || ((JettyNegoProvider)object).selected != null) break block6;
                    Internal.logger.log(Level.INFO, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return var2_4;
                }
                if (!((JettyNegoProvider)object).unsupported) break block7;
                return null;
            }
            try {
                return ((JettyNegoProvider)object).selected;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError();
            }
        }
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private String selected;
        private boolean unsupported;

        public JettyNegoProvider(List<String> list) {
            this.protocols = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string2 = method.getName();
            Class<?> clazz = method.getReturnType();
            object = objectArray;
            if (objectArray == null) {
                object = Util.EMPTY_STRING_ARRAY;
            }
            if (string2.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string2.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string2.equals("protocols") && ((Object)object).length == 0) {
                return this.protocols;
            }
            if ((string2.equals("selectProtocol") || string2.equals("select")) && String.class == clazz && ((Object)object).length == 1 && object[0] instanceof List) {
                object = (List)object[0];
                int n2 = object.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.protocols.contains(object.get(i2))) continue;
                    this.selected = object = (String)object.get(i2);
                    return object;
                }
                this.selected = object = this.protocols.get(0);
                return object;
            }
            if (!string2.equals("protocolSelected")) {
                if (!string2.equals("selected")) return method.invoke((Object)this, (Object[])object);
            }
            if (((Object)object).length != 1) return method.invoke((Object)this, (Object[])object);
            this.selected = (String)object[0];
            return null;
        }
    }
}

