/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.Version;
import com.squareup.okhttp.internal.http.CacheRequest;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestException;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.StreamAllocation;
import java.io.Closeable;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import s.c;
import s.d;
import s.e;
import s.k;
import s.m;
import s.s;
import s.t;
import s.u;

public final class HttpEngine {
    private static final ResponseBody EMPTY_BODY = new ResponseBody(){

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public MediaType contentType() {
            return null;
        }

        @Override
        public e source() {
            return new c();
        }
    };
    public static final int MAX_FOLLOW_UPS = 20;
    public final boolean bufferRequestBody;
    private d bufferedRequestBody;
    private Response cacheResponse;
    private CacheStrategy cacheStrategy;
    private final boolean callerWritesRequestBody;
    final OkHttpClient client;
    private final boolean forWebSocket;
    private HttpStream httpStream;
    private Request networkRequest;
    private final Response priorResponse;
    private s requestBodyOut;
    long sentRequestMillis = -1L;
    private CacheRequest storeRequest;
    public final StreamAllocation streamAllocation;
    private boolean transparentGzip;
    private final Request userRequest;
    private Response userResponse;

    /*
     * Enabled aggressive block sorting
     */
    public HttpEngine(OkHttpClient okHttpClient, Request request, boolean bl, boolean bl2, boolean bl3, StreamAllocation streamAllocation, RetryableSink retryableSink, Response response) {
        this.client = okHttpClient;
        this.userRequest = request;
        this.bufferRequestBody = bl;
        this.callerWritesRequestBody = bl2;
        this.forWebSocket = bl3;
        if (streamAllocation == null) {
            streamAllocation = new StreamAllocation(okHttpClient.getConnectionPool(), HttpEngine.createAddress(okHttpClient, request));
        }
        this.streamAllocation = streamAllocation;
        this.requestBodyOut = retryableSink;
        this.priorResponse = response;
    }

    static /* synthetic */ Request access$102(HttpEngine httpEngine, Request request) {
        httpEngine.networkRequest = request;
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response cacheWritingResponse(CacheRequest object, Response response) throws IOException {
        if (object == null) {
            return response;
        }
        s s2 = object.body();
        Response response2 = response;
        if (s2 == null) return response2;
        object = new t(response.body().source(), (CacheRequest)object, m.a((s)s2)){
            boolean cacheRequestClosed;
            final /* synthetic */ d val$cacheBody;
            final /* synthetic */ CacheRequest val$cacheRequest;
            final /* synthetic */ e val$source;
            {
                this.val$source = e2;
                this.val$cacheRequest = cacheRequest;
                this.val$cacheBody = d2;
            }

            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.val$cacheRequest.abort();
                }
                this.val$source.close();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public long read(c c2, long l2) throws IOException {
                block3: {
                    try {
                        l2 = this.val$source.read(c2, l2);
                        if (l2 != -1L) break block3;
                        if (this.cacheRequestClosed) return -1L;
                        this.cacheRequestClosed = true;
                    }
                    catch (IOException iOException) {
                        if (this.cacheRequestClosed) throw iOException;
                        this.cacheRequestClosed = true;
                        this.val$cacheRequest.abort();
                        throw iOException;
                    }
                    this.val$cacheBody.close();
                    return -1L;
                }
                c2.a(this.val$cacheBody.b(), c2.a() - l2, l2);
                this.val$cacheBody.v();
                return l2;
            }

            public u timeout() {
                return this.val$source.timeout();
            }
        };
        return response.newBuilder().body(new RealResponseBody(response.headers(), m.a((t)object))).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Headers combine(Headers object, Headers headers) throws IOException {
        int n2;
        int n3 = 0;
        Headers.Builder builder = new Headers.Builder();
        int n4 = ((Headers)object).size();
        for (n2 = 0; n2 < n4; ++n2) {
            String string2 = ((Headers)object).name(n2);
            String string3 = ((Headers)object).value(n2);
            if ("Warning".equalsIgnoreCase(string2) && string3.startsWith("1") || OkHeaders.isEndToEnd(string2) && headers.get(string2) != null) continue;
            builder.add(string2, string3);
        }
        n4 = headers.size();
        n2 = n3;
        while (n2 < n4) {
            object = headers.name(n2);
            if (!"Content-Length".equalsIgnoreCase((String)object) && OkHeaders.isEndToEnd((String)object)) {
                builder.add((String)object, headers.value(n2));
            }
            ++n2;
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpStream connect() throws RouteException, RequestException, IOException {
        boolean bl;
        if (!this.networkRequest.method().equals("GET")) {
            bl = true;
            return this.streamAllocation.newStream(this.client.getConnectTimeout(), this.client.getReadTimeout(), this.client.getWriteTimeout(), this.client.getRetryOnConnectionFailure(), bl);
        }
        bl = false;
        return this.streamAllocation.newStream(this.client.getConnectTimeout(), this.client.getReadTimeout(), this.client.getWriteTimeout(), this.client.getRetryOnConnectionFailure(), bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Address createAddress(OkHttpClient okHttpClient, Request request) {
        HostnameVerifier hostnameVerifier;
        SSLSocketFactory sSLSocketFactory;
        CertificatePinner certificatePinner = null;
        if (request.isHttps()) {
            sSLSocketFactory = okHttpClient.getSslSocketFactory();
            hostnameVerifier = okHttpClient.getHostnameVerifier();
            certificatePinner = okHttpClient.getCertificatePinner();
            return new Address(request.httpUrl().host(), request.httpUrl().port(), okHttpClient.getDns(), okHttpClient.getSocketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, okHttpClient.getAuthenticator(), okHttpClient.getProxy(), okHttpClient.getProtocols(), okHttpClient.getConnectionSpecs(), okHttpClient.getProxySelector());
        }
        hostnameVerifier = null;
        sSLSocketFactory = null;
        return new Address(request.httpUrl().host(), request.httpUrl().port(), okHttpClient.getDns(), okHttpClient.getSocketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, okHttpClient.getAuthenticator(), okHttpClient.getProxy(), okHttpClient.getProtocols(), okHttpClient.getConnectionSpecs(), okHttpClient.getProxySelector());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasBody(Response response) {
        boolean bl = false;
        if (response.request().method().equals("HEAD")) {
            return bl;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        if (OkHeaders.contentLength(response) != -1L) return true;
        if (!"chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void maybeCache() throws IOException {
        InternalCache internalCache = Internal.instance.internalCache(this.client);
        if (internalCache == null) {
            return;
        }
        if (!CacheStrategy.isCacheable(this.userResponse, this.networkRequest)) {
            if (!HttpMethod.invalidatesCache(this.networkRequest.method())) return;
            try {
                internalCache.remove(this.networkRequest);
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        this.storeRequest = internalCache.put(HttpEngine.stripBody(this.userResponse));
    }

    private Request networkRequest(Request request) throws IOException {
        CookieHandler cookieHandler;
        Request.Builder builder = request.newBuilder();
        if (request.header("Host") == null) {
            builder.header("Host", Util.hostHeader(request.httpUrl()));
        }
        if (request.header("Connection") == null) {
            builder.header("Connection", "Keep-Alive");
        }
        if (request.header("Accept-Encoding") == null) {
            this.transparentGzip = true;
            builder.header("Accept-Encoding", "gzip");
        }
        if ((cookieHandler = this.client.getCookieHandler()) != null) {
            Map<String, List<String>> map = OkHeaders.toMultimap(builder.build().headers(), null);
            OkHeaders.addCookies(builder, cookieHandler.get(request.uri(), map));
        }
        if (request.header("User-Agent") == null) {
            builder.header("User-Agent", Version.userAgent());
        }
        return builder.build();
    }

    private Response readNetworkResponse() throws IOException {
        Response response;
        this.httpStream.finishRequest();
        Response response2 = response = this.httpStream.readResponseHeaders().request(this.networkRequest).handshake(this.streamAllocation.connection().getHandshake()).header(OkHeaders.SENT_MILLIS, Long.toString(this.sentRequestMillis)).header(OkHeaders.RECEIVED_MILLIS, Long.toString(System.currentTimeMillis())).build();
        if (!this.forWebSocket) {
            response2 = response.newBuilder().body(this.httpStream.openResponseBody(response)).build();
        }
        if ("close".equalsIgnoreCase(response2.request().header("Connection")) || "close".equalsIgnoreCase(response2.header("Connection"))) {
            this.streamAllocation.noNewStreams();
        }
        return response2;
    }

    private static Response stripBody(Response response) {
        Response response2 = response;
        if (response != null) {
            response2 = response;
            if (response.body() != null) {
                response2 = response.newBuilder().body(null).build();
            }
        }
        return response2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response unzip(Response response) throws IOException {
        Object object = response;
        if (!this.transparentGzip) return object;
        if (!"gzip".equalsIgnoreCase(this.userResponse.header("Content-Encoding"))) {
            return response;
        }
        object = response;
        if (response.body() == null) return object;
        k k2 = new k((t)response.body().source());
        object = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
        return response.newBuilder().headers((Headers)object).body(new RealResponseBody((Headers)object, m.a((t)k2))).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean validate(Response object, Response object2) {
        boolean bl = true;
        if (((Response)object2).code() == 304) {
            return bl;
        }
        if ((object = ((Response)object).headers().getDate("Last-Modified")) == null) return false;
        if ((object2 = ((Response)object2).headers().getDate("Last-Modified")) == null) return false;
        if (((Date)object2).getTime() < ((Date)object).getTime()) return bl;
        return false;
    }

    public void cancel() {
        this.streamAllocation.cancel();
    }

    /*
     * Enabled aggressive block sorting
     */
    public StreamAllocation close() {
        if (this.bufferedRequestBody != null) {
            Util.closeQuietly((Closeable)this.bufferedRequestBody);
        } else if (this.requestBodyOut != null) {
            Util.closeQuietly((Closeable)this.requestBodyOut);
        }
        if (this.userResponse != null) {
            Util.closeQuietly(this.userResponse.body());
            return this.streamAllocation;
        }
        this.streamAllocation.connectionFailed();
        return this.streamAllocation;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Request followUpRequest() throws IOException {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        Object object = this.streamAllocation.connection();
        object = object != null ? object.getRoute() : null;
        object = object != null ? ((Route)object).getProxy() : this.client.getProxy();
        int n2 = this.userResponse.code();
        String string2 = this.userRequest.method();
        switch (n2) {
            default: {
                return null;
            }
            case 407: {
                if (((Proxy)object).type() == Proxy.Type.HTTP) return OkHeaders.processAuthHeader(this.client.getAuthenticator(), this.userResponse, (Proxy)object);
                throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
            }
            case 401: {
                return OkHeaders.processAuthHeader(this.client.getAuthenticator(), this.userResponse, (Proxy)object);
            }
            case 307: 
            case 308: {
                if (string2.equals("GET") || string2.equals("HEAD")) break;
                return null;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
        }
        if (!this.client.getFollowRedirects()) {
            return null;
        }
        object = this.userResponse.header("Location");
        if (object == null) {
            return null;
        }
        object = this.userRequest.httpUrl().resolve((String)object);
        if (object == null) {
            return null;
        }
        if (!((HttpUrl)object).scheme().equals(this.userRequest.httpUrl().scheme()) && !this.client.getFollowSslRedirects()) {
            return null;
        }
        Request.Builder builder = this.userRequest.newBuilder();
        if (HttpMethod.permitsRequestBody(string2)) {
            if (HttpMethod.redirectsToGet(string2)) {
                builder.method("GET", null);
            } else {
                builder.method(string2, null);
            }
            builder.removeHeader("Transfer-Encoding");
            builder.removeHeader("Content-Length");
            builder.removeHeader("Content-Type");
        }
        if (this.sameConnection((HttpUrl)object)) return builder.url((HttpUrl)object).build();
        builder.removeHeader("Authorization");
        return builder.url((HttpUrl)object).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public d getBufferedRequestBody() {
        d d2 = this.bufferedRequestBody;
        if (d2 != null) {
            return d2;
        }
        d2 = this.getRequestBody();
        if (d2 == null) return null;
        this.bufferedRequestBody = d2 = m.a((s)d2);
        return d2;
    }

    public Connection getConnection() {
        return this.streamAllocation.connection();
    }

    public Request getRequest() {
        return this.userRequest;
    }

    public s getRequestBody() {
        if (this.cacheStrategy == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public Response getResponse() {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        return this.userResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasResponse() {
        if (this.userResponse == null) return false;
        return true;
    }

    boolean permitsRequestBody(Request request) {
        return HttpMethod.permitsRequestBody(request.method());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readResponse() throws IOException {
        Object object;
        if (this.userResponse != null) {
            return;
        }
        if (this.networkRequest == null && this.cacheResponse == null) {
            throw new IllegalStateException("call sendRequest() first!");
        }
        if (this.networkRequest == null) return;
        if (this.forWebSocket) {
            this.httpStream.writeRequestHeaders(this.networkRequest);
            object = this.readNetworkResponse();
        } else if (!this.callerWritesRequestBody) {
            object = new NetworkInterceptorChain(0, this.networkRequest).proceed(this.networkRequest);
        } else {
            if (this.bufferedRequestBody != null && this.bufferedRequestBody.b().a() > 0L) {
                this.bufferedRequestBody.d();
            }
            if (this.sentRequestMillis == -1L) {
                if (OkHeaders.contentLength(this.networkRequest) == -1L && this.requestBodyOut instanceof RetryableSink) {
                    long l2 = ((RetryableSink)this.requestBodyOut).contentLength();
                    this.networkRequest = this.networkRequest.newBuilder().header("Content-Length", Long.toString(l2)).build();
                }
                this.httpStream.writeRequestHeaders(this.networkRequest);
            }
            if (this.requestBodyOut != null) {
                if (this.bufferedRequestBody != null) {
                    this.bufferedRequestBody.close();
                } else {
                    this.requestBodyOut.close();
                }
                if (this.requestBodyOut instanceof RetryableSink) {
                    this.httpStream.writeRequestBody((RetryableSink)this.requestBodyOut);
                }
            }
            object = this.readNetworkResponse();
        }
        this.receiveHeaders(((Response)object).headers());
        if (this.cacheResponse != null) {
            if (HttpEngine.validate(this.cacheResponse, (Response)object)) {
                this.userResponse = this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).headers(HttpEngine.combine(this.cacheResponse.headers(), ((Response)object).headers())).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody((Response)object)).build();
                ((Response)object).body().close();
                this.releaseStreamAllocation();
                object = Internal.instance.internalCache(this.client);
                object.trackConditionalCacheHit();
                object.update(this.cacheResponse, HttpEngine.stripBody(this.userResponse));
                this.userResponse = this.unzip(this.userResponse);
                return;
            }
            Util.closeQuietly(this.cacheResponse.body());
        }
        this.userResponse = ((Response)object).newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody((Response)object)).build();
        if (!HttpEngine.hasBody(this.userResponse)) return;
        this.maybeCache();
        this.userResponse = this.unzip(this.cacheWritingResponse(this.storeRequest, this.userResponse));
    }

    public void receiveHeaders(Headers headers) throws IOException {
        CookieHandler cookieHandler = this.client.getCookieHandler();
        if (cookieHandler != null) {
            cookieHandler.put(this.userRequest.uri(), OkHeaders.toMultimap(headers, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpEngine recover(RouteException object) {
        Object var2_2 = null;
        if (!this.streamAllocation.recover((RouteException)object)) {
            return var2_2;
        }
        object = var2_2;
        if (!this.client.getRetryOnConnectionFailure()) return object;
        object = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, this.callerWritesRequestBody, this.forWebSocket, (StreamAllocation)object, (RetryableSink)this.requestBodyOut, this.priorResponse);
    }

    public HttpEngine recover(IOException iOException) {
        return this.recover(iOException, this.requestBodyOut);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpEngine recover(IOException object, s s2) {
        Object var3_3 = null;
        if (!this.streamAllocation.recover((IOException)object, s2)) {
            return var3_3;
        }
        object = var3_3;
        if (!this.client.getRetryOnConnectionFailure()) return object;
        object = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, this.callerWritesRequestBody, this.forWebSocket, (StreamAllocation)object, (RetryableSink)s2, this.priorResponse);
    }

    public void releaseStreamAllocation() throws IOException {
        this.streamAllocation.release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sameConnection(HttpUrl httpUrl) {
        HttpUrl httpUrl2 = this.userRequest.httpUrl();
        if (!httpUrl2.host().equals(httpUrl.host())) return false;
        if (httpUrl2.port() != httpUrl.port()) return false;
        if (!httpUrl2.scheme().equals(httpUrl.scheme())) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendRequest() throws RequestException, RouteException, IOException {
        if (this.cacheStrategy != null) {
            return;
        }
        if (this.httpStream != null) {
            throw new IllegalStateException();
        }
        Request request = this.networkRequest(this.userRequest);
        InternalCache internalCache = Internal.instance.internalCache(this.client);
        Response response = internalCache != null ? internalCache.get(request) : null;
        this.cacheStrategy = new CacheStrategy.Factory(System.currentTimeMillis(), request, response).get();
        this.networkRequest = this.cacheStrategy.networkRequest;
        this.cacheResponse = this.cacheStrategy.cacheResponse;
        if (internalCache != null) {
            internalCache.trackResponse(this.cacheStrategy);
        }
        if (response != null && this.cacheResponse == null) {
            Util.closeQuietly(response.body());
        }
        if (this.networkRequest != null) {
            this.httpStream = this.connect();
            this.httpStream.setHttpEngine(this);
            if (!this.callerWritesRequestBody) return;
            if (!this.permitsRequestBody(this.networkRequest)) return;
            if (this.requestBodyOut != null) return;
            long l2 = OkHeaders.contentLength(request);
            if (!this.bufferRequestBody) {
                this.httpStream.writeRequestHeaders(this.networkRequest);
                this.requestBodyOut = this.httpStream.createRequestBody(this.networkRequest, l2);
                return;
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalStateException("Use setFixedLengthStreamingMode() or setChunkedStreamingMode() for requests larger than 2 GiB.");
            }
            if (l2 != -1L) {
                this.httpStream.writeRequestHeaders(this.networkRequest);
                this.requestBodyOut = new RetryableSink((int)l2);
                return;
            }
            this.requestBodyOut = new RetryableSink();
            return;
        }
        this.userResponse = this.cacheResponse != null ? this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).build() : new Response.Builder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(EMPTY_BODY).build();
        this.userResponse = this.unzip(this.userResponse);
    }

    public void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    class NetworkInterceptorChain
    implements Interceptor.Chain {
        private int calls;
        private final int index;
        private final Request request;

        NetworkInterceptorChain(int n2, Request request) {
            this.index = n2;
            this.request = request;
        }

        @Override
        public Connection connection() {
            return HttpEngine.this.streamAllocation.connection();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Response proceed(Request object) throws IOException {
            int n2;
            Object object2;
            Object object3;
            ++this.calls;
            if (this.index > 0) {
                object3 = HttpEngine.this.client.networkInterceptors().get(this.index - 1);
                object2 = this.connection().getRoute().getAddress();
                if (!((Request)object).httpUrl().host().equals(object2.getUriHost()) || ((Request)object).httpUrl().port() != object2.getUriPort()) {
                    throw new IllegalStateException("network interceptor " + object3 + " must retain the same host and port");
                }
                if (this.calls > 1) {
                    throw new IllegalStateException("network interceptor " + object3 + " must call proceed() exactly once");
                }
            }
            if (this.index < HttpEngine.this.client.networkInterceptors().size()) {
                object3 = new NetworkInterceptorChain(this.index + 1, (Request)object);
                object2 = HttpEngine.this.client.networkInterceptors().get(this.index);
                object = object2.intercept((Interceptor.Chain)object3);
                if (((NetworkInterceptorChain)object3).calls != 1) {
                    throw new IllegalStateException("network interceptor " + object2 + " must call proceed() exactly once");
                }
                if (object != null) return object;
                throw new NullPointerException("network interceptor " + object2 + " returned null");
            }
            HttpEngine.this.httpStream.writeRequestHeaders((Request)object);
            HttpEngine.access$102(HttpEngine.this, (Request)object);
            if (HttpEngine.this.permitsRequestBody((Request)object) && ((Request)object).body() != null) {
                object3 = m.a((s)HttpEngine.this.httpStream.createRequestBody((Request)object, ((Request)object).body().contentLength()));
                ((Request)object).body().writeTo((d)object3);
                object3.close();
            }
            if ((n2 = ((Response)(object3 = HttpEngine.this.readNetworkResponse())).code()) != 204) {
                object = object3;
                if (n2 != 205) return object;
            }
            object = object3;
            if (((Response)object3).body().contentLength() > 0L) throw new ProtocolException("HTTP " + n2 + " had non-zero Content-Length: " + ((Response)object3).body().contentLength());
            return object;
        }

        @Override
        public Request request() {
            return this.request;
        }
    }
}

