/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.tls;

import javax.security.auth.x500.X500Principal;

final class DistinguishedNameParser {
    private int beg;
    private char[] chars;
    private int cur;
    private final String dn;
    private int end;
    private final int length;
    private int pos;

    public DistinguishedNameParser(X500Principal x500Principal) {
        this.dn = x500Principal.getName("RFC2253");
        this.length = this.dn.length();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String escapedAV() {
        void var1_3;
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (true) {
            int n2;
            if (this.pos >= this.length) {
                String string2 = new String(this.chars, this.beg, this.end - this.beg);
                return var1_3;
            }
            switch (this.chars[this.pos]) {
                default: {
                    char[] cArray = this.chars;
                    n2 = this.end;
                    this.end = n2 + 1;
                    cArray[n2] = this.chars[this.pos];
                    ++this.pos;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    String string3 = new String(this.chars, this.beg, this.end - this.beg);
                    return var1_3;
                }
                case '\\': {
                    char[] cArray = this.chars;
                    n2 = this.end;
                    this.end = n2 + 1;
                    cArray[n2] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': 
            }
            this.cur = this.end;
            ++this.pos;
            char[] cArray = this.chars;
            n2 = this.end;
            this.end = n2 + 1;
            cArray[n2] = (char)32;
            while (this.pos < this.length && this.chars[this.pos] == ' ') {
                char[] cArray2 = this.chars;
                n2 = this.end;
                this.end = n2 + 1;
                cArray2[n2] = (char)32;
                ++this.pos;
            }
            if (this.pos == this.length || this.chars[this.pos] == ',' || this.chars[this.pos] == '+' || this.chars[this.pos] == ';') break;
        }
        String string4 = new String(this.chars, this.beg, this.cur - this.beg);
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getByte(int n2) {
        if (n2 + 1 >= this.length) {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int n3 = this.chars[n2];
        if (n3 >= 48 && n3 <= 57) {
            n3 -= 48;
        } else if (n3 >= 97 && n3 <= 102) {
            n3 -= 87;
        } else {
            if (n3 < 65) throw new IllegalStateException("Malformed DN: " + this.dn);
            if (n3 > 70) throw new IllegalStateException("Malformed DN: " + this.dn);
            n3 -= 55;
        }
        if ((n2 = this.chars[n2 + 1]) >= 48 && n2 <= 57) {
            n2 -= 48;
            return (n3 << 4) + n2;
        }
        if (n2 >= 97 && n2 <= 102) {
            return (n3 << 4) + (n2 -= 87);
        }
        if (n2 < 65) throw new IllegalStateException("Malformed DN: " + this.dn);
        if (n2 > 70) throw new IllegalStateException("Malformed DN: " + this.dn);
        return (n3 << 4) + (n2 -= 55);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char getEscaped() {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        switch (this.chars[this.pos]) {
            default: {
                char c2 = this.getUTF8();
                return c2;
            }
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': 
        }
        char c3 = this.chars[this.pos];
        return c3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char getUTF8() {
        int n2;
        int n3 = this.getByte(this.pos);
        ++this.pos;
        if (n3 < 128) {
            return (char)(n3 = (int)((char)n3));
        }
        if (n3 < 192) return (char)(n3 = 63);
        if (n3 > 247) return (char)(n3 = 63);
        if (n3 <= 223) {
            n2 = 1;
            n3 &= 0x1F;
        } else if (n3 <= 239) {
            n2 = 2;
            n3 &= 0xF;
        } else {
            n2 = 3;
            n3 &= 7;
        }
        int n4 = 0;
        while (n4 < n2) {
            ++this.pos;
            n3 = 63;
            if (this.pos == this.length) return (char)n3;
            if (this.chars[this.pos] != '\\') {
                return (char)n3;
            }
            ++this.pos;
            int n5 = this.getByte(this.pos);
            ++this.pos;
            if ((n5 & 0xC0) != 128) {
                n3 = 63;
                return (char)n3;
            }
            n3 = (n3 << 6) + (n5 & 0x3F);
            ++n4;
        }
        return (char)(n3 = (int)((char)n3));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String hexAV() {
        int n2;
        int n3;
        if (this.pos + 4 >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.beg = this.pos++;
        while (true) {
            block9: {
                block8: {
                    block7: {
                        if (this.pos != this.length && this.chars[this.pos] != '+' && this.chars[this.pos] != ',' && this.chars[this.pos] != ';') break block7;
                        this.end = this.pos;
                        break block8;
                    }
                    if (this.chars[this.pos] == ' ') {
                        this.end = this.pos++;
                        while (this.pos < this.length && this.chars[this.pos] == ' ') {
                            ++this.pos;
                        }
                    }
                    break block9;
                }
                if ((n3 = this.end - this.beg) >= 5 && (n3 & 1) != 0) break;
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                char[] cArray = this.chars;
                n2 = this.pos;
                cArray[n2] = (char)(cArray[n2] + 32);
            }
            ++this.pos;
        }
        byte[] byArray = new byte[n3 / 2];
        n2 = 0;
        int n4 = this.beg + 1;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)this.getByte(n4);
            n4 += 2;
            ++n2;
        }
        return new String(this.chars, this.beg, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String nextAT() {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=') throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            if (this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
        }
        ++this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.end - this.beg <= 4) return new String(this.chars, this.beg, this.end - this.beg);
        if (this.chars[this.beg + 3] != '.') return new String(this.chars, this.beg, this.end - this.beg);
        if (this.chars[this.beg] != 'O') {
            if (this.chars[this.beg] != 'o') return new String(this.chars, this.beg, this.end - this.beg);
        }
        if (this.chars[this.beg + 1] != 'I') {
            if (this.chars[this.beg + 1] != 'i') return new String(this.chars, this.beg, this.end - this.beg);
        }
        if (this.chars[this.beg + 2] != 'D') {
            if (this.chars[this.beg + 2] != 'd') return new String(this.chars, this.beg, this.end - this.beg);
        }
        this.beg += 4;
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String quotedAV() {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                return new String(this.chars, this.beg, this.end - this.beg);
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : (char)this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String findMostSpecific(String string2) {
        String string3;
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        String string4 = string3 = this.nextAT();
        if (string3 == null) {
            return null;
        }
        do {
            string3 = "";
            if (this.pos == this.length) {
                return null;
            }
            switch (this.chars[this.pos]) {
                default: {
                    string3 = this.escapedAV();
                    break;
                }
                case '\"': {
                    string3 = this.quotedAV();
                    break;
                }
                case '#': {
                    string3 = this.hexAV();
                }
                case '+': 
                case ',': 
                case ';': 
            }
            if (string2.equalsIgnoreCase(string4)) return string3;
            if (this.pos >= this.length) {
                return null;
            }
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            ++this.pos;
            string4 = string3 = this.nextAT();
        } while (string3 != null);
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }
}

