/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.UriMatcher;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContactsPhotoBitmapHunter
extends BitmapHunter {
    private static final int ID_CONTACT = 3;
    private static final int ID_DISPLAY_PHOTO = 4;
    private static final int ID_LOOKUP = 1;
    private static final int ID_THUMBNAIL = 2;
    private static final UriMatcher matcher = new UriMatcher(-1);
    final Context context;

    static {
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1);
        matcher.addURI("com.android.contacts", "contacts/lookup/*", 1);
        matcher.addURI("com.android.contacts", "contacts/#/photo", 2);
        matcher.addURI("com.android.contacts", "contacts/#", 3);
        matcher.addURI("com.android.contacts", "display_photo/#", 4);
    }

    ContactsPhotoBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bitmap decodeStream(InputStream inputStream, Request request) throws IOException {
        InputStream inputStream2 = null;
        if (inputStream == null) {
            return inputStream2;
        }
        BitmapFactory.Options options = ContactsPhotoBitmapHunter.createBitmapOptions(request);
        if (!request.hasSize()) return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = true;
        inputStream2 = this.getInputStream();
        BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)options);
        ContactsPhotoBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, options);
        return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        finally {
            Utils.closeQuietly(inputStream2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStream() throws IOException {
        void var3_6;
        Uri uri;
        ContentResolver contentResolver = this.context.getContentResolver();
        Uri uri2 = uri = this.getData().uri;
        switch (matcher.match(uri)) {
            default: {
                throw new IllegalStateException("Invalid uri: " + uri);
            }
            case 1: {
                Uri uri3 = uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri);
                if (uri == null) {
                    return var3_6;
                }
            }
            case 3: {
                void var3_7;
                if (Build.VERSION.SDK_INT < 14) {
                    InputStream inputStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)var3_7);
                    return var3_6;
                }
                InputStream inputStream = ContactPhotoStreamIcs.get(contentResolver, (Uri)var3_7);
                return var3_6;
            }
            case 2: 
            case 4: 
        }
        InputStream inputStream = contentResolver.openInputStream(uri);
        return var3_6;
    }

    @Override
    Bitmap decode(Request request) throws IOException {
        InputStream inputStream;
        InputStream inputStream2 = null;
        try {
            inputStream2 = inputStream = this.getInputStream();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(inputStream2);
            throw throwable;
        }
        request = this.decodeStream(inputStream, request);
        Utils.closeQuietly(inputStream);
        return request;
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.b;
    }

    @TargetApi(value=14)
    private static class ContactPhotoStreamIcs {
        private ContactPhotoStreamIcs() {
        }

        static InputStream get(ContentResolver contentResolver, Uri uri) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
    }
}

