/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContentStreamBitmapHunter
extends BitmapHunter {
    final Context context;

    ContentStreamBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    @Override
    Bitmap decode(Request request) throws IOException {
        return this.decodeContentStream(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bitmap decodeContentStream(Request object) throws IOException {
        InputStream inputStream = null;
        ContentResolver contentResolver = this.context.getContentResolver();
        BitmapFactory.Options options = ContentStreamBitmapHunter.createBitmapOptions((Request)object);
        if (((Request)object).hasSize()) {
            InputStream inputStream2;
            options.inJustDecodeBounds = true;
            try {
                inputStream = inputStream2 = contentResolver.openInputStream(((Request)object).uri);
                BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)options);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(inputStream);
                throw throwable;
            }
            Utils.closeQuietly(inputStream2);
            ContentStreamBitmapHunter.calculateInSampleSize(((Request)object).targetWidth, ((Request)object).targetHeight, options);
        }
        object = contentResolver.openInputStream(((Request)object).uri);
        try {
            inputStream = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options);
            return inputStream;
        }
        finally {
            Utils.closeQuietly((InputStream)object);
        }
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.b;
    }
}

