/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.RequestCreator;
import java.lang.ref.WeakReference;

class DeferredRequestCreator
implements ViewTreeObserver.OnPreDrawListener {
    Callback callback;
    final RequestCreator creator;
    final WeakReference<ImageView> target;

    DeferredRequestCreator(RequestCreator requestCreator, ImageView imageView) {
        this(requestCreator, imageView, null);
    }

    DeferredRequestCreator(RequestCreator requestCreator, ImageView imageView, Callback callback) {
        this.creator = requestCreator;
        this.target = new WeakReference<ImageView>(imageView);
        this.callback = callback;
        imageView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    void cancel() {
        this.callback = null;
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return;
        }
        if (!(imageView = imageView.getViewTreeObserver()).isAlive()) return;
        imageView.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onPreDraw() {
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return true;
        }
        ViewTreeObserver viewTreeObserver = imageView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) return true;
        int n2 = imageView.getMeasuredWidth();
        int n3 = imageView.getMeasuredHeight();
        if (n2 <= 0) return true;
        if (n3 <= 0) return true;
        viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.creator.unfit().resize(n2, n3).into(imageView, this.callback);
        return true;
    }
}

