/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoExecutorService;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

class Dispatcher {
    static final int AIRPLANE_MODE_CHANGE = 10;
    private static final int AIRPLANE_MODE_OFF = 0;
    private static final int AIRPLANE_MODE_ON = 1;
    private static final int BATCH_DELAY = 200;
    private static final String DISPATCHER_THREAD_NAME = "Dispatcher";
    static final int HUNTER_BATCH_COMPLETE = 8;
    static final int HUNTER_COMPLETE = 4;
    static final int HUNTER_DECODE_FAILED = 6;
    static final int HUNTER_DELAY_NEXT_BATCH = 7;
    static final int HUNTER_RETRY = 5;
    static final int NETWORK_STATE_CHANGE = 9;
    static final int REQUEST_CANCEL = 2;
    static final int REQUEST_GCED = 3;
    static final int REQUEST_SUBMIT = 1;
    private static final int RETRY_DELAY = 500;
    boolean airplaneMode;
    final List<BitmapHunter> batch;
    final Cache cache;
    final Context context;
    final DispatcherThread dispatcherThread = new DispatcherThread();
    final Downloader downloader;
    final Handler handler;
    final Map<String, BitmapHunter> hunterMap;
    final Handler mainThreadHandler;
    NetworkInfo networkInfo;
    final NetworkBroadcastReceiver receiver;
    final ExecutorService service;
    final Stats stats;

    Dispatcher(Context context, ExecutorService executorService, Handler handler, Downloader downloader, Cache cache, Stats stats) {
        this.dispatcherThread.start();
        this.context = context;
        this.service = executorService;
        this.hunterMap = new LinkedHashMap<String, BitmapHunter>();
        this.handler = new DispatcherHandler(this.dispatcherThread.getLooper(), this);
        this.downloader = downloader;
        this.mainThreadHandler = handler;
        this.cache = cache;
        this.stats = stats;
        this.batch = new ArrayList<BitmapHunter>(4);
        this.airplaneMode = Utils.isAirplaneModeOn(this.context);
        this.receiver = new NetworkBroadcastReceiver(this.context);
        this.receiver.register();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void batch(BitmapHunter bitmapHunter) {
        if (bitmapHunter.isCancelled()) {
            return;
        }
        this.batch.add(bitmapHunter);
        if (this.handler.hasMessages(7)) return;
        this.handler.sendEmptyMessageDelayed(7, 200L);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dispatchAirplaneModeChange(boolean bl) {
        Handler handler = this.handler;
        Handler handler2 = this.handler;
        int n2 = bl ? 1 : 0;
        handler.sendMessage(handler2.obtainMessage(10, n2, 0));
    }

    void dispatchCancel(Action action) {
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)action));
    }

    void dispatchComplete(BitmapHunter bitmapHunter) {
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)bitmapHunter));
    }

    void dispatchFailed(BitmapHunter bitmapHunter) {
        this.handler.sendMessage(this.handler.obtainMessage(6, (Object)bitmapHunter));
    }

    void dispatchNetworkStateChange(NetworkInfo networkInfo) {
        this.handler.sendMessage(this.handler.obtainMessage(9, (Object)networkInfo));
    }

    void dispatchRetry(BitmapHunter bitmapHunter) {
        this.handler.sendMessageDelayed(this.handler.obtainMessage(5, (Object)bitmapHunter), 500L);
    }

    void dispatchSubmit(Action action) {
        this.handler.sendMessage(this.handler.obtainMessage(1, (Object)action));
    }

    void performAirplaneModeChange(boolean bl) {
        this.airplaneMode = bl;
    }

    void performBatchComplete() {
        ArrayList<BitmapHunter> arrayList = new ArrayList<BitmapHunter>(this.batch);
        this.batch.clear();
        this.mainThreadHandler.sendMessage(this.mainThreadHandler.obtainMessage(8, arrayList));
    }

    void performCancel(Action action) {
        String string2 = action.getKey();
        BitmapHunter bitmapHunter = this.hunterMap.get(string2);
        if (bitmapHunter != null) {
            bitmapHunter.detach(action);
            if (bitmapHunter.cancel()) {
                this.hunterMap.remove(string2);
            }
        }
    }

    void performComplete(BitmapHunter bitmapHunter) {
        if (!bitmapHunter.shouldSkipMemoryCache()) {
            this.cache.set(bitmapHunter.getKey(), bitmapHunter.getResult());
        }
        this.hunterMap.remove(bitmapHunter.getKey());
        this.batch(bitmapHunter);
    }

    void performError(BitmapHunter bitmapHunter) {
        this.hunterMap.remove(bitmapHunter.getKey());
        this.batch(bitmapHunter);
    }

    void performNetworkStateChange(NetworkInfo networkInfo) {
        this.networkInfo = networkInfo;
        if (this.service instanceof PicassoExecutorService) {
            ((PicassoExecutorService)this.service).adjustThreadCount(networkInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void performRetry(BitmapHunter bitmapHunter) {
        if (bitmapHunter.isCancelled()) {
            return;
        }
        if (this.service.isShutdown()) {
            this.performError(bitmapHunter);
            return;
        }
        if (bitmapHunter.shouldRetry(this.airplaneMode, this.networkInfo)) {
            bitmapHunter.future = this.service.submit(bitmapHunter);
            return;
        }
        this.performError(bitmapHunter);
    }

    /*
     * Enabled aggressive block sorting
     */
    void performSubmit(Action action) {
        BitmapHunter bitmapHunter = this.hunterMap.get(action.getKey());
        if (bitmapHunter != null) {
            bitmapHunter.attach(action);
            return;
        }
        if (this.service.isShutdown()) return;
        bitmapHunter = BitmapHunter.forRequest(this.context, action.getPicasso(), this, this.cache, this.stats, action, this.downloader);
        bitmapHunter.future = this.service.submit(bitmapHunter);
        this.hunterMap.put(action.getKey(), bitmapHunter);
    }

    void shutdown() {
        this.service.shutdown();
        this.dispatcherThread.quit();
        this.receiver.unregister();
    }

    private static class DispatcherHandler
    extends Handler {
        private final Dispatcher dispatcher;

        public DispatcherHandler(Looper looper, Dispatcher dispatcher) {
            super(looper);
            this.dispatcher = dispatcher;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message object) {
            boolean bl = true;
            switch (object.what) {
                default: {
                    Picasso.HANDLER.post(new Runnable((Message)object){
                        final /* synthetic */ Message val$msg;
                        {
                            this.val$msg = message;
                        }

                        @Override
                        public void run() {
                            throw new AssertionError((Object)("Unknown handler message received: " + this.val$msg.what));
                        }
                    });
                    return;
                }
                case 1: {
                    Action action = (Action)object.obj;
                    this.dispatcher.performSubmit(action);
                    return;
                }
                case 2: {
                    Action action = (Action)object.obj;
                    this.dispatcher.performCancel(action);
                    return;
                }
                case 4: {
                    BitmapHunter bitmapHunter = (BitmapHunter)object.obj;
                    this.dispatcher.performComplete(bitmapHunter);
                    return;
                }
                case 5: {
                    BitmapHunter bitmapHunter = (BitmapHunter)object.obj;
                    this.dispatcher.performRetry(bitmapHunter);
                    return;
                }
                case 6: {
                    BitmapHunter bitmapHunter = (BitmapHunter)object.obj;
                    this.dispatcher.performError(bitmapHunter);
                    return;
                }
                case 7: {
                    this.dispatcher.performBatchComplete();
                    return;
                }
                case 9: {
                    NetworkInfo networkInfo = (NetworkInfo)object.obj;
                    this.dispatcher.performNetworkStateChange(networkInfo);
                    return;
                }
                case 10: 
            }
            Dispatcher dispatcher = this.dispatcher;
            if (object.arg1 != 1) {
                bl = false;
            }
            dispatcher.performAirplaneModeChange(bl);
        }
    }

    static class DispatcherThread
    extends HandlerThread {
        DispatcherThread() {
            super("Picasso-Dispatcher", 10);
        }
    }

    private class NetworkBroadcastReceiver
    extends BroadcastReceiver {
        private static final String EXTRA_AIRPLANE_STATE = "state";
        private final ConnectivityManager connectivityManager;

        NetworkBroadcastReceiver(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReceive(Context object, Intent intent) {
            Bundle bundle;
            if (bundle == null) {
                return;
            }
            String string2 = bundle.getAction();
            bundle = bundle.getExtras();
            if ("android.intent.action.AIRPLANE_MODE".equals(string2)) {
                Dispatcher.this.dispatchAirplaneModeChange(bundle.getBoolean(EXTRA_AIRPLANE_STATE, false));
                return;
            }
            if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(string2)) return;
            Dispatcher.this.dispatchNetworkStateChange(this.connectivityManager.getActiveNetworkInfo());
        }

        /*
         * Enabled aggressive block sorting
         */
        void register() {
            boolean bl = Dispatcher.this.service instanceof PicassoExecutorService && Utils.hasPermission(Dispatcher.this.context, "android.permission.ACCESS_NETWORK_STATE");
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.AIRPLANE_MODE");
            if (bl) {
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
            Dispatcher.this.context.registerReceiver((BroadcastReceiver)this, intentFilter);
        }

        void unregister() {
            Dispatcher.this.context.unregisterReceiver((BroadcastReceiver)this);
        }
    }
}

