/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.NetworkInfo;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.MarkableInputStream;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkBitmapHunter
extends BitmapHunter {
    static final int DEFAULT_RETRY_COUNT = 2;
    private static final int MARKER = 65536;
    private final Downloader downloader;
    int retryCount;

    public NetworkBitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        super(picasso, dispatcher, cache, stats, action);
        this.downloader = downloader;
        this.retryCount = 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bitmap decodeStream(InputStream inputStream, Request request) throws IOException {
        Object object = null;
        if (inputStream == null) {
            return object;
        }
        object = new MarkableInputStream(inputStream);
        long l2 = ((MarkableInputStream)object).savePosition(65536);
        boolean bl = Utils.isWebPFile((InputStream)object);
        ((MarkableInputStream)object).reset(l2);
        if (bl) {
            object = Utils.toByteArray((InputStream)object);
            inputStream = NetworkBitmapHunter.createBitmapOptions(request);
            if (!request.hasSize()) return BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length, (BitmapFactory.Options)inputStream);
            ((BitmapFactory.Options)inputStream).inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length, (BitmapFactory.Options)inputStream);
            NetworkBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, (BitmapFactory.Options)inputStream);
            return BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length, (BitmapFactory.Options)inputStream);
        }
        inputStream = NetworkBitmapHunter.createBitmapOptions(request);
        if (!request.hasSize()) return BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)inputStream);
        ((BitmapFactory.Options)inputStream).inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)inputStream);
        NetworkBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, (BitmapFactory.Options)inputStream);
        ((MarkableInputStream)object).reset(l2);
        return BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Bitmap decode(Request request) throws IOException {
        boolean bl = this.retryCount == 0;
        Downloader.Response response = this.downloader.load(request.uri, bl);
        if (response == null) {
            return null;
        }
        Picasso.LoadedFrom loadedFrom = response.cached ? Picasso.LoadedFrom.b : Picasso.LoadedFrom.c;
        this.loadedFrom = loadedFrom;
        Bitmap bitmap = response.getBitmap();
        loadedFrom = bitmap;
        if (bitmap != null) return loadedFrom;
        InputStream inputStream = response.getInputStream();
        try {
            loadedFrom = this.decodeStream(inputStream, request);
            return loadedFrom;
        }
        finally {
            Utils.closeQuietly(inputStream);
            return loadedFrom;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean shouldRetry(boolean bl, NetworkInfo networkInfo) {
        bl = false;
        boolean bl2 = this.retryCount > 0;
        if (!bl2) {
            return bl;
        }
        --this.retryCount;
        if (networkInfo == null) return true;
        if (!networkInfo.isConnectedOrConnecting()) return bl;
        return true;
    }
}

