/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Callback;
import com.squareup.picasso.DeferredRequestCreator;
import com.squareup.picasso.FetchAction;
import com.squareup.picasso.GetAction;
import com.squareup.picasso.ImageViewAction;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Request;
import com.squareup.picasso.Target;
import com.squareup.picasso.TargetAction;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.io.IOException;

public class RequestCreator {
    private final Request.Builder data;
    private boolean deferred;
    private Drawable errorDrawable;
    private int errorResId;
    private boolean noFade;
    private final Picasso picasso;
    private Drawable placeholderDrawable;
    private int placeholderResId;
    private boolean skipMemoryCache;

    RequestCreator() {
        this.picasso = null;
        this.data = new Request.Builder(null, 0);
    }

    RequestCreator(Picasso picasso, Uri uri, int n2) {
        if (picasso.shutdown) {
            throw new IllegalStateException("Picasso instance already shut down. Cannot submit new requests.");
        }
        this.picasso = picasso;
        this.data = new Request.Builder(uri, n2);
    }

    public RequestCreator centerCrop() {
        this.data.centerCrop();
        return this;
    }

    public RequestCreator centerInside() {
        this.data.centerInside();
        return this;
    }

    public RequestCreator config(Bitmap.Config config) {
        this.data.config(config);
        return this;
    }

    public RequestCreator error(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Error image resource invalid.");
        }
        if (this.errorDrawable != null) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorResId = n2;
        return this;
    }

    public RequestCreator error(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Error image may not be null.");
        }
        if (this.errorResId != 0) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorDrawable = drawable2;
        return this;
    }

    public void fetch() {
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with fetch.");
        }
        if (this.data.hasImage()) {
            Request request = this.picasso.transformRequest(this.data.build());
            Object object = Utils.createKey(request);
            object = new FetchAction(this.picasso, request, this.skipMemoryCache, (String)object);
            this.picasso.enqueueAndSubmit((Action)object);
        }
    }

    public RequestCreator fit() {
        this.deferred = true;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap get() throws IOException {
        Utils.checkNotMain();
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with get.");
        }
        if (!this.data.hasImage()) {
            return null;
        }
        Object object = this.picasso.transformRequest(this.data.build());
        String string2 = Utils.createKey((Request)object, new StringBuilder());
        object = new GetAction(this.picasso, (Request)object, this.skipMemoryCache, string2);
        return BitmapHunter.forRequest(this.picasso.context, this.picasso, this.picasso.dispatcher, this.picasso.cache, this.picasso.stats, (Action)object, this.picasso.dispatcher.downloader).hunt();
    }

    public void into(ImageView imageView) {
        this.into(imageView, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void into(ImageView object, Callback callback) {
        Bitmap bitmap;
        void var2_3;
        if (object == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest((ImageView)object);
            PicassoDrawable.setPlaceholder(object, this.placeholderResId, this.placeholderDrawable);
            return;
        }
        if (this.deferred) {
            if (this.data.hasSize()) {
                throw new IllegalStateException("Fit cannot be used with resize.");
            }
            int n2 = object.getMeasuredWidth();
            int n3 = object.getMeasuredHeight();
            if (n2 == 0 || n3 == 0) {
                PicassoDrawable.setPlaceholder(object, this.placeholderResId, this.placeholderDrawable);
                this.picasso.defer((ImageView)object, new DeferredRequestCreator(this, (ImageView)object, (Callback)var2_3));
                return;
            }
            this.data.resize(n2, n3);
        }
        Request request = this.picasso.transformRequest(this.data.build());
        String string2 = Utils.createKey(request);
        if (!this.skipMemoryCache && (bitmap = this.picasso.quickMemoryCacheCheck(string2)) != null) {
            this.picasso.cancelRequest((ImageView)object);
            PicassoDrawable.setBitmap(object, this.picasso.context, bitmap, Picasso.LoadedFrom.a, this.noFade, this.picasso.debugging);
            if (var2_3 == null) return;
            var2_3.onSuccess();
            return;
        }
        PicassoDrawable.setPlaceholder(object, this.placeholderResId, this.placeholderDrawable);
        ImageViewAction imageViewAction = new ImageViewAction(this.picasso, (ImageView)object, request, this.skipMemoryCache, this.noFade, this.errorResId, this.errorDrawable, string2, (Callback)var2_3);
        this.picasso.enqueueAndSubmit(imageViewAction);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void into(Target object) {
        Bitmap bitmap;
        if (object == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with a Target.");
        }
        Drawable drawable2 = this.placeholderResId != 0 ? this.picasso.context.getResources().getDrawable(this.placeholderResId) : this.placeholderDrawable;
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest((Target)object);
            object.onPrepareLoad(drawable2);
            return;
        }
        Request request = this.picasso.transformRequest(this.data.build());
        String string2 = Utils.createKey(request);
        if (!this.skipMemoryCache && (bitmap = this.picasso.quickMemoryCacheCheck(string2)) != null) {
            this.picasso.cancelRequest((Target)object);
            object.onBitmapLoaded(bitmap, Picasso.LoadedFrom.a);
            return;
        }
        object.onPrepareLoad(drawable2);
        object = new TargetAction(this.picasso, (Target)object, request, this.skipMemoryCache, string2);
        this.picasso.enqueueAndSubmit((Action)object);
    }

    public RequestCreator noFade() {
        this.noFade = true;
        return this;
    }

    public RequestCreator placeholder(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Placeholder image resource invalid.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderResId = n2;
        return this;
    }

    public RequestCreator placeholder(Drawable drawable2) {
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderDrawable = drawable2;
        return this;
    }

    public RequestCreator resize(int n2, int n3) {
        this.data.resize(n2, n3);
        return this;
    }

    public RequestCreator resizeDimen(int n2, int n3) {
        Resources resources = this.picasso.context.getResources();
        return this.resize(resources.getDimensionPixelSize(n2), resources.getDimensionPixelSize(n3));
    }

    public RequestCreator rotate(float f2) {
        this.data.rotate(f2);
        return this;
    }

    public RequestCreator rotate(float f2, float f3, float f4) {
        this.data.rotate(f2, f3, f4);
        return this;
    }

    public RequestCreator skipMemoryCache() {
        this.skipMemoryCache = true;
        return this;
    }

    public RequestCreator transform(Transformation transformation) {
        this.data.transform(transformation);
        return this;
    }

    RequestCreator unfit() {
        this.deferred = false;
        return this;
    }
}

