/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelbiz;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.utils.Log;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class AddCardToWXCardPackage {
    private static final String TAG = "MicroMsg.AddCardToWXCardPackage";

    public static class Req
    extends BaseReq {
        public List<WXCardItem> cardArrary;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkArgs() {
            WXCardItem wXCardItem;
            if (this.cardArrary == null) return false;
            if (this.cardArrary.size() == 0) return false;
            if (this.cardArrary.size() > 40) {
                return false;
            }
            Iterator<WXCardItem> iterator = this.cardArrary.iterator();
            do {
                if (!iterator.hasNext()) return true;
                wXCardItem = iterator.next();
                if (wXCardItem == null) return false;
                if (wXCardItem.cardId == null) return false;
                if (wXCardItem.cardId.length() > 1024) return false;
            } while (wXCardItem.cardExtMsg == null || wXCardItem.cardExtMsg.length() <= 1024);
            return false;
        }

        public int getType() {
            return 9;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (Object object : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)((WXCardItem)object).cardId);
                    jSONStringer.key("card_ext");
                    object = ((WXCardItem)object).cardExtMsg == null ? "" : ((WXCardItem)object).cardExtMsg;
                    jSONStringer.value(object);
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                Log.e(AddCardToWXCardPackage.TAG, "Req.toBundle exception:" + exception.getMessage());
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }
    }

    public static class Resp
    extends BaseResp {
        public List<WXCardItem> cardArrary;

        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkArgs() {
            if (this.cardArrary == null) return false;
            if (this.cardArrary.size() != 0) return true;
            return false;
        }

        public void fromBundle(Bundle bundle) {
            Object object;
            super.fromBundle(bundle);
            if (this.cardArrary == null) {
                this.cardArrary = new LinkedList<WXCardItem>();
            }
            if ((object = bundle.getString("_wxapi_add_card_to_wx_card_list")) != null && ((String)object).length() > 0) {
                int n2;
                try {
                    bundle = new JSONTokener((String)object);
                    bundle = ((JSONObject)bundle.nextValue()).getJSONArray("card_list");
                    n2 = 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (true) {
                    if (n2 < bundle.length()) {
                        JSONObject jSONObject = bundle.getJSONObject(n2);
                        object = new WXCardItem();
                        ((WXCardItem)object).cardId = jSONObject.optString("card_id");
                        ((WXCardItem)object).cardExtMsg = jSONObject.optString("card_ext");
                        ((WXCardItem)object).cardState = jSONObject.optInt("is_succ");
                        this.cardArrary.add((WXCardItem)object);
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        }

        public int getType() {
            return 9;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (WXCardItem wXCardItem : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)wXCardItem.cardId);
                    jSONStringer.key("card_ext");
                    String string2 = wXCardItem.cardExtMsg == null ? "" : wXCardItem.cardExtMsg;
                    jSONStringer.value((Object)string2);
                    jSONStringer.key("is_succ");
                    jSONStringer.value((long)wXCardItem.cardState);
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                Log.e(AddCardToWXCardPackage.TAG, "Resp.toBundle exception:" + exception.getMessage());
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }
    }

    public static final class WXCardItem {
        public String cardExtMsg;
        public String cardId;
        public int cardState;
    }
}

